/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.mapstruct.factory.Mappers;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.user.AccountFeatureDTO;
import tech.cassandre.trading.bot.dto.user.BalanceDTO;
import tech.cassandre.trading.bot.dto.user.UserDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.util.mapper.AccountMapper;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;

public class AccountMapperImpl
implements AccountMapper {
    private final CurrencyMapper currencyMapper = (CurrencyMapper)Mappers.getMapper(CurrencyMapper.class);

    @Override
    public UserDTO mapToUserDTO(AccountInfo source) {
        if (source == null) {
            return null;
        }
        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();
        userDTO.id(source.getUsername());
        userDTO.accounts(this.stringWalletMapToStringAccountDTOMap(source.getWallets()));
        if (source.getTimestamp() != null) {
            userDTO.timestamp(ZonedDateTime.ofInstant(source.getTimestamp().toInstant(), ZoneId.systemDefault()));
        }
        return userDTO.build();
    }

    @Override
    public AccountDTO mapToWalletDTO(Wallet source) {
        if (source == null) {
            return null;
        }
        AccountDTO.AccountDTOBuilder accountDTO = AccountDTO.builder();
        accountDTO.accountId(source.getId());
        accountDTO.name(source.getName());
        accountDTO.features(this.walletFeatureSetToAccountFeatureDTOCollection(source.getFeatures()));
        accountDTO.balances(this.mapToCurrencyDTOAndBalanceDTO(source.getBalances()));
        return accountDTO.build();
    }

    @Override
    public Map<CurrencyDTO, BalanceDTO> mapToCurrencyDTOAndBalanceDTO(Map<Currency, Balance> source) {
        if (source == null) {
            return null;
        }
        HashMap<CurrencyDTO, BalanceDTO> map = new HashMap<CurrencyDTO, BalanceDTO>(Math.max((int)((float)source.size() / 0.75f) + 1, 16));
        for (Map.Entry<Currency, Balance> entry : source.entrySet()) {
            CurrencyDTO key = this.currencyMapper.mapToCurrencyDTO(entry.getKey());
            BalanceDTO value = this.mapToBalanceDTO(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    @Override
    public BalanceDTO mapToBalanceDTO(Balance source) {
        if (source == null) {
            return null;
        }
        BalanceDTO.BalanceDTOBuilder balanceDTO = BalanceDTO.builder();
        balanceDTO.currency(this.currencyMapper.mapToCurrencyDTO(source.getCurrency()));
        balanceDTO.total(source.getTotal());
        balanceDTO.available(source.getAvailable());
        balanceDTO.frozen(source.getFrozen());
        balanceDTO.loaned(source.getLoaned());
        balanceDTO.borrowed(source.getBorrowed());
        balanceDTO.withdrawing(source.getWithdrawing());
        balanceDTO.depositing(source.getDepositing());
        return balanceDTO.build();
    }

    protected Map<String, AccountDTO> stringWalletMapToStringAccountDTOMap(Map<String, Wallet> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, AccountDTO> map1 = new HashMap<String, AccountDTO>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, Wallet> entry : map.entrySet()) {
            String key = entry.getKey();
            AccountDTO value = this.mapToWalletDTO(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected AccountFeatureDTO walletFeatureToAccountFeatureDTO(Wallet.WalletFeature walletFeature) {
        AccountFeatureDTO accountFeatureDTO;
        if (walletFeature == null) {
            return null;
        }
        switch (walletFeature) {
            case FUNDING: {
                accountFeatureDTO = AccountFeatureDTO.FUNDING;
                break;
            }
            case TRADING: {
                accountFeatureDTO = AccountFeatureDTO.TRADING;
                break;
            }
            case MARGIN_TRADING: {
                accountFeatureDTO = AccountFeatureDTO.MARGIN_TRADING;
                break;
            }
            case MARGIN_FUNDING: {
                accountFeatureDTO = AccountFeatureDTO.MARGIN_FUNDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + walletFeature);
            }
        }
        return accountFeatureDTO;
    }

    protected Collection<AccountFeatureDTO> walletFeatureSetToAccountFeatureDTOCollection(Set<Wallet.WalletFeature> set) {
        if (set == null) {
            return null;
        }
        ArrayList<AccountFeatureDTO> collection = new ArrayList<AccountFeatureDTO>(set.size());
        for (Wallet.WalletFeature walletFeature : set) {
            collection.add(this.walletFeatureToAccountFeatureDTO(walletFeature));
        }
        return collection;
    }
}

