/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.base.batch;

import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Schedulers;
import tech.cassandre.trading.bot.util.base.Base;

public abstract class BaseFlux<T>
extends Base {
    protected final Flux<T> flux;
    protected FluxSink<T> fluxSink;

    public BaseFlux() {
        Flux fluxTemp = Flux.create(newFluxSink -> {
            this.fluxSink = newFluxSink;
        }, (FluxSink.OverflowStrategy)this.getOverflowStrategy());
        this.flux = fluxTemp.publishOn(Schedulers.boundedElastic());
    }

    protected FluxSink.OverflowStrategy getOverflowStrategy() {
        return FluxSink.OverflowStrategy.LATEST;
    }

    protected abstract Optional<T> saveValue(T var1);

    public void emitValue(T newValue) {
        this.saveValue(newValue).ifPresent(t -> {
            this.logger.debug("{} flux emits a new value : {}", (Object)this.getClass().getName(), t);
            this.fluxSink.next(t);
        });
    }

    public Flux<T> getFlux() {
        return this.flux;
    }
}

