/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.strategy;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.position.PositionCreationResultDTO;
import tech.cassandre.trading.bot.dto.position.PositionDTO;
import tech.cassandre.trading.bot.dto.position.PositionRulesDTO;
import tech.cassandre.trading.bot.dto.position.PositionStatusDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderCreationResultDTO;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.user.BalanceDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.dto.util.GainDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.PositionRepository;
import tech.cassandre.trading.bot.repository.TradeRepository;
import tech.cassandre.trading.bot.service.ExchangeService;
import tech.cassandre.trading.bot.service.PositionService;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.strategy.CassandreStrategyInterface;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.OrderMapper;
import tech.cassandre.trading.bot.util.mapper.PositionMapper;
import tech.cassandre.trading.bot.util.mapper.TradeMapper;

public abstract class GenericCassandreStrategy
implements CassandreStrategyInterface {
    protected final CurrencyMapper currencyMapper = (CurrencyMapper)Mappers.getMapper(CurrencyMapper.class);
    protected final OrderMapper orderMapper = (OrderMapper)Mappers.getMapper(OrderMapper.class);
    protected final TradeMapper tradeMapper = (TradeMapper)Mappers.getMapper(TradeMapper.class);
    protected final PositionMapper positionMapper = (PositionMapper)Mappers.getMapper(PositionMapper.class);
    private StrategyDTO strategy;
    private OrderRepository orderRepository;
    private TradeRepository tradeRepository;
    private PositionRepository positionRepository;
    private ExchangeService exchangeService;
    private TradeService tradeService;
    private PositionService positionService;
    private final Map<String, AccountDTO> accounts = new LinkedHashMap<String, AccountDTO>();
    private final Map<Long, PositionStatusDTO> previousPositionsStatus = new LinkedHashMap<Long, PositionStatusDTO>();
    private final Map<Long, CurrencyAmountDTO> amountsLockedByPosition = new ConcurrentHashMap<Long, CurrencyAmountDTO>();
    private final Map<CurrencyPairDTO, TickerDTO> lastTickers = new LinkedHashMap<CurrencyPairDTO, TickerDTO>();

    public final StrategyDTO getStrategyDTO() {
        return this.strategy;
    }

    @Override
    public final void setStrategy(StrategyDTO newStrategyDTO) {
        this.strategy = newStrategyDTO;
    }

    @Override
    public void initializeAccounts(Map<String, AccountDTO> newAccounts) {
        this.accounts.putAll(newAccounts);
    }

    @Override
    public final void setPositionRepository(PositionRepository newPositionRepository) {
        this.positionRepository = newPositionRepository;
    }

    @Override
    public final void setOrderRepository(OrderRepository newOrderRepository) {
        this.orderRepository = newOrderRepository;
    }

    public final ExchangeService getExchangeService() {
        return this.exchangeService;
    }

    @Override
    public void setExchangeService(ExchangeService newExchangeService) {
        this.exchangeService = newExchangeService;
    }

    @Override
    public final void setTradeRepository(TradeRepository newTradeRepository) {
        this.tradeRepository = newTradeRepository;
    }

    @Override
    public final void setTradeService(TradeService newTradeService) {
        this.tradeService = newTradeService;
    }

    @Override
    public final void setPositionService(PositionService newPositionService) {
        this.positionService = newPositionService;
        this.positionService.getPositions().stream().filter(p -> p.getStatus() != PositionStatusDTO.CLOSED).forEach(p -> this.previousPositionsStatus.put(p.getId(), p.getStatus()));
        this.positionService.getPositions().stream().filter(p -> p.getStatus() != PositionStatusDTO.CLOSED).forEach(p -> this.amountsLockedByPosition.put(p.getId(), p.getAmountToLock()));
    }

    @Override
    public void accountUpdate(AccountDTO account) {
        this.accounts.put(account.getAccountId(), account);
        this.onAccountUpdate(account);
    }

    @Override
    public void tickerUpdate(TickerDTO ticker) {
        if (this.getRequestedCurrencyPairs().contains(ticker.getCurrencyPair())) {
            this.lastTickers.put(ticker.getCurrencyPair(), ticker);
            this.onTickerUpdate(ticker);
        }
    }

    @Override
    public void orderUpdate(OrderDTO order) {
        if (order.getStrategy().getId().equals(this.strategy.getId())) {
            this.onOrderUpdate(order);
        }
    }

    @Override
    public void tradeUpdate(TradeDTO trade) {
        if (trade.getOrder().getStrategy().getStrategyId().equals(this.strategy.getStrategyId())) {
            this.onTradeUpdate(trade);
        }
    }

    @Override
    public void positionUpdate(PositionDTO position) {
        this.amountsLockedByPosition.put(position.getId(), position.getAmountToLock());
        if (position.getStatus() == PositionStatusDTO.CLOSED) {
            this.amountsLockedByPosition.remove(position.getId());
        }
        if (position.getStrategy().getId().equals(this.strategy.getId())) {
            this.onPositionUpdate(position);
            if (this.previousPositionsStatus.get(position.getId()) != position.getStatus()) {
                this.previousPositionsStatus.put(position.getId(), position.getStatus());
                if (position.getStatus() == PositionStatusDTO.CLOSED) {
                    this.previousPositionsStatus.remove(position.getId());
                }
                this.onPositionStatusUpdate(position);
            }
        }
    }

    public final Map<String, AccountDTO> getAccounts() {
        return this.accounts;
    }

    public final Optional<AccountDTO> getAccountByAccountId(String accountId) {
        if (this.accounts.containsKey(accountId)) {
            return Optional.of(this.accounts.get(accountId));
        }
        return Optional.empty();
    }

    @Override
    public final Optional<AccountDTO> getTradeAccount() {
        return this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.getAccounts().values()));
    }

    public final Map<Long, CurrencyAmountDTO> getAmountsLockedByPosition() {
        return this.amountsLockedByPosition;
    }

    public final BigDecimal getAmountsLockedByCurrency(CurrencyDTO currency) {
        return this.amountsLockedByPosition.values().stream().filter(currencyAmount -> currencyAmount.getCurrency().equals(currency)).map(CurrencyAmountDTO::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public final Map<CurrencyPairDTO, TickerDTO> getLastTickers() {
        return this.lastTickers;
    }

    public final Optional<TickerDTO> getLastTickerByCurrencyPair(String currencyPair) {
        if (currencyPair == null) {
            return Optional.empty();
        }
        return this.getLastTickerByCurrencyPair(new CurrencyPairDTO(currencyPair));
    }

    public final Optional<TickerDTO> getLastTickerByCurrencyPair(CurrencyPairDTO currencyPair) {
        if (currencyPair == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.lastTickers.get(currencyPair));
    }

    public final Map<String, OrderDTO> getOrders() {
        return this.orderRepository.findByOrderByTimestampAsc().stream().filter(order -> order.getStrategy().getStrategyId().equals(this.strategy.getStrategyId())).map(this.orderMapper::mapToOrderDTO).collect(Collectors.toMap(OrderDTO::getOrderId, orderDTO -> orderDTO));
    }

    public final Optional<OrderDTO> getOrderByOrderId(String orderId) {
        return this.getOrders().values().stream().filter(order -> order.getOrderId().equals(orderId)).findFirst();
    }

    public final Map<String, TradeDTO> getTrades() {
        return this.tradeRepository.findByOrderByTimestampAsc().stream().filter(trade -> trade.getOrder().getStrategy().getStrategyId().equals(this.strategy.getStrategyId())).map(this.tradeMapper::mapToTradeDTO).collect(Collectors.toMap(TradeDTO::getTradeId, tradeDTO -> tradeDTO));
    }

    public final Optional<TradeDTO> getTradeByTradeId(String tradeId) {
        return this.getTrades().values().stream().filter(trade -> trade.getTradeId().equals(tradeId)).findFirst();
    }

    public final Map<Long, PositionDTO> getPositions() {
        return this.positionRepository.findByOrderById().stream().map(this.positionMapper::mapToPositionDTO).collect(Collectors.toMap(PositionDTO::getId, positionDTO -> positionDTO));
    }

    public final Optional<PositionDTO> getPositionByPositionId(long positionId) {
        return this.positionRepository.findByPositionId(positionId).map(this.positionMapper::mapToPositionDTO);
    }

    public final HashMap<CurrencyDTO, GainDTO> getGains() {
        return this.positionService.getGains();
    }

    public OrderCreationResultDTO createBuyMarketOrder(CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.tradeService.createBuyMarketOrder(this.strategy, currencyPair, amount);
    }

    public OrderCreationResultDTO createSellMarketOrder(CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.tradeService.createSellMarketOrder(this.strategy, currencyPair, amount);
    }

    public OrderCreationResultDTO createBuyLimitOrder(CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        return this.tradeService.createBuyLimitOrder(this.strategy, currencyPair, amount, limitPrice);
    }

    public OrderCreationResultDTO createSellLimitOrder(CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        return this.tradeService.createSellLimitOrder(this.strategy, currencyPair, amount, limitPrice);
    }

    public PositionCreationResultDTO createLongPosition(CurrencyPairDTO currencyPair, BigDecimal amount, PositionRulesDTO rules) {
        return this.positionService.createLongPosition(this.strategy, currencyPair, amount, rules);
    }

    public PositionCreationResultDTO createShortPosition(CurrencyPairDTO currencyPair, BigDecimal amount, PositionRulesDTO rules) {
        return this.positionService.createShortPosition(this.strategy, currencyPair, amount, rules);
    }

    public void updatePositionRules(long id, PositionRulesDTO newRules) {
        this.positionService.updatePositionRules(id, newRules);
    }

    public void closePosition(long id) {
        this.positionService.closePosition(id);
    }

    @Override
    public void onAccountUpdate(AccountDTO account) {
    }

    @Override
    public void onTickerUpdate(TickerDTO ticker) {
    }

    @Override
    public void onOrderUpdate(OrderDTO order) {
    }

    @Override
    public void onTradeUpdate(TradeDTO trade) {
    }

    @Override
    public void onPositionUpdate(PositionDTO position) {
    }

    @Override
    public void onPositionStatusUpdate(PositionDTO position) {
    }

    public final Optional<CurrencyAmountDTO> getEstimatedBuyingCost(CurrencyPairDTO currencyPair, BigDecimal amount) {
        TickerDTO ticker = this.lastTickers.get(currencyPair);
        if (ticker == null) {
            return Optional.empty();
        }
        return Optional.of(CurrencyAmountDTO.builder().value(ticker.getLast().multiply(amount)).currency(currencyPair.getQuoteCurrency()).build());
    }

    public final boolean canBuy(CurrencyPairDTO currencyPair, BigDecimal amount) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.accounts.values()));
        return tradeAccount.filter(account -> this.canBuy((AccountDTO)account, currencyPair, amount)).isPresent();
    }

    public final boolean canBuy(CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal minimumBalanceAfter) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.accounts.values()));
        return tradeAccount.filter(account -> this.canBuy((AccountDTO)account, currencyPair, amount, minimumBalanceAfter)).isPresent();
    }

    public final boolean canBuy(AccountDTO account, CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.canBuy(account, currencyPair, amount, BigDecimal.ZERO);
    }

    public final boolean canBuy(AccountDTO account, CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal minimumBalanceAfter) {
        Optional<BalanceDTO> balance = account.getBalance(currencyPair.getQuoteCurrency());
        if (balance.isPresent()) {
            Optional<CurrencyAmountDTO> estimatedBuyingCost = this.getEstimatedBuyingCost(currencyPair, amount);
            return estimatedBuyingCost.filter(currencyAmountDTO -> ((BalanceDTO)balance.get()).getAvailable().subtract(currencyAmountDTO.getValue().add(minimumBalanceAfter).add(this.getAmountsLockedByCurrency(currencyAmountDTO.getCurrency()))).compareTo(BigDecimal.ZERO) > 0).isPresent() || estimatedBuyingCost.filter(currencyAmountDTO -> ((BalanceDTO)balance.get()).getAvailable().subtract(currencyAmountDTO.getValue().add(minimumBalanceAfter).add(this.getAmountsLockedByCurrency(currencyAmountDTO.getCurrency()))).compareTo(BigDecimal.ZERO) == 0).isPresent();
        }
        return false;
    }

    public final boolean canSell(CurrencyDTO currency, BigDecimal amount) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.accounts.values()));
        return tradeAccount.filter(account -> this.canSell((AccountDTO)account, currency, amount)).isPresent();
    }

    public final boolean canSell(CurrencyDTO currency, BigDecimal amount, BigDecimal minimumBalanceAfter) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.accounts.values()));
        return tradeAccount.filter(account -> this.canSell((AccountDTO)account, currency, amount, minimumBalanceAfter)).isPresent();
    }

    public final boolean canSell(AccountDTO account, CurrencyDTO currency, BigDecimal amount) {
        return this.canSell(account, currency, amount, BigDecimal.ZERO);
    }

    public final boolean canSell(AccountDTO account, CurrencyDTO currency, BigDecimal amount, BigDecimal minimumBalanceAfter) {
        Optional<BalanceDTO> balance = account.getBalance(currency);
        return balance.filter(balanceDTO -> balanceDTO.getAvailable().subtract(amount).subtract(minimumBalanceAfter).subtract(this.getAmountsLockedByCurrency(currency)).compareTo(BigDecimal.ZERO) > 0 || balanceDTO.getAvailable().subtract(amount).subtract(minimumBalanceAfter).subtract(this.getAmountsLockedByCurrency(currency)).compareTo(BigDecimal.ZERO) == 0).isPresent();
    }
}

