/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.strategy;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.position.PositionDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.PositionRepository;
import tech.cassandre.trading.bot.repository.TradeRepository;
import tech.cassandre.trading.bot.service.ExchangeService;
import tech.cassandre.trading.bot.service.PositionService;
import tech.cassandre.trading.bot.service.TradeService;

public interface CassandreStrategyInterface {
    public void setStrategy(StrategyDTO var1);

    public void initializeAccounts(Map<String, AccountDTO> var1);

    public void setOrderRepository(OrderRepository var1);

    public void setTradeRepository(TradeRepository var1);

    public void setPositionRepository(PositionRepository var1);

    public void setExchangeService(ExchangeService var1);

    public void setTradeService(TradeService var1);

    public void setPositionService(PositionService var1);

    public void accountUpdate(AccountDTO var1);

    public void tickerUpdate(TickerDTO var1);

    public void orderUpdate(OrderDTO var1);

    public void tradeUpdate(TradeDTO var1);

    public void positionUpdate(PositionDTO var1);

    public Set<CurrencyPairDTO> getRequestedCurrencyPairs();

    public Optional<AccountDTO> getTradeAccount(Set<AccountDTO> var1);

    public Optional<AccountDTO> getTradeAccount();

    public void onAccountUpdate(AccountDTO var1);

    public void onTickerUpdate(TickerDTO var1);

    public void onOrderUpdate(OrderDTO var1);

    public void onTradeUpdate(TradeDTO var1);

    public void onPositionUpdate(PositionDTO var1);

    public void onPositionStatusUpdate(PositionDTO var1);
}

