/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.strategy;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.ta4j.core.BarSeries;
import org.ta4j.core.BaseBarSeriesBuilder;
import org.ta4j.core.Strategy;
import org.ta4j.core.num.DoubleNum;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.strategy.GenericCassandreStrategy;

public abstract class BasicTa4jCassandreStrategy
extends GenericCassandreStrategy {
    private ZonedDateTime lastAddedBarTimestamp;
    private final BarSeries series = new BaseBarSeriesBuilder().withNumTypeOf(DoubleNum.class).withName(this.getRequestedCurrencyPair().toString()).build();
    private final Strategy strategy;

    public BasicTa4jCassandreStrategy() {
        this.series.setMaximumBarCount(this.getMaximumBarCount());
        this.strategy = this.getStrategy();
    }

    public abstract CurrencyPairDTO getRequestedCurrencyPair();

    public abstract int getMaximumBarCount();

    public abstract Duration getDelayBetweenTwoBars();

    public abstract Strategy getStrategy();

    @Override
    public final Set<CurrencyPairDTO> getRequestedCurrencyPairs() {
        return Set.of(this.getRequestedCurrencyPair());
    }

    @Override
    public final void tickerUpdate(TickerDTO ticker) {
        if (this.getRequestedCurrencyPairs().contains(ticker.getCurrencyPair())) {
            this.getLastTickers().put(ticker.getCurrencyPair(), ticker);
            if (this.lastAddedBarTimestamp == null || ticker.getTimestamp().isEqual(this.lastAddedBarTimestamp.plus(this.getDelayBetweenTwoBars())) || ticker.getTimestamp().isAfter(this.lastAddedBarTimestamp.plus(this.getDelayBetweenTwoBars()))) {
                Number openPrice = (Number)MoreObjects.firstNonNull((Object)ticker.getOpen(), (Object)0);
                Number highPrice = (Number)MoreObjects.firstNonNull((Object)ticker.getHigh(), (Object)0);
                Number lowPrice = (Number)MoreObjects.firstNonNull((Object)ticker.getLow(), (Object)0);
                Number closePrice = (Number)MoreObjects.firstNonNull((Object)ticker.getLast(), (Object)0);
                Number volume = (Number)MoreObjects.firstNonNull((Object)ticker.getVolume(), (Object)0);
                this.series.addBar(ticker.getTimestamp(), openPrice, highPrice, lowPrice, closePrice, volume);
                this.lastAddedBarTimestamp = ticker.getTimestamp();
                int endIndex = this.series.getEndIndex();
                if (this.strategy.shouldEnter(endIndex)) {
                    this.shouldEnter();
                } else if (this.strategy.shouldExit(endIndex)) {
                    this.shouldExit();
                }
            }
            this.onTickerUpdate(ticker);
        }
    }

    public final boolean canBuy(BigDecimal amount) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.getAccounts().values()));
        return tradeAccount.filter(accountDTO -> this.canBuy((AccountDTO)accountDTO, this.getRequestedCurrencyPair(), amount)).isPresent();
    }

    public final boolean canBuy(BigDecimal amount, BigDecimal minimumBalanceAfter) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.getAccounts().values()));
        return tradeAccount.filter(accountDTO -> this.canBuy((AccountDTO)accountDTO, this.getRequestedCurrencyPair(), amount, minimumBalanceAfter)).isPresent();
    }

    public final boolean canBuy(AccountDTO account, BigDecimal amount) {
        return this.canBuy(account, this.getRequestedCurrencyPair(), amount);
    }

    public final boolean canBuy(AccountDTO account, BigDecimal amount, BigDecimal minimumBalanceAfter) {
        return this.canBuy(account, this.getRequestedCurrencyPair(), amount, minimumBalanceAfter);
    }

    public final boolean canSell(BigDecimal amount, BigDecimal minimumBalanceAfter) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.getAccounts().values()));
        return tradeAccount.filter(accountDTO -> this.canSell((AccountDTO)accountDTO, this.getRequestedCurrencyPair().getBaseCurrency(), amount, minimumBalanceAfter)).isPresent();
    }

    public final boolean canSell(BigDecimal amount) {
        Optional<AccountDTO> tradeAccount = this.getTradeAccount(new LinkedHashSet<AccountDTO>(this.getAccounts().values()));
        return tradeAccount.filter(accountDTO -> this.canSell((AccountDTO)accountDTO, this.getRequestedCurrencyPair().getBaseCurrency(), amount)).isPresent();
    }

    public final boolean canSell(AccountDTO account, BigDecimal amount) {
        return this.canSell(account, this.getRequestedCurrencyPair().getBaseCurrency(), amount);
    }

    public final boolean canSell(AccountDTO account, BigDecimal amount, BigDecimal minimumBalanceAfter) {
        return this.canSell(account, this.getRequestedCurrencyPair().getBaseCurrency(), amount, minimumBalanceAfter);
    }

    public abstract void shouldEnter();

    public abstract void shouldExit();

    public final BarSeries getSeries() {
        return this.series;
    }
}

