/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.service.xchange;

import java.io.IOException;
import java.util.Optional;
import org.knowm.xchange.service.account.AccountService;
import tech.cassandre.trading.bot.dto.user.UserDTO;
import tech.cassandre.trading.bot.service.UserService;
import tech.cassandre.trading.bot.util.base.service.BaseService;

public class UserServiceXChangeImplementation
extends BaseService
implements UserService {
    private final AccountService xChangeAccountService;

    public UserServiceXChangeImplementation(long rate, AccountService newXChangeAccountService) {
        super(rate);
        this.xChangeAccountService = newXChangeAccountService;
    }

    @Override
    public final Optional<UserDTO> getUser() {
        try {
            this.getBucket().asScheduler().consume(1L);
            this.logger.debug("UserService - Retrieving account information");
            UserDTO user = this.accountMapper.mapToUserDTO(this.xChangeAccountService.getAccountInfo());
            this.logger.debug("UserService - Account information retrieved " + user);
            return Optional.ofNullable(user);
        }
        catch (IOException e) {
            this.logger.error("UserService - Error retrieving account information : {}", (Object)e.getMessage());
            return Optional.empty();
        }
        catch (InterruptedException e) {
            this.logger.error("UserService - InterruptedException : {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }
}

