/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.service.xchange;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsAll;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderCreationResultDTO;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.OrderStatusDTO;
import tech.cassandre.trading.bot.dto.trade.OrderTypeDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.util.base.service.BaseService;
import tech.cassandre.trading.bot.util.system.TimeProvider;

public class TradeServiceXChangeImplementation
extends BaseService
implements TradeService {
    private final OrderRepository orderRepository;
    private final org.knowm.xchange.service.trade.TradeService tradeService;
    private final Map<String, OrderDTO> localOrders = new ConcurrentHashMap<String, OrderDTO>();

    public TradeServiceXChangeImplementation(long rate, OrderRepository newOrderRepository, org.knowm.xchange.service.trade.TradeService newTradeService) {
        super(rate);
        this.orderRepository = newOrderRepository;
        this.tradeService = newTradeService;
    }

    private OrderCreationResultDTO createMarketOrder(StrategyDTO strategy, OrderTypeDTO orderTypeDTO, CurrencyPairDTO currencyPair, BigDecimal amount) {
        try {
            MarketOrder m = new MarketOrder(this.utilMapper.mapToOrderType(orderTypeDTO), amount, (Instrument)this.currencyMapper.mapToCurrencyPair(currencyPair));
            this.logger.debug("TradeService - Sending market order : {} - {} - {}", new Object[]{orderTypeDTO, currencyPair, amount});
            String orderId = this.tradeService.placeMarketOrder(m);
            OrderDTO openingOrder = OrderDTO.builder().orderId(orderId).type(orderTypeDTO).strategy(strategy).currencyPair(currencyPair).amount(CurrencyAmountDTO.builder().value(amount).currency(currencyPair.getBaseCurrency()).build()).status(OrderStatusDTO.PENDING_NEW).timestamp(ZonedDateTime.now()).build();
            this.localOrders.put(orderId, openingOrder);
            OrderCreationResultDTO result = new OrderCreationResultDTO(openingOrder);
            this.logger.debug("TradeService - Order created : {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            String error = "TradeService - Error calling createBuyMarketOrder for " + amount + " " + currencyPair + " : " + e.getMessage();
            e.printStackTrace();
            this.logger.error(error);
            return new OrderCreationResultDTO(error, e);
        }
    }

    private OrderCreationResultDTO createLimitOrder(StrategyDTO strategy, OrderTypeDTO orderTypeDTO, CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        try {
            LimitOrder l = new LimitOrder(this.utilMapper.mapToOrderType(orderTypeDTO), amount, (Instrument)this.currencyMapper.mapToCurrencyPair(currencyPair), null, null, limitPrice);
            this.logger.debug("TradeService - Sending market order : {} - {} - {}", new Object[]{orderTypeDTO, currencyPair, amount});
            String orderId = this.tradeService.placeLimitOrder(l);
            OrderDTO openingOrder = OrderDTO.builder().orderId(orderId).type(orderTypeDTO).strategy(strategy).currencyPair(currencyPair).amount(CurrencyAmountDTO.builder().value(amount).currency(currencyPair.getBaseCurrency()).build()).limitPrice(CurrencyAmountDTO.builder().value(limitPrice).currency(currencyPair.getQuoteCurrency()).build()).status(OrderStatusDTO.PENDING_NEW).timestamp(ZonedDateTime.now()).build();
            this.localOrders.put(orderId, openingOrder);
            OrderCreationResultDTO result = new OrderCreationResultDTO(openingOrder);
            this.logger.debug("TradeService - Order creation result : {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            String error = "TradeService - Error calling createLimitOrder for " + amount + " " + currencyPair + " : " + e.getMessage();
            e.printStackTrace();
            this.logger.error(error);
            return new OrderCreationResultDTO(error, e);
        }
    }

    @Override
    public final OrderCreationResultDTO createBuyMarketOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.createMarketOrder(strategy, OrderTypeDTO.BID, currencyPair, amount);
    }

    @Override
    public final OrderCreationResultDTO createSellMarketOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.createMarketOrder(strategy, OrderTypeDTO.ASK, currencyPair, amount);
    }

    @Override
    public final OrderCreationResultDTO createBuyLimitOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        return this.createLimitOrder(strategy, OrderTypeDTO.BID, currencyPair, amount, limitPrice);
    }

    @Override
    public final OrderCreationResultDTO createSellLimitOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        return this.createLimitOrder(strategy, OrderTypeDTO.ASK, currencyPair, amount, limitPrice);
    }

    @Override
    public final boolean cancelOrder(String orderId) {
        this.logger.debug("TradeService - Canceling order {}", (Object)orderId);
        if (orderId != null) {
            try {
                this.logger.debug("TradeService - Successfully canceled order {}", (Object)orderId);
                return this.tradeService.cancelOrder(orderId);
            }
            catch (Exception e) {
                this.logger.error("TradeService - Error canceling order {} : {}", (Object)orderId, (Object)e.getMessage());
                return false;
            }
        }
        this.logger.error("TradeService - Error canceling order, order id provided is null");
        return false;
    }

    @Override
    public final Set<OrderDTO> getOpenOrders() {
        return this.getOrders();
    }

    @Override
    public final Set<OrderDTO> getOrders() {
        this.logger.debug("TradeService - Getting open orders from exchange");
        try {
            this.getBucket().asScheduler().consume(1L);
            this.localOrders.keySet().stream().filter(o -> this.orderRepository.findByOrderId((String)o).isPresent()).forEach(this.localOrders::remove);
            if (!this.localOrders.isEmpty()) {
                return this.localOrders.values().stream().sorted(Comparator.comparing(OrderDTO::getTimestamp)).peek(o -> this.logger.debug("TradeService - {} local order retrieved", o)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.tradeService.getOpenOrders().getOpenOrders().stream().map(this.orderMapper::mapToOrderDTO).peek(o -> this.logger.debug("TradeService - {} remote order retrieved", o)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (IOException e) {
            this.logger.error("TradeService - Error retrieving open orders : {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
        catch (InterruptedException e) {
            this.logger.error("TradeService - InterruptedException : {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    @Override
    public final Set<TradeDTO> getTrades() {
        this.logger.debug("TradeService - Getting trades from exchange");
        TradeHistoryParamsAll params = new TradeHistoryParamsAll();
        Date now = TimeProvider.now();
        Date startDate = DateUtils.addDays((Date)now, (int)-1);
        params.setStartTime(startDate);
        params.setEndTime(now);
        LinkedHashSet currencyPairs = this.orderRepository.findByOrderByTimestampAsc().stream().map(Order::getCurrencyPair).distinct().map(this.currencyMapper::mapToCurrencyPairDTO).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<TradeDTO> results = new LinkedHashSet<TradeDTO>();
        if (!currencyPairs.isEmpty()) {
            currencyPairs.forEach(pair -> {
                params.setCurrencyPair(this.currencyMapper.mapToCurrencyPair((CurrencyPairDTO)pair));
                try {
                    this.getBucket().asScheduler().consume(1L);
                    results.addAll(this.tradeService.getTradeHistory((TradeHistoryParams)params).getUserTrades().stream().map(this.tradeMapper::mapToTradeDTO).sorted(Comparator.comparing(TradeDTO::getTimestamp)).collect(Collectors.toCollection(LinkedHashSet::new)));
                }
                catch (IOException e) {
                    this.logger.error("TradeService - Error retrieving trades : {}", (Object)e.getMessage());
                }
                catch (InterruptedException e) {
                    this.logger.error("TradeService - InterruptedException : {}", (Object)e.getMessage());
                }
            });
        }
        this.logger.debug("TradeService - {} trade(s) found", (Object)results.size());
        return results;
    }
}

