/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.service.xchange;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.CurrencyPairsParam;
import org.knowm.xchange.service.marketdata.params.Params;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.service.MarketService;
import tech.cassandre.trading.bot.util.base.service.BaseService;

public class MarketServiceXChangeImplementation
extends BaseService
implements MarketService {
    private final MarketDataService marketDataService;

    public MarketServiceXChangeImplementation(long rate, MarketDataService newMarketDataService) {
        super(rate);
        this.marketDataService = newMarketDataService;
    }

    @Override
    public final Optional<TickerDTO> getTicker(CurrencyPairDTO currencyPair) {
        try {
            this.getBucket().asScheduler().consume(1L);
            this.logger.debug("MarketService - Getting ticker for {}", (Object)currencyPair);
            TickerDTO t = this.tickerMapper.mapToTickerDTO(this.marketDataService.getTicker(this.currencyMapper.mapToCurrencyPair(currencyPair), new Object[0]));
            this.logger.debug("MarketService - Retrieved value is : {}", (Object)t);
            return Optional.ofNullable(t);
        }
        catch (IOException e) {
            this.logger.error("MarketService - Error retrieving ticker about {} : {}", (Object)currencyPair, (Object)e.getMessage());
            return Optional.empty();
        }
        catch (InterruptedException e) {
            this.logger.error("MarketService - InterruptedException {} : {}", (Object)currencyPair, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public final Set<TickerDTO> getTickers(Set<CurrencyPairDTO> currencyPairs) {
        try {
            CurrencyPairsParam params = () -> currencyPairs.stream().map(this.currencyMapper::mapToCurrencyPair).collect(Collectors.toCollection(LinkedList::new));
            this.getBucket().asScheduler().consume(1L);
            this.logger.debug("MarketService - Getting tickers for {} currency pairs", (Object)currencyPairs.size());
            List tickers = this.marketDataService.getTickers((Params)params);
            return tickers.stream().map(this.tickerMapper::mapToTickerDTO).peek(t -> this.logger.debug("MarketService - Retrieved value : {}", t)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (IOException e) {
            this.logger.error("MarketService - Error retrieving tickers : {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
        catch (InterruptedException e) {
            this.logger.error("MarketService - InterruptedException : {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }
}

