/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.service.intern;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.cassandre.trading.bot.batch.PositionFlux;
import tech.cassandre.trading.bot.domain.Position;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.position.PositionCreationResultDTO;
import tech.cassandre.trading.bot.dto.position.PositionDTO;
import tech.cassandre.trading.bot.dto.position.PositionRulesDTO;
import tech.cassandre.trading.bot.dto.position.PositionStatusDTO;
import tech.cassandre.trading.bot.dto.position.PositionTypeDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderCreationResultDTO;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.dto.util.GainDTO;
import tech.cassandre.trading.bot.repository.PositionRepository;
import tech.cassandre.trading.bot.service.PositionService;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.util.base.service.BaseService;

public class PositionServiceImplementation
extends BaseService
implements PositionService {
    public static final int SCALE = 8;
    private final PositionRepository positionRepository;
    private final TradeService tradeService;
    private final PositionFlux positionFlux;
    private final Collection<Long> positionsToClose = Collections.synchronizedCollection(new ArrayList());

    public PositionServiceImplementation(PositionRepository newPositionRepository, TradeService newTradeService, PositionFlux newPositionFlux) {
        this.positionRepository = newPositionRepository;
        this.tradeService = newTradeService;
        this.positionFlux = newPositionFlux;
    }

    @Override
    public final PositionCreationResultDTO createLongPosition(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount, PositionRulesDTO rules) {
        return this.createPosition(strategy, PositionTypeDTO.LONG, currencyPair, amount, rules);
    }

    @Override
    public final PositionCreationResultDTO createShortPosition(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount, PositionRulesDTO rules) {
        return this.createPosition(strategy, PositionTypeDTO.SHORT, currencyPair, amount, rules);
    }

    public final PositionCreationResultDTO createPosition(StrategyDTO strategy, PositionTypeDTO type, CurrencyPairDTO currencyPair, BigDecimal amount, PositionRulesDTO rules) {
        this.logger.debug("PositionService - Creating a {} position for {} on {} with the rules : {}", new Object[]{type.toString().toLowerCase(Locale.ROOT), amount, currencyPair, rules});
        OrderCreationResultDTO orderCreationResult = type == PositionTypeDTO.LONG ? this.tradeService.createBuyMarketOrder(strategy, currencyPair, amount) : this.tradeService.createSellMarketOrder(strategy, currencyPair, amount);
        if (orderCreationResult.isSuccessful()) {
            Position position = new Position();
            position.setStrategy(this.strategyMapper.mapToStrategy(strategy));
            position = (Position)this.positionRepository.save(position);
            PositionDTO p = new PositionDTO(position.getId(), type, strategy, currencyPair, amount, orderCreationResult.getOrderId(), rules);
            this.positionRepository.save(this.positionMapper.mapToPosition(p));
            this.logger.debug("PositionService - Position {} opened with order {}", (Object)p.getPositionId(), (Object)orderCreationResult.getOrder().getOrderId());
            this.positionFlux.emitValue(p);
            return new PositionCreationResultDTO(p);
        }
        this.logger.error("PositionService - Position creation failure : {}", (Object)orderCreationResult.getErrorMessage());
        return new PositionCreationResultDTO(orderCreationResult.getErrorMessage(), orderCreationResult.getException());
    }

    @Override
    public final void updatePositionRules(long id, PositionRulesDTO newRules) {
        Optional p = this.positionRepository.findById(id);
        if (p.isPresent() && ((Position)p.get()).getStatus() != PositionStatusDTO.CLOSED) {
            if (newRules.isStopGainPercentageSet()) {
                this.positionRepository.updateStopGainRule(id, newRules.getStopGainPercentage());
            } else {
                this.positionRepository.updateStopGainRule(id, null);
            }
            if (newRules.isStopLossPercentageSet()) {
                this.positionRepository.updateStopLossRule(id, newRules.getStopLossPercentage());
            } else {
                this.positionRepository.updateStopLossRule(id, null);
            }
        }
    }

    @Override
    public final void closePosition(long id) {
        this.positionsToClose.add(id);
    }

    @Override
    public final Set<PositionDTO> getPositions() {
        this.logger.debug("PositionService - Retrieving all positions");
        return this.positionRepository.findByOrderById().stream().map(this.positionMapper::mapToPositionDTO).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public final Optional<PositionDTO> getPositionById(long id) {
        this.logger.debug("PositionService - Retrieving position {}", (Object)id);
        Optional position = this.positionRepository.findById(id);
        return position.map(this.positionMapper::mapToPositionDTO);
    }

    @Override
    public final void orderUpdate(OrderDTO order) {
        this.logger.debug("PositionService - Updating position with order {}", (Object)order);
        this.positionRepository.findByStatusNot(PositionStatusDTO.CLOSED).stream().map(this.positionMapper::mapToPositionDTO).forEach(p -> {
            if (p.orderUpdate(order)) {
                this.logger.debug("PositionService - Position {} updated with order {}", (Object)p.getPositionId(), (Object)order);
                this.positionFlux.emitValue(p);
            }
        });
    }

    @Override
    public final void tradeUpdate(TradeDTO trade) {
        this.logger.debug("PositionService - Updating position with trade {}", (Object)trade);
        this.positionRepository.findByStatusNot(PositionStatusDTO.CLOSED).stream().map(this.positionMapper::mapToPositionDTO).forEach(p -> {
            if (p.tradeUpdate(trade)) {
                this.logger.debug("PositionService - Position {} updated with trade {}", (Object)p.getPositionId(), (Object)trade);
                this.positionFlux.emitValue(p);
            }
        });
    }

    @Override
    public final void tickerUpdate(TickerDTO ticker) {
        this.logger.debug("PositionService - Updating position with ticker {}", (Object)ticker);
        this.positionRepository.findByStatus(PositionStatusDTO.OPENED).stream().map(this.positionMapper::mapToPositionDTO).filter(p -> p.tickerUpdate(ticker)).peek(p -> this.logger.debug("PositionService - Position {} updated with ticker {}", (Object)p.getPositionId(), (Object)ticker)).forEach(p -> {
            if (p.shouldBeClosed() || this.positionsToClose.contains(p.getPositionId())) {
                OrderCreationResultDTO orderCreationResult;
                if (p.getType() == PositionTypeDTO.LONG) {
                    orderCreationResult = this.tradeService.createSellMarketOrder(p.getStrategy(), ticker.getCurrencyPair(), p.getAmount().getValue());
                } else {
                    BigDecimal amountToBuy = p.getAmountToLock().getValue().divide(ticker.getLast(), RoundingMode.HALF_UP).setScale(8, RoundingMode.FLOOR);
                    orderCreationResult = this.tradeService.createBuyMarketOrder(p.getStrategy(), ticker.getCurrencyPair(), amountToBuy);
                }
                if (orderCreationResult.isSuccessful()) {
                    p.closePositionWithOrderId(orderCreationResult.getOrder().getOrderId());
                    this.logger.debug("PositionService - Position {} closed with order {}", (Object)p.getPositionId(), (Object)orderCreationResult.getOrder().getOrderId());
                }
                if (this.positionsToClose.contains(p.getPositionId())) {
                    this.positionsToClose.remove(p.getPositionId());
                    p.setForceClosing(true);
                }
            }
            this.positionFlux.emitValue(p);
        });
    }

    @Override
    public final HashMap<CurrencyDTO, GainDTO> getGains() {
        LinkedHashMap totalBefore = new LinkedHashMap();
        LinkedHashMap totalAfter = new LinkedHashMap();
        LinkedList totalFees = new LinkedList();
        LinkedHashMap<CurrencyDTO, GainDTO> gains = new LinkedHashMap<CurrencyDTO, GainDTO>();
        this.positionRepository.findByStatus(PositionStatusDTO.CLOSED).stream().map(this.positionMapper::mapToPositionDTO).forEach(p -> {
            CurrencyDTO currency = p.getType() == PositionTypeDTO.LONG ? p.getCurrencyPair().getQuoteCurrency() : p.getCurrencyPair().getBaseCurrency();
            gains.putIfAbsent(currency, null);
            totalBefore.putIfAbsent(currency, BigDecimal.ZERO);
            totalAfter.putIfAbsent(currency, BigDecimal.ZERO);
            if (p.getType() == PositionTypeDTO.LONG) {
                totalBefore.put(currency, p.getOpeningOrder().getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce((BigDecimal)totalBefore.get(currency), BigDecimal::add));
                totalAfter.put(currency, p.getClosingOrder().getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce((BigDecimal)totalAfter.get(currency), BigDecimal::add));
            } else {
                totalBefore.put(currency, p.getOpeningOrder().getTrades().stream().map(t -> t.getAmount().getValue()).reduce((BigDecimal)totalBefore.get(currency), BigDecimal::add));
                totalAfter.put(currency, p.getClosingOrder().getTrades().stream().map(t -> t.getAmount().getValue()).reduce((BigDecimal)totalAfter.get(currency), BigDecimal::add));
            }
            Stream.concat(p.getOpeningOrder().getTrades().stream(), p.getClosingOrder().getTrades().stream()).forEach(t -> totalFees.add(t.getFee()));
        });
        ((HashMap)gains).keySet().forEach(currency -> {
            BigDecimal before = (BigDecimal)totalBefore.get(currency);
            BigDecimal after = (BigDecimal)totalAfter.get(currency);
            BigDecimal gainAmount = after.subtract(before);
            BigDecimal gainPercentage = after.subtract(before).divide(before, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            BigDecimal fees = totalFees.stream().filter(amount -> amount.getCurrency().equals(currency)).map(CurrencyAmountDTO::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            GainDTO g = GainDTO.builder().percentage(gainPercentage.setScale(2, RoundingMode.HALF_UP).doubleValue()).amount(CurrencyAmountDTO.builder().value(gainAmount).currency((CurrencyDTO)currency).build()).fees(CurrencyAmountDTO.builder().value(fees).currency((CurrencyDTO)currency).build()).build();
            gains.put((CurrencyDTO)currency, g);
        });
        return gains;
    }
}

