/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.service.dry;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.user.BalanceDTO;
import tech.cassandre.trading.bot.dto.user.UserDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.service.UserService;
import tech.cassandre.trading.bot.strategy.GenericCassandreStrategy;
import tech.cassandre.trading.bot.util.base.service.BaseService;

public class UserServiceDryModeImplementation
extends BaseService
implements UserService {
    private static final String USER_FILE_PREFIX = "user-";
    private static final String USER_FILE_SUFFIX = ".*sv";
    private static final String USER_ID = "user";
    private static final String TRADE_ACCOUNT_ID = "trade";
    private UserDTO user;
    private GenericCassandreStrategy strategy;

    public UserServiceDryModeImplementation() {
        LinkedHashMap accounts = new LinkedHashMap();
        this.getFilesToLoad().forEach(file -> {
            if (file.getFilename() != null) {
                int accountIndexStart = file.getFilename().indexOf(USER_FILE_PREFIX) + USER_FILE_PREFIX.length();
                int accountIndexStop = file.getFilename().indexOf("sv") - 2;
                String accountName = file.getFilename().substring(accountIndexStart, accountIndexStop);
                this.logger.info("Adding account '" + accountName + "'");
                LinkedHashMap<CurrencyDTO, BalanceDTO> balances = new LinkedHashMap<CurrencyDTO, BalanceDTO>();
                try (Scanner scanner = new Scanner(file.getFile());){
                    while (scanner.hasNextLine()) {
                        try (Scanner rowScanner = new Scanner(scanner.nextLine());){
                            if (file.getFilename().endsWith("tsv")) {
                                rowScanner.useDelimiter("\t");
                            } else {
                                rowScanner.useDelimiter(",");
                            }
                            String currency = rowScanner.next().replaceAll("\"", "");
                            String amount = rowScanner.next().replaceAll("\"", "");
                            this.logger.info("- Adding balance " + amount + " " + currency);
                            BalanceDTO balance = BalanceDTO.builder().currency(new CurrencyDTO(currency)).available(new BigDecimal(amount)).build();
                            balances.put(new CurrencyDTO(currency), balance);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.error("{} not found !", (Object)file.getFilename());
                }
                catch (IOException e) {
                    this.logger.error("IOException : " + e);
                }
                accounts.put(accountName, AccountDTO.builder().accountId(accountName).name(accountName).balances(balances).build());
            }
        });
        this.user = UserDTO.builder().id(USER_ID).accounts(accounts).build();
    }

    public void setDependencies(GenericCassandreStrategy newStrategy) {
        this.strategy = newStrategy;
    }

    @Override
    public final Optional<UserDTO> getUser() {
        return Optional.of(this.user);
    }

    public void addToBalance(CurrencyDTO currency, BigDecimal amount) {
        Optional<BalanceDTO> balance = this.user.getAccounts().get(TRADE_ACCOUNT_ID).getBalance(currency);
        LinkedHashMap accounts = new LinkedHashMap();
        this.user.getAccounts().forEach((s, a) -> {
            LinkedHashMap<CurrencyDTO, BalanceDTO> balances = new LinkedHashMap<CurrencyDTO, BalanceDTO>();
            a.getBalances().forEach((c, b) -> {
                BalanceDTO newBalance = a.getAccountId().equals(TRADE_ACCOUNT_ID) && b.getCurrency().equals(currency) ? BalanceDTO.builder().currency(b.getCurrency()).available(b.getAvailable().add(amount)).build() : BalanceDTO.builder().currency(b.getCurrency()).available(b.getAvailable()).build();
                balances.put(newBalance.getCurrency(), newBalance);
            });
            if (balance.isEmpty()) {
                balances.put(currency, BalanceDTO.builder().currency(currency).available(amount).build());
            }
            AccountDTO account = AccountDTO.builder().accountId(a.getAccountId()).name(a.getName()).balances(balances).build();
            accounts.put(account.getAccountId(), account);
        });
        this.strategy.getAccounts().clear();
        this.strategy.getAccounts().putAll(accounts);
        this.user = UserDTO.builder().id(USER_ID).accounts(accounts).build();
    }

    private List<Resource> getFilesToLoad() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:user-*.*sv");
            return Arrays.asList(resources);
        }
        catch (IOException e) {
            this.logger.error("TickerFluxMock encountered an error : " + e.getMessage());
            return Collections.emptyList();
        }
    }
}

