/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.service.dry;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import tech.cassandre.trading.bot.batch.OrderFlux;
import tech.cassandre.trading.bot.batch.TradeFlux;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderCreationResultDTO;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.OrderStatusDTO;
import tech.cassandre.trading.bot.dto.trade.OrderTypeDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.user.BalanceDTO;
import tech.cassandre.trading.bot.dto.user.UserDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.TradeRepository;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.service.dry.UserServiceDryModeImplementation;
import tech.cassandre.trading.bot.util.base.service.BaseService;

public class TradeServiceDryModeImplementation
extends BaseService
implements TradeService {
    private static final long WAITING_TIME = 500L;
    private static final String DRY_ORDER_PREFIX = "DRY_ORDER_";
    private static final String DRY_TRADE_PREFIX = "DRY_TRADE_";
    private static final String TRADE_ACCOUNT_ID = "trade";
    private final AtomicInteger orderCounter = new AtomicInteger(1);
    private final AtomicInteger tradeCounter = new AtomicInteger(1);
    private final Map<CurrencyPairDTO, TickerDTO> lastTickers = new LinkedHashMap<CurrencyPairDTO, TickerDTO>();
    private OrderFlux orderFlux;
    private TradeFlux tradeFlux;
    private final OrderRepository orderRepository;
    private final TradeRepository tradeRepository;
    private final UserServiceDryModeImplementation userService;

    public TradeServiceDryModeImplementation(UserServiceDryModeImplementation newUserService, TradeRepository newTradeRepository, OrderRepository newOrderRepository) {
        this.userService = newUserService;
        this.tradeRepository = newTradeRepository;
        this.orderRepository = newOrderRepository;
    }

    public void setDependencies(OrderFlux newOrderFlux, TradeFlux newTradeFlux) {
        this.orderFlux = newOrderFlux;
        this.tradeFlux = newTradeFlux;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OrderCreationResultDTO createMarketOrder(StrategyDTO strategy, OrderTypeDTO orderTypeDTO, CurrencyPairDTO currencyPair, BigDecimal amount) {
        BigDecimal ownedAssets;
        Optional<BalanceDTO> balance;
        TickerDTO t = this.lastTickers.get(currencyPair);
        if (t == null) return new OrderCreationResultDTO("Ticker not found", new Exception("Ticker not found"));
        Optional<UserDTO> user = this.userService.getUser();
        if (!user.isPresent()) return new OrderCreationResultDTO("No data for user", new Exception("No data for user"));
        AccountDTO account = this.userService.getUser().get().getAccounts().get(TRADE_ACCOUNT_ID);
        if (account == null) {
            return new OrderCreationResultDTO("No trade account", new Exception("No trade account"));
        }
        if (orderTypeDTO.equals((Object)OrderTypeDTO.BID)) {
            balance = account.getBalance(currencyPair.getQuoteCurrency());
            if (!balance.isPresent()) return new OrderCreationResultDTO("No assets for " + currencyPair.getQuoteCurrency(), new Exception("No assets for " + currencyPair.getQuoteCurrency()));
            ownedAssets = balance.get().getAvailable();
            BigDecimal cost = t.getLast().multiply(amount);
            if (cost.compareTo(ownedAssets) > 0) {
                String errorMessage = "Not enough assets (costs : " + cost + " " + currencyPair.getQuoteCurrency() + " - owned assets : " + ownedAssets + " " + currencyPair.getQuoteCurrency();
                return new OrderCreationResultDTO(errorMessage, new Exception(errorMessage));
            }
        } else {
            balance = account.getBalance(currencyPair.getBaseCurrency());
            if (!balance.isPresent()) return new OrderCreationResultDTO("No assets for " + currencyPair.getBaseCurrency(), new Exception("No assets for " + currencyPair.getBaseCurrency()));
            ownedAssets = balance.get().getAvailable();
            if (amount.compareTo(ownedAssets) > 0) {
                String errorMessage = "Not enough assets (amount : " + amount + " " + currencyPair.getQuoteCurrency() + " - owned assets : " + ownedAssets + " " + currencyPair.getBaseCurrency();
                return new OrderCreationResultDTO(errorMessage, new Exception(errorMessage));
            }
        }
        String orderId = this.getNextOrderNumber();
        OrderDTO order = OrderDTO.builder().orderId(orderId).type(orderTypeDTO).strategy(strategy).currencyPair(currencyPair).amount(CurrencyAmountDTO.builder().value(amount).currency(currencyPair.getBaseCurrency()).build()).averagePrice(CurrencyAmountDTO.builder().value(t.getLast()).currency(currencyPair.getQuoteCurrency()).build()).status(OrderStatusDTO.FILLED).cumulativeAmount(CurrencyAmountDTO.builder().value(amount).currency(currencyPair.getBaseCurrency()).build()).timestamp(t.getTimestamp()).build();
        String tradeId = this.getNextTradeNumber();
        TradeDTO trade = TradeDTO.builder().tradeId(tradeId).type(orderTypeDTO).orderId(orderId).currencyPair(currencyPair).amount(CurrencyAmountDTO.builder().value(amount).currency(currencyPair.getBaseCurrency()).build()).price(CurrencyAmountDTO.builder().value(t.getLast()).currency(currencyPair.getQuoteCurrency()).build()).fee(CurrencyAmountDTO.ZERO).timestamp(t.getTimestamp()).build();
        Executors.newFixedThreadPool(1).submit(() -> {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.orderFlux.emitValue(order);
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.tradeFlux.emitValue(trade);
        });
        if (orderTypeDTO.equals((Object)OrderTypeDTO.BID)) {
            this.userService.addToBalance(currencyPair.getBaseCurrency(), amount);
            this.userService.addToBalance(currencyPair.getQuoteCurrency(), amount.multiply(t.getLast()).multiply(new BigDecimal("-1")));
            return new OrderCreationResultDTO(order);
        } else {
            this.userService.addToBalance(currencyPair.getBaseCurrency(), amount.multiply(new BigDecimal("-1")));
            this.userService.addToBalance(currencyPair.getQuoteCurrency(), amount.multiply(t.getLast()));
        }
        return new OrderCreationResultDTO(order);
    }

    @Override
    public final OrderCreationResultDTO createBuyMarketOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.createMarketOrder(strategy, OrderTypeDTO.BID, currencyPair, amount);
    }

    @Override
    public final OrderCreationResultDTO createSellMarketOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount) {
        return this.createMarketOrder(strategy, OrderTypeDTO.ASK, currencyPair, amount);
    }

    @Override
    public final OrderCreationResultDTO createBuyLimitOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        return new OrderCreationResultDTO("Not implemented", new Exception("Not implemented"));
    }

    @Override
    public final OrderCreationResultDTO createSellLimitOrder(StrategyDTO strategy, CurrencyPairDTO currencyPair, BigDecimal amount, BigDecimal limitPrice) {
        return new OrderCreationResultDTO("Not implemented", new Exception("Not implemented"));
    }

    @Override
    public final Set<OrderDTO> getOpenOrders() {
        return this.getOrders();
    }

    @Override
    public final boolean cancelOrder(String orderId) {
        Optional<Order> order = this.orderRepository.findByOrderId(orderId);
        if (order.isPresent()) {
            this.orderRepository.delete(order.get());
            return true;
        }
        return false;
    }

    @Override
    public final Set<OrderDTO> getOrders() {
        return this.orderRepository.findByOrderByTimestampAsc().stream().map(this.orderMapper::mapToOrderDTO).collect(Collectors.toSet());
    }

    @Override
    public final Set<TradeDTO> getTrades() {
        return this.tradeRepository.findByOrderByTimestampAsc().stream().map(this.tradeMapper::mapToTradeDTO).collect(Collectors.toSet());
    }

    public void tickerUpdate(TickerDTO ticker) {
        this.lastTickers.put(ticker.getCurrencyPair(), ticker);
    }

    private String getNextOrderNumber() {
        return DRY_ORDER_PREFIX.concat(String.format("%09d", this.orderCounter.getAndIncrement()));
    }

    private String getNextTradeNumber() {
        return DRY_TRADE_PREFIX.concat(String.format("%09d", this.tradeCounter.getAndIncrement()));
    }
}

