/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.repository;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import tech.cassandre.trading.bot.domain.Position;
import tech.cassandre.trading.bot.dto.position.PositionStatusDTO;

@Repository
public interface PositionRepository
extends CrudRepository<Position, Long> {
    public Optional<Position> findByPositionId(long var1);

    public List<Position> findByOrderById();

    public List<Position> findByStatus(PositionStatusDTO var1);

    public List<Position> findByStatusNot(PositionStatusDTO var1);

    public List<Position> findByStatusIn(Set<PositionStatusDTO> var1);

    @Transactional
    @Modifying
    @Query(value="update Position p set p.stopGainPercentageRule = :value where p.id = :id")
    public void updateStopGainRule(@Param(value="id") Long var1, @Param(value="value") Float var2);

    @Transactional
    @Modifying
    @Query(value="update Position p set p.stopLossPercentageRule = :value where p.id = :id")
    public void updateStopLossRule(@Param(value="id") Long var1, @Param(value="value") Float var2);

    @Query(value="SELECT coalesce(max(p.positionId), 0) FROM Position p where p.strategy.id = :strategyId")
    public Long getLastPositionIdUsedByStrategy(@Param(value="strategyId") Long var1);
}

