/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.util;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class GainDTO {
    public static final GainDTO ZERO = GainDTO.builder().percentage(0.0).amount(CurrencyAmountDTO.ZERO).fees(CurrencyAmountDTO.ZERO).build();
    private final double percentage;
    private final CurrencyAmountDTO amount;
    private final CurrencyAmountDTO fees;

    public final CurrencyAmountDTO getNetAmount() {
        if (this.amount != null && this.fees != null) {
            return CurrencyAmountDTO.builder().value(this.amount.getValue().subtract(this.fees.getValue())).currency(this.amount.getCurrency()).build();
        }
        return CurrencyAmountDTO.ZERO;
    }

    public boolean isInferiorTo(GainDTO other) {
        if (other != null) {
            return this.getPercentage() < other.getPercentage();
        }
        return false;
    }

    public boolean isSuperiorTo(GainDTO other) {
        if (other != null) {
            return this.getPercentage() > other.getPercentage();
        }
        return false;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GainDTO that = (GainDTO)o;
        return new EqualsBuilder().append(this.amount, that.amount).append(this.fees, that.fees).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.amount).append((Object)this.fees).toHashCode();
    }

    public final String toString() {
        if (this.percentage == 0.0) {
            return "No gain";
        }
        return "Gains: " + this.amount + " (" + this.percentage + " %) / Fees: " + this.fees;
    }

    public static GainDTOBuilder builder() {
        return new GainDTOBuilder();
    }

    public double getPercentage() {
        return this.percentage;
    }

    public CurrencyAmountDTO getAmount() {
        return this.amount;
    }

    public CurrencyAmountDTO getFees() {
        return this.fees;
    }

    private GainDTO(double percentage, CurrencyAmountDTO amount, CurrencyAmountDTO fees) {
        this.percentage = percentage;
        this.amount = amount;
        this.fees = fees;
    }

    public static class GainDTOBuilder {
        private double percentage;
        private CurrencyAmountDTO amount;
        private CurrencyAmountDTO fees;

        GainDTOBuilder() {
        }

        public GainDTOBuilder percentage(double percentage) {
            this.percentage = percentage;
            return this;
        }

        public GainDTOBuilder amount(CurrencyAmountDTO amount) {
            this.amount = amount;
            return this;
        }

        public GainDTOBuilder fees(CurrencyAmountDTO fees) {
            this.fees = fees;
            return this;
        }

        public GainDTO build() {
            return new GainDTO(this.percentage, this.amount, this.fees);
        }

        public String toString() {
            return "GainDTO.GainDTOBuilder(percentage=" + this.percentage + ", amount=" + this.amount + ", fees=" + this.fees + ")";
        }
    }
}

