/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.util;

import java.util.Objects;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.instrument.Instrument;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;

public final class CurrencyPairDTO {
    private static final String CURRENCY_PAIR_SEPARATOR = "/";
    private final CurrencyDTO baseCurrency;
    private final CurrencyDTO quoteCurrency;

    public CurrencyPairDTO(String currencyPair) {
        this(currencyPair.split(CURRENCY_PAIR_SEPARATOR)[0], currencyPair.split(CURRENCY_PAIR_SEPARATOR)[1]);
    }

    public CurrencyPairDTO(CurrencyPair currencyPair) {
        this(currencyPair.base.toString(), currencyPair.counter.toString());
    }

    public CurrencyPairDTO(String newBaseCurrency, String newQuoteCurrency) {
        this(CurrencyDTO.getInstance(newBaseCurrency), CurrencyDTO.getInstance(newQuoteCurrency));
    }

    public CurrencyPairDTO(CurrencyDTO newBaseCurrency, CurrencyDTO newQuoteCurrency) {
        this.baseCurrency = newBaseCurrency;
        this.quoteCurrency = newQuoteCurrency;
    }

    public CurrencyPairDTO(Instrument instrument) {
        CurrencyPair cp = (CurrencyPair)instrument;
        this.baseCurrency = new CurrencyDTO(cp.base.getCurrencyCode());
        this.quoteCurrency = new CurrencyDTO(cp.counter.getCurrencyCode());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyPairDTO that = (CurrencyPairDTO)o;
        return this.getBaseCurrency().getCode().equalsIgnoreCase(that.getBaseCurrency().getCode()) && this.getQuoteCurrency().getCode().equalsIgnoreCase(that.getQuoteCurrency().getCode());
    }

    public final int hashCode() {
        return Objects.hash(this.getBaseCurrency().getCode(), this.getQuoteCurrency().getCode());
    }

    public final String toString() {
        return this.baseCurrency + CURRENCY_PAIR_SEPARATOR + this.quoteCurrency;
    }

    public static CurrencyPairDTOBuilder builder() {
        return new CurrencyPairDTOBuilder();
    }

    public CurrencyDTO getBaseCurrency() {
        return this.baseCurrency;
    }

    public CurrencyDTO getQuoteCurrency() {
        return this.quoteCurrency;
    }

    public static class CurrencyPairDTOBuilder {
        private CurrencyDTO baseCurrency;
        private CurrencyDTO quoteCurrency;

        CurrencyPairDTOBuilder() {
        }

        public CurrencyPairDTOBuilder baseCurrency(CurrencyDTO baseCurrency) {
            this.baseCurrency = baseCurrency;
            return this;
        }

        public CurrencyPairDTOBuilder quoteCurrency(CurrencyDTO quoteCurrency) {
            this.quoteCurrency = quoteCurrency;
            return this;
        }

        public CurrencyPairDTO build() {
            return new CurrencyPairDTO(this.baseCurrency, this.quoteCurrency);
        }

        public String toString() {
            return "CurrencyPairDTO.CurrencyPairDTOBuilder(baseCurrency=" + this.baseCurrency + ", quoteCurrency=" + this.quoteCurrency + ")";
        }
    }
}

