/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CurrencyDTO
implements Serializable {
    private static final Map<String, CurrencyDTO> CURRENCIES = new HashMap<String, CurrencyDTO>();
    public static final CurrencyDTO AED = CurrencyDTO.createCurrency("AED", "United Arab Emirates Dirham", null, new String[0]);
    public static final CurrencyDTO AFN = CurrencyDTO.createCurrency("AFN", "Afghan Afghani", null, new String[0]);
    public static final CurrencyDTO ALL = CurrencyDTO.createCurrency("ALL", "Albanian Lek", null, new String[0]);
    public static final CurrencyDTO AMD = CurrencyDTO.createCurrency("AMD", "Armenian Dram", null, new String[0]);
    public static final CurrencyDTO ANC = CurrencyDTO.createCurrency("ANC", "Anoncoin", null, new String[0]);
    public static final CurrencyDTO ANG = CurrencyDTO.createCurrency("ANG", "Netherlands Antillean Guilder", null, new String[0]);
    public static final CurrencyDTO AOA = CurrencyDTO.createCurrency("AOA", "Angolan Kwanza", null, new String[0]);
    public static final CurrencyDTO ARN = CurrencyDTO.createCurrency("ARN", "Aeron", null, new String[0]);
    public static final CurrencyDTO ARS = CurrencyDTO.createCurrency("ARS", "Argentine Peso", null, new String[0]);
    public static final CurrencyDTO ATOM = CurrencyDTO.createCurrency("ATOM", "Cosmos", null, new String[0]);
    public static final CurrencyDTO AUD = CurrencyDTO.createCurrency("AUD", "Australian Dollar", null, new String[0]);
    public static final CurrencyDTO AUR = CurrencyDTO.createCurrency("AUR", "Auroracoin", null, new String[0]);
    public static final CurrencyDTO AVT = CurrencyDTO.createCurrency("AVT", "Aventus", null, new String[0]);
    public static final CurrencyDTO AWG = CurrencyDTO.createCurrency("AWG", "Aruban Florin", null, new String[0]);
    public static final CurrencyDTO AZN = CurrencyDTO.createCurrency("AZN", "Azerbaijani Manat", null, new String[0]);
    public static final CurrencyDTO BAM = CurrencyDTO.createCurrency("BAM", "Bosnia-Herzegovina Convertible Mark", null, new String[0]);
    public static final CurrencyDTO BAT = CurrencyDTO.createCurrency("BAT", "Basic Attention Token", null, new String[0]);
    public static final CurrencyDTO BBD = CurrencyDTO.createCurrency("BBD", "Barbadian Dollar", null, new String[0]);
    public static final CurrencyDTO BC = CurrencyDTO.createCurrency("BC", "BlackCoin", null, "BLK");
    public static final CurrencyDTO BCC = CurrencyDTO.createCurrency("BCC", "BitConnect", null, new String[0]);
    public static final CurrencyDTO BCH = CurrencyDTO.createCurrency("BCH", "BitcoinCash", null, new String[0]);
    public static final CurrencyDTO BCA = CurrencyDTO.createCurrency("BCA", "BitcoinAtom", null, new String[0]);
    public static final CurrencyDTO BLK = CurrencyDTO.getInstance("BLK");
    public static final CurrencyDTO BDT = CurrencyDTO.createCurrency("BDT", "Bangladeshi Taka", null, new String[0]);
    public static final CurrencyDTO BGC = CurrencyDTO.createCurrency("BGC", "Aten 'Black Gold' Coin", null, new String[0]);
    public static final CurrencyDTO BGN = CurrencyDTO.createCurrency("BGN", "Bulgarian Lev", null, new String[0]);
    public static final CurrencyDTO BHD = CurrencyDTO.createCurrency("BHD", "Bahraini Dinar", null, new String[0]);
    public static final CurrencyDTO BIF = CurrencyDTO.createCurrency("BIF", "Burundian Franc", null, new String[0]);
    public static final CurrencyDTO BMD = CurrencyDTO.createCurrency("BMD", "Bermudan Dollar", null, new String[0]);
    public static final CurrencyDTO BND = CurrencyDTO.createCurrency("BND", "Brunei Dollar", null, new String[0]);
    public static final CurrencyDTO BOB = CurrencyDTO.createCurrency("BOB", "Bolivian Boliviano", null, new String[0]);
    public static final CurrencyDTO BRL = CurrencyDTO.createCurrency("BRL", "Brazilian Real", "R$", new String[0]);
    public static final CurrencyDTO BSD = CurrencyDTO.createCurrency("BSD", "Bahamian Dollar", null, new String[0]);
    public static final CurrencyDTO BTC = CurrencyDTO.createCurrency("BTC", "Bitcoin", null, "XBT");
    public static final CurrencyDTO BTG = CurrencyDTO.createCurrency("BTG", "Bitcoin Gold", null, new String[0]);
    public static final CurrencyDTO XBT = CurrencyDTO.getInstance("XBT");
    public static final CurrencyDTO BTN = CurrencyDTO.createCurrency("BTN", "Bhutanese Ngultrum", null, new String[0]);
    public static final CurrencyDTO BWP = CurrencyDTO.createCurrency("BWP", "Botswanan Pula", null, new String[0]);
    public static final CurrencyDTO BYR = CurrencyDTO.createCurrency("BYR", "Belarusian Ruble", null, new String[0]);
    public static final CurrencyDTO BZD = CurrencyDTO.createCurrency("BZD", "Belize Dollar", null, new String[0]);
    public static final CurrencyDTO CAD = CurrencyDTO.createCurrency("CAD", "Canadian Dollar", null, new String[0]);
    public static final CurrencyDTO CDF = CurrencyDTO.createCurrency("CDF", "Congolese Franc", null, new String[0]);
    public static final CurrencyDTO CHF = CurrencyDTO.createCurrency("CHF", "Swiss Franc", null, new String[0]);
    public static final CurrencyDTO CLF = CurrencyDTO.createCurrency("CLF", "Chilean Unit of Account (UF)", null, new String[0]);
    public static final CurrencyDTO CLP = CurrencyDTO.createCurrency("CLP", "Chilean Peso", null, new String[0]);
    public static final CurrencyDTO CNC = CurrencyDTO.createCurrency("CNC", "Chinacoin", null, new String[0]);
    public static final CurrencyDTO CNY = CurrencyDTO.createCurrency("CNY", "Chinese Yuan", null, new String[0]);
    public static final CurrencyDTO COP = CurrencyDTO.createCurrency("COP", "Colombian Peso", null, new String[0]);
    public static final CurrencyDTO CRC = CurrencyDTO.createCurrency("CRC", "Costa Rican Col\u00f3n", null, new String[0]);
    public static final CurrencyDTO CUP = CurrencyDTO.createCurrency("CUP", "Cuban Peso", null, new String[0]);
    public static final CurrencyDTO CVE = CurrencyDTO.createCurrency("CVE", "Cape Verdean Escudo", null, new String[0]);
    public static final CurrencyDTO CZK = CurrencyDTO.createCurrency("CZK", "Czech Republic Koruna", null, new String[0]);
    public static final CurrencyDTO DASH = CurrencyDTO.createCurrency("DASH", "Dash", null, new String[0]);
    public static final CurrencyDTO DCR = CurrencyDTO.createCurrency("DCR", "Decred", null, new String[0]);
    public static final CurrencyDTO DGB = CurrencyDTO.createCurrency("DGB", "DigiByte", null, new String[0]);
    public static final CurrencyDTO DJF = CurrencyDTO.createCurrency("DJF", "Djiboutian Franc", null, new String[0]);
    public static final CurrencyDTO DKK = CurrencyDTO.createCurrency("DKK", "Danish Krone", null, new String[0]);
    public static final CurrencyDTO DOGE = CurrencyDTO.createCurrency("DOGE", "Dogecoin", null, "XDC", "XDG");
    public static final CurrencyDTO XDC = CurrencyDTO.getInstance("XDC");
    public static final CurrencyDTO XDG = CurrencyDTO.getInstance("XDG");
    public static final CurrencyDTO DOP = CurrencyDTO.createCurrency("DOP", "Dominican Peso", null, new String[0]);
    public static final CurrencyDTO DGC = CurrencyDTO.createCurrency("DGC", "Digitalcoin", null, new String[0]);
    public static final CurrencyDTO DVC = CurrencyDTO.createCurrency("DVC", "Devcoin", null, new String[0]);
    public static final CurrencyDTO DRK = CurrencyDTO.createCurrency("DRK", "Darkcoin", null, new String[0]);
    public static final CurrencyDTO DZD = CurrencyDTO.createCurrency("DZD", "Algerian Dinar", null, new String[0]);
    public static final CurrencyDTO EDO = CurrencyDTO.createCurrency("EDO", "Eidoo", null, new String[0]);
    public static final CurrencyDTO EEK = CurrencyDTO.createCurrency("EEK", "Estonian Kroon", null, new String[0]);
    public static final CurrencyDTO EGD = CurrencyDTO.createCurrency("EGD", "Egoldcoin", null, new String[0]);
    public static final CurrencyDTO EGP = CurrencyDTO.createCurrency("EGP", "Egyptian Pound", null, new String[0]);
    public static final CurrencyDTO EOS = CurrencyDTO.createCurrency("EOS", "EOS", null, new String[0]);
    public static final CurrencyDTO ETB = CurrencyDTO.createCurrency("ETB", "Ethiopian Birr", null, new String[0]);
    public static final CurrencyDTO ETC = CurrencyDTO.createCurrency("ETC", "Ether Classic", null, new String[0]);
    public static final CurrencyDTO ETH = CurrencyDTO.createCurrency("ETH", "Ether", null, new String[0]);
    public static final CurrencyDTO EUR = CurrencyDTO.createCurrency("EUR", "Euro", null, new String[0]);
    public static final CurrencyDTO FJD = CurrencyDTO.createCurrency("FJD", "Fijian Dollar", null, new String[0]);
    public static final CurrencyDTO _1ST = CurrencyDTO.createCurrency("1ST", "First Blood", null, new String[0]);
    public static final CurrencyDTO FKP = CurrencyDTO.createCurrency("FKP", "Falkland Islands Pound", null, new String[0]);
    public static final CurrencyDTO FTC = CurrencyDTO.createCurrency("FTC", "Feathercoin", null, new String[0]);
    public static final CurrencyDTO GBP = CurrencyDTO.createCurrency("GBP", "British Pound Sterling", null, new String[0]);
    public static final CurrencyDTO GEL = CurrencyDTO.createCurrency("GEL", "Georgian Lari", null, new String[0]);
    public static final CurrencyDTO GHS = CurrencyDTO.createCurrency("GHS", "Ghanaian Cedi", null, new String[0]);
    public static final CurrencyDTO GHs = CurrencyDTO.createCurrency("GHS", "Gigahashes per second", null, new String[0]);
    public static final CurrencyDTO GIP = CurrencyDTO.createCurrency("GIP", "Gibraltar Pound", null, new String[0]);
    public static final CurrencyDTO GMD = CurrencyDTO.createCurrency("GMD", "Gambian Dalasi", null, new String[0]);
    public static final CurrencyDTO GNF = CurrencyDTO.createCurrency("GNF", "Guinean Franc", null, new String[0]);
    public static final CurrencyDTO GNO = CurrencyDTO.createCurrency("GNO", "Gnosis", null, new String[0]);
    public static final CurrencyDTO GNT = CurrencyDTO.createCurrency("GNT", "Golem", null, new String[0]);
    public static final CurrencyDTO GTQ = CurrencyDTO.createCurrency("GTQ", "Guatemalan Quetzal", null, new String[0]);
    public static final CurrencyDTO GVT = CurrencyDTO.createCurrency("GVT", "Genesis Vision", null, new String[0]);
    public static final CurrencyDTO GYD = CurrencyDTO.createCurrency("GYD", "Guyanaese Dollar", null, new String[0]);
    public static final CurrencyDTO HKD = CurrencyDTO.createCurrency("HKD", "Hong Kong Dollar", null, new String[0]);
    public static final CurrencyDTO HVN = CurrencyDTO.createCurrency("HVN", "Hive", null, new String[0]);
    public static final CurrencyDTO HNL = CurrencyDTO.createCurrency("HNL", "Honduran Lempira", null, new String[0]);
    public static final CurrencyDTO HRK = CurrencyDTO.createCurrency("HRK", "Croatian Kuna", null, new String[0]);
    public static final CurrencyDTO HTG = CurrencyDTO.createCurrency("HTG", "Haitian Gourde", null, new String[0]);
    public static final CurrencyDTO HUF = CurrencyDTO.createCurrency("HUF", "Hungarian Forint", null, new String[0]);
    public static final CurrencyDTO ICN = CurrencyDTO.createCurrency("ICN", "Iconomi", null, new String[0]);
    public static final CurrencyDTO IDR = CurrencyDTO.createCurrency("IDR", "Indonesian Rupiah", null, new String[0]);
    public static final CurrencyDTO ILS = CurrencyDTO.createCurrency("ILS", "Israeli New Sheqel", null, new String[0]);
    public static final CurrencyDTO INR = CurrencyDTO.createCurrency("INR", "Indian Rupee", null, new String[0]);
    public static final CurrencyDTO IOC = CurrencyDTO.createCurrency("IOC", "I/OCoin", null, new String[0]);
    public static final CurrencyDTO IOT = CurrencyDTO.createCurrency("IOT", "IOTA", null, new String[0]);
    public static final CurrencyDTO IQD = CurrencyDTO.createCurrency("IQD", "Iraqi Dinar", null, new String[0]);
    public static final CurrencyDTO IRR = CurrencyDTO.createCurrency("IRR", "Iranian Rial", null, new String[0]);
    public static final CurrencyDTO ISK = CurrencyDTO.createCurrency("ISK", "Icelandic Kr\u00f3na", null, new String[0]);
    public static final CurrencyDTO IXC = CurrencyDTO.createCurrency("IXC", "iXcoin", null, new String[0]);
    public static final CurrencyDTO JEP = CurrencyDTO.createCurrency("JEP", "Jersey Pound", null, new String[0]);
    public static final CurrencyDTO JMD = CurrencyDTO.createCurrency("JMD", "Jamaican Dollar", null, new String[0]);
    public static final CurrencyDTO JOD = CurrencyDTO.createCurrency("JOD", "Jordanian Dinar", null, new String[0]);
    public static final CurrencyDTO JPY = CurrencyDTO.createCurrency("JPY", "Japanese Yen", null, new String[0]);
    public static final CurrencyDTO KCS = CurrencyDTO.createCurrency("KCS", "KuCoin Shares", null, new String[0]);
    public static final CurrencyDTO KES = CurrencyDTO.createCurrency("KES", "Kenyan Shilling", null, new String[0]);
    public static final CurrencyDTO KGS = CurrencyDTO.createCurrency("KGS", "Kyrgystani Som", null, new String[0]);
    public static final CurrencyDTO KHR = CurrencyDTO.createCurrency("KHR", "Cambodian Riel", null, new String[0]);
    public static final CurrencyDTO KICK = CurrencyDTO.createCurrency("KICK", "KickCoin", null, new String[0]);
    public static final CurrencyDTO KMF = CurrencyDTO.createCurrency("KMF", "Comorian Franc", null, new String[0]);
    public static final CurrencyDTO KPW = CurrencyDTO.createCurrency("KPW", "North Korean Won", null, new String[0]);
    public static final CurrencyDTO KRW = CurrencyDTO.createCurrency("KRW", "South Korean Won", null, new String[0]);
    public static final CurrencyDTO KWD = CurrencyDTO.createCurrency("KWD", "Kuwaiti Dinar", null, new String[0]);
    public static final CurrencyDTO KYD = CurrencyDTO.createCurrency("KYD", "Cayman Islands Dollar", null, new String[0]);
    public static final CurrencyDTO KZT = CurrencyDTO.createCurrency("KZT", "Kazakhstani Tenge", null, new String[0]);
    public static final CurrencyDTO LAK = CurrencyDTO.createCurrency("LAK", "Laotian Kip", null, new String[0]);
    public static final CurrencyDTO LBP = CurrencyDTO.createCurrency("LBP", "Lebanese Pound", null, new String[0]);
    public static final CurrencyDTO LSK = CurrencyDTO.createCurrency("LSK", "Lisk", null, new String[0]);
    public static final CurrencyDTO LKR = CurrencyDTO.createCurrency("LKR", "Sri Lankan Rupee", null, new String[0]);
    public static final CurrencyDTO LRD = CurrencyDTO.createCurrency("LRD", "Liberian Dollar", null, new String[0]);
    public static final CurrencyDTO LSL = CurrencyDTO.createCurrency("LSL", "Lesotho Loti", null, new String[0]);
    public static final CurrencyDTO LTC = CurrencyDTO.createCurrency("LTC", "Litecoin", null, "XLT");
    public static final CurrencyDTO XLT = CurrencyDTO.getInstance("XLT");
    public static final CurrencyDTO LTL = CurrencyDTO.createCurrency("LTL", "Lithuanian Litas", null, new String[0]);
    public static final CurrencyDTO LVL = CurrencyDTO.createCurrency("LVL", "Latvian Lats", null, new String[0]);
    public static final CurrencyDTO LYD = CurrencyDTO.createCurrency("LYD", "Libyan Dinar", null, new String[0]);
    public static final CurrencyDTO MAD = CurrencyDTO.createCurrency("MAD", "Moroccan Dirham", null, new String[0]);
    public static final CurrencyDTO MDL = CurrencyDTO.createCurrency("MDL", "Moldovan Leu", null, new String[0]);
    public static final CurrencyDTO MEC = CurrencyDTO.createCurrency("MEC", "MegaCoin", null, new String[0]);
    public static final CurrencyDTO MGA = CurrencyDTO.createCurrency("MGA", "Malagasy Ariary", null, new String[0]);
    public static final CurrencyDTO MKD = CurrencyDTO.createCurrency("MKD", "Macedonian Denar", null, new String[0]);
    public static final CurrencyDTO MLN = CurrencyDTO.createCurrency("MLN", "Melonport", null, new String[0]);
    public static final CurrencyDTO MMK = CurrencyDTO.createCurrency("MMK", "Myanma Kyat", null, new String[0]);
    public static final CurrencyDTO MNT = CurrencyDTO.createCurrency("MNT", "Mongolian Tugrik", null, new String[0]);
    public static final CurrencyDTO MOP = CurrencyDTO.createCurrency("MOP", "Macanese Pataca", null, new String[0]);
    public static final CurrencyDTO MRO = CurrencyDTO.createCurrency("MRO", "Mauritanian Ouguiya", null, new String[0]);
    public static final CurrencyDTO MSC = CurrencyDTO.createCurrency("MSC", "Mason Coin", null, new String[0]);
    public static final CurrencyDTO MUR = CurrencyDTO.createCurrency("MUR", "Mauritian Rupee", null, new String[0]);
    public static final CurrencyDTO MVR = CurrencyDTO.createCurrency("MVR", "Maldivian Rufiyaa", null, new String[0]);
    public static final CurrencyDTO MWK = CurrencyDTO.createCurrency("MWK", "Malawian Kwacha", null, new String[0]);
    public static final CurrencyDTO MXN = CurrencyDTO.createCurrency("MXN", "Mexican Peso", null, new String[0]);
    public static final CurrencyDTO MYR = CurrencyDTO.createCurrency("MYR", "Malaysian Ringgit", null, new String[0]);
    public static final CurrencyDTO MZN = CurrencyDTO.createCurrency("MZN", "Mozambican Metical", null, new String[0]);
    public static final CurrencyDTO NAD = CurrencyDTO.createCurrency("NAD", "Namibian Dollar", null, new String[0]);
    public static final CurrencyDTO NOBS = CurrencyDTO.createCurrency("NOBS", "No BS Crypto", null, new String[0]);
    public static final CurrencyDTO NEO = CurrencyDTO.createCurrency("NEO", "NEO", null, new String[0]);
    public static final CurrencyDTO NGN = CurrencyDTO.createCurrency("NGN", "Nigerian Naira", null, new String[0]);
    public static final CurrencyDTO NIO = CurrencyDTO.createCurrency("NIO", "Nicaraguan C\u00f3rdoba", null, new String[0]);
    public static final CurrencyDTO NMC = CurrencyDTO.createCurrency("NMC", "Namecoin", null, new String[0]);
    public static final CurrencyDTO NOK = CurrencyDTO.createCurrency("NOK", "Norwegian Krone", null, new String[0]);
    public static final CurrencyDTO NPR = CurrencyDTO.createCurrency("NPR", "Nepalese Rupee", null, new String[0]);
    public static final CurrencyDTO NVC = CurrencyDTO.createCurrency("NVC", "Novacoin", null, new String[0]);
    public static final CurrencyDTO NXT = CurrencyDTO.createCurrency("NXT", "Nextcoin", null, new String[0]);
    public static final CurrencyDTO NZD = CurrencyDTO.createCurrency("NZD", "New Zealand Dollar", null, new String[0]);
    public static final CurrencyDTO OMG = CurrencyDTO.createCurrency("OMG", "OmiseGO", null, new String[0]);
    public static final CurrencyDTO OMR = CurrencyDTO.createCurrency("OMR", "Omani Rial", null, new String[0]);
    public static final CurrencyDTO PAB = CurrencyDTO.createCurrency("PAB", "Panamanian Balboa", null, new String[0]);
    public static final CurrencyDTO PEN = CurrencyDTO.createCurrency("PEN", "Peruvian Nuevo Sol", null, new String[0]);
    public static final CurrencyDTO PGK = CurrencyDTO.createCurrency("PGK", "Papua New Guinean Kina", null, new String[0]);
    public static final CurrencyDTO PHP = CurrencyDTO.createCurrency("PHP", "Philippine Peso", null, new String[0]);
    public static final CurrencyDTO PKR = CurrencyDTO.createCurrency("PKR", "Pakistani Rupee", null, new String[0]);
    public static final CurrencyDTO PLN = CurrencyDTO.createCurrency("PLN", "Polish Zloty", null, new String[0]);
    public static final CurrencyDTO POT = CurrencyDTO.createCurrency("POT", "PotCoin", null, new String[0]);
    public static final CurrencyDTO PPC = CurrencyDTO.createCurrency("PPC", "Peercoin", null, new String[0]);
    public static final CurrencyDTO PYG = CurrencyDTO.createCurrency("PYG", "Paraguayan Guarani", null, new String[0]);
    public static final CurrencyDTO QAR = CurrencyDTO.createCurrency("QAR", "Qatari Rial", null, new String[0]);
    public static final CurrencyDTO QRK = CurrencyDTO.createCurrency("QRK", "QuarkCoin", null, new String[0]);
    public static final CurrencyDTO QTUM = CurrencyDTO.createCurrency("QTUM", "Qtum", null, new String[0]);
    public static final CurrencyDTO REP = CurrencyDTO.createCurrency("REP", "Augur", null, new String[0]);
    public static final CurrencyDTO RON = CurrencyDTO.createCurrency("RON", "Romanian Leu", null, new String[0]);
    public static final CurrencyDTO RSD = CurrencyDTO.createCurrency("RSD", "Serbian Dinar", null, new String[0]);
    public static final CurrencyDTO RUB = CurrencyDTO.createCurrency("RUB", "Russian Ruble", null, new String[0]);
    public static final CurrencyDTO RUR = CurrencyDTO.createCurrency("RUR", "Old Russian Ruble", null, new String[0]);
    public static final CurrencyDTO RWF = CurrencyDTO.createCurrency("RWF", "Rwandan Franc", null, new String[0]);
    public static final CurrencyDTO SAR = CurrencyDTO.createCurrency("SAR", "Saudi Riyal", null, new String[0]);
    public static final CurrencyDTO SBC = CurrencyDTO.createCurrency("SBC", "Stablecoin", null, new String[0]);
    public static final CurrencyDTO SBD = CurrencyDTO.createCurrency("SBD", "Solomon Islands Dollar", null, new String[0]);
    public static final CurrencyDTO SC = CurrencyDTO.createCurrency("SC", "Siacoin", null, new String[0]);
    public static final CurrencyDTO SCR = CurrencyDTO.createCurrency("SCR", "Seychellois Rupee", null, new String[0]);
    public static final CurrencyDTO SDG = CurrencyDTO.createCurrency("SDG", "Sudanese Pound", null, new String[0]);
    public static final CurrencyDTO SEK = CurrencyDTO.createCurrency("SEK", "Swedish Krona", null, new String[0]);
    public static final CurrencyDTO SGD = CurrencyDTO.createCurrency("SGD", "Singapore Dollar", null, new String[0]);
    public static final CurrencyDTO SHP = CurrencyDTO.createCurrency("SHP", "Saint Helena Pound", null, new String[0]);
    public static final CurrencyDTO SLL = CurrencyDTO.createCurrency("SLL", "Sierra Leonean Leone", null, new String[0]);
    public static final CurrencyDTO SMART = CurrencyDTO.createCurrency("SMART", "SmartCash", null, new String[0]);
    public static final CurrencyDTO SOS = CurrencyDTO.createCurrency("SOS", "Somali Shilling", null, new String[0]);
    public static final CurrencyDTO SRD = CurrencyDTO.createCurrency("SRD", "Surinamese Dollar", null, new String[0]);
    public static final CurrencyDTO START = CurrencyDTO.createCurrency("START", "startcoin", null, new String[0]);
    public static final CurrencyDTO STEEM = CurrencyDTO.createCurrency("STEEM", "Steem", null, new String[0]);
    public static final CurrencyDTO STD = CurrencyDTO.createCurrency("STD", "S\u00e3o Tom\u00e9 and Pr\u00edncipe Dobra", null, new String[0]);
    public static final CurrencyDTO STR = CurrencyDTO.createCurrency("STR", "Stellar", null, new String[0]);
    public static final CurrencyDTO STRAT = CurrencyDTO.createCurrency("STRAT", "Stratis", null, new String[0]);
    public static final CurrencyDTO SVC = CurrencyDTO.createCurrency("SVC", "Salvadoran Col\u00f3n", null, new String[0]);
    public static final CurrencyDTO SYP = CurrencyDTO.createCurrency("SYP", "Syrian Pound", null, new String[0]);
    public static final CurrencyDTO SZL = CurrencyDTO.createCurrency("SZL", "Swazi Lilangeni", null, new String[0]);
    public static final CurrencyDTO THB = CurrencyDTO.createCurrency("THB", "Thai Baht", null, new String[0]);
    public static final CurrencyDTO TJS = CurrencyDTO.createCurrency("TJS", "Tajikistani Somoni", null, new String[0]);
    public static final CurrencyDTO TMT = CurrencyDTO.createCurrency("TMT", "Turkmenistani Manat", null, new String[0]);
    public static final CurrencyDTO TND = CurrencyDTO.createCurrency("TND", "Tunisian Dinar", null, new String[0]);
    public static final CurrencyDTO TOP = CurrencyDTO.createCurrency("TOP", "Tongan Pa\u02bbanga", null, new String[0]);
    public static final CurrencyDTO TRC = CurrencyDTO.createCurrency("TRC", "Terracoin", null, new String[0]);
    public static final CurrencyDTO TRY = CurrencyDTO.createCurrency("TRY", "Turkish Lira", null, new String[0]);
    public static final CurrencyDTO TTD = CurrencyDTO.createCurrency("TTD", "Trinidad and Tobago Dollar", null, new String[0]);
    public static final CurrencyDTO TWD = CurrencyDTO.createCurrency("TWD", "New Taiwan Dollar", null, new String[0]);
    public static final CurrencyDTO TZS = CurrencyDTO.createCurrency("TZS", "Tanzanian Shilling", null, new String[0]);
    public static final CurrencyDTO UAH = CurrencyDTO.createCurrency("UAH", "Ukrainian Hryvnia", null, new String[0]);
    public static final CurrencyDTO UGX = CurrencyDTO.createCurrency("UGX", "Ugandan Shilling", null, new String[0]);
    public static final CurrencyDTO USD = CurrencyDTO.createCurrency("USD", "United States Dollar", null, new String[0]);
    public static final CurrencyDTO USDT = CurrencyDTO.createCurrency("USDT", "Tether USD Anchor", null, new String[0]);
    public static final CurrencyDTO USDE = CurrencyDTO.createCurrency("USDE", "Unitary Status Dollar eCoin", null, new String[0]);
    public static final CurrencyDTO UTC = CurrencyDTO.createCurrency("UTC", "Ultracoin", null, new String[0]);
    public static final CurrencyDTO UYU = CurrencyDTO.createCurrency("UYU", "Uruguayan Peso", null, new String[0]);
    public static final CurrencyDTO UZS = CurrencyDTO.createCurrency("UZS", "Uzbekistan Som", null, new String[0]);
    public static final CurrencyDTO VEF = CurrencyDTO.createCurrency("VEF", "Venezuelan Bol\u00edvar", null, new String[0]);
    public static final CurrencyDTO VET = CurrencyDTO.createCurrency("VET", "Hub Culture's Vet", null, "VEN");
    public static final CurrencyDTO VEN = CurrencyDTO.createCurrency("VEN", "Hub Culture's Ven", null, "XVN");
    public static final CurrencyDTO XTZ = CurrencyDTO.createCurrency("XTZ", "Tezos", null, new String[0]);
    public static final CurrencyDTO XVN = CurrencyDTO.getInstance("XVN");
    public static final CurrencyDTO VIB = CurrencyDTO.createCurrency("VIB", "Viberate", null, new String[0]);
    public static final CurrencyDTO VND = CurrencyDTO.createCurrency("VND", "Vietnamese Dong", null, new String[0]);
    public static final CurrencyDTO VUV = CurrencyDTO.createCurrency("VUV", "Vanuatu Vatu", null, new String[0]);
    public static final CurrencyDTO WDC = CurrencyDTO.createCurrency("WDC", "WorldCoin", null, new String[0]);
    public static final CurrencyDTO WST = CurrencyDTO.createCurrency("WST", "Samoan Tala", null, new String[0]);
    public static final CurrencyDTO XAF = CurrencyDTO.createCurrency("XAF", "CFA Franc BEAC", null, new String[0]);
    public static final CurrencyDTO XAS = CurrencyDTO.createCurrency("XAS", "Asch", null, new String[0]);
    public static final CurrencyDTO XAUR = CurrencyDTO.createCurrency("XAUR", "Xaurum", null, new String[0]);
    public static final CurrencyDTO XCD = CurrencyDTO.createCurrency("XCD", "East Caribbean Dollar", null, new String[0]);
    public static final CurrencyDTO XDR = CurrencyDTO.createCurrency("XDR", "Special Drawing Rights", null, new String[0]);
    public static final CurrencyDTO XEM = CurrencyDTO.createCurrency("XEM", "NEM", null, new String[0]);
    public static final CurrencyDTO XLM = CurrencyDTO.createCurrency("XLM", "Stellar Lumen", null, new String[0]);
    public static final CurrencyDTO XMR = CurrencyDTO.createCurrency("XMR", "Monero", null, new String[0]);
    public static final CurrencyDTO XRB = CurrencyDTO.createCurrency("XRB", "Rai Blocks", null, new String[0]);
    public static final CurrencyDTO XOF = CurrencyDTO.createCurrency("XOF", "CFA Franc BCEAO", null, new String[0]);
    public static final CurrencyDTO XPF = CurrencyDTO.createCurrency("XPF", "CFP Franc", null, new String[0]);
    public static final CurrencyDTO XPM = CurrencyDTO.createCurrency("XPM", "Primecoin", null, new String[0]);
    public static final CurrencyDTO XRP = CurrencyDTO.createCurrency("XRP", "Ripple", null, new String[0]);
    public static final CurrencyDTO YBC = CurrencyDTO.createCurrency("YBC", "YbCoin", null, new String[0]);
    public static final CurrencyDTO YER = CurrencyDTO.createCurrency("YER", "Yemeni Rial", null, new String[0]);
    public static final CurrencyDTO ZAR = CurrencyDTO.createCurrency("ZAR", "South African Rand", null, new String[0]);
    public static final CurrencyDTO ZEC = CurrencyDTO.createCurrency("ZEC", "Zcash", null, new String[0]);
    public static final CurrencyDTO ZEN = CurrencyDTO.createCurrency("ZEN", "ZenCash", null, new String[0]);
    public static final CurrencyDTO ZMK = CurrencyDTO.createCurrency("ZMK", "Zambian Kwacha", null, new String[0]);
    public static final CurrencyDTO ZRC = CurrencyDTO.createCurrency("ZRC", "ziftrCOIN", null, new String[0]);
    public static final CurrencyDTO ZWL = CurrencyDTO.createCurrency("ZWL", "Zimbabwean Dollar", null, new String[0]);
    public static final CurrencyDTO H18 = CurrencyDTO.createCurrency("H18", "March 30th", null, new String[0]);
    public static final CurrencyDTO M18 = CurrencyDTO.createCurrency("M18", "June 29th", null, new String[0]);
    public static final CurrencyDTO U18 = CurrencyDTO.createCurrency("U18", "September 28th", null, new String[0]);
    public static final CurrencyDTO Z18 = CurrencyDTO.createCurrency("Z18", "December 28th", null, new String[0]);
    public static final CurrencyDTO H19 = CurrencyDTO.createCurrency("H19", "March 29th", null, new String[0]);
    public static final CurrencyDTO M19 = CurrencyDTO.createCurrency("M19", "June 28th", null, new String[0]);
    public static final CurrencyDTO BNK = CurrencyDTO.createCurrency("BNK", "Bankera Coin", null, new String[0]);
    public static final CurrencyDTO BNB = CurrencyDTO.createCurrency("BNB", "Binance Coin", null, new String[0]);
    public static final CurrencyDTO QSP = CurrencyDTO.createCurrency("QSP", "Quantstamp", null, new String[0]);
    public static final CurrencyDTO IOTA = CurrencyDTO.createCurrency("IOTA", "Iota", null, new String[0]);
    public static final CurrencyDTO YOYO = CurrencyDTO.createCurrency("YOYO", "Yoyow", null, new String[0]);
    public static final CurrencyDTO BTS = CurrencyDTO.createCurrency("BTS", "Bitshare", null, new String[0]);
    public static final CurrencyDTO ICX = CurrencyDTO.createCurrency("ICX", "Icon", null, new String[0]);
    public static final CurrencyDTO MCO = CurrencyDTO.createCurrency("MCO", "Monaco", null, new String[0]);
    public static final CurrencyDTO CND = CurrencyDTO.createCurrency("CND", "Cindicator", null, new String[0]);
    public static final CurrencyDTO XVG = CurrencyDTO.createCurrency("XVG", "Verge", null, new String[0]);
    public static final CurrencyDTO POE = CurrencyDTO.createCurrency("POE", "Po.et", null, new String[0]);
    public static final CurrencyDTO TRX = CurrencyDTO.createCurrency("TRX", "Tron", null, new String[0]);
    public static final CurrencyDTO ADA = CurrencyDTO.createCurrency("ADA", "Cardano", null, new String[0]);
    public static final CurrencyDTO FUN = CurrencyDTO.createCurrency("FUN", "FunFair", null, new String[0]);
    public static final CurrencyDTO HSR = CurrencyDTO.createCurrency("HSR", "Hshare", null, new String[0]);
    public static final CurrencyDTO LEND = CurrencyDTO.createCurrency("LEND", "ETHLend", null, new String[0]);
    public static final CurrencyDTO ELF = CurrencyDTO.createCurrency("ELF", "aelf", null, new String[0]);
    public static final CurrencyDTO STORJ = CurrencyDTO.createCurrency("STORJ", "Storj", null, new String[0]);
    public static final CurrencyDTO MOD = CurrencyDTO.createCurrency("MOD", "Modum", null, new String[0]);
    private final String code;
    private final CurrencyAttributes attributes;

    public CurrencyDTO(String newCode) {
        this.code = newCode;
        this.attributes = CurrencyDTO.getInstance((String)newCode).attributes;
    }

    public CurrencyDTO(Builder builder) {
        this.code = builder.code;
        this.attributes = CurrencyDTO.getInstance((String)builder.code).attributes;
    }

    protected CurrencyDTO() {
        this.code = null;
        this.attributes = null;
    }

    private CurrencyDTO(String newAlternativeCode, CurrencyAttributes newAttributes) {
        this.code = newAlternativeCode;
        this.attributes = newAttributes;
    }

    public static SortedSet<CurrencyDTO> getAvailableCurrencies() {
        return new TreeSet<CurrencyDTO>(CURRENCIES.values());
    }

    public static SortedSet<String> getAvailableCurrencyCodes() {
        return new TreeSet<String>(CURRENCIES.keySet());
    }

    public static CurrencyDTO getInstance(String currencyCode) {
        CurrencyDTO currency = CurrencyDTO.getInstanceNoCreate(currencyCode.toUpperCase());
        return Objects.requireNonNullElseGet(currency, () -> CurrencyDTO.createCurrency(currencyCode.toUpperCase(), null, null, new String[0]));
    }

    public static CurrencyDTO getInstanceNoCreate(String currencyCode) {
        return CURRENCIES.get(currencyCode.toUpperCase());
    }

    private static CurrencyDTO createCurrency(String commonCode, String name, String unicode, String ... alternativeCodes) {
        CurrencyAttributes attributes = new CurrencyAttributes(commonCode, name, unicode, alternativeCodes);
        CurrencyDTO currency = new CurrencyDTO(commonCode, attributes);
        for (String code : attributes.codes) {
            if (commonCode.equals(code)) {
                CURRENCIES.put(code, currency);
                continue;
            }
            if (CURRENCIES.containsKey(code)) continue;
            CURRENCIES.put(code, new CurrencyDTO(code, attributes));
        }
        return currency;
    }

    public String getCurrencyCode() {
        return this.code;
    }

    public CurrencyDTO getCodeCurrency(String newCode) {
        if (newCode.equals(this.code)) {
            return this;
        }
        CurrencyDTO currency = CurrencyDTO.getInstance(newCode);
        if (currency.equals(this)) {
            return currency;
        }
        if (!this.attributes.codes.contains(newCode)) {
            throw new IllegalArgumentException("Code not listed for this currency");
        }
        return new CurrencyDTO(newCode, this.attributes);
    }

    public CurrencyDTO getIso4217Currency() {
        if (this.attributes.isoCode == null) {
            return this;
        }
        return this.getCodeCurrency(this.attributes.isoCode);
    }

    public CurrencyDTO getCommonlyUsedCurrency() {
        return this.getCodeCurrency(this.attributes.commonCode);
    }

    public Set<String> getCurrencyCodes() {
        return this.attributes.codes;
    }

    public String getSymbol() {
        return this.attributes.unicode;
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        return this.attributes.name;
    }

    public String toString() {
        return this.code;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurrencyDTO other = (CurrencyDTO)obj;
        return this.attributes.equals(other.attributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String code;

        public Builder code(String newCode) {
            this.code = newCode;
            return this;
        }

        public CurrencyDTO build() {
            return new CurrencyDTO(this);
        }
    }

    private static class CurrencyAttributes {
        private final Set<String> codes;
        private final String isoCode;
        private final String commonCode;
        private final String name;
        private final String unicode;

        CurrencyAttributes(String newCommonCode, String newName, String newUnicode, String ... newAlternativeCodes) {
            if (newAlternativeCodes.length > 0) {
                this.codes = new TreeSet<String>(Arrays.asList(newAlternativeCodes));
                this.codes.add(newCommonCode);
            } else {
                this.codes = Collections.singleton(newCommonCode);
            }
            String possibleIsoProposalCryptoCode = null;
            Currency javaCurrency = null;
            for (String code : this.codes) {
                if (javaCurrency == null) {
                    try {
                        javaCurrency = Currency.getInstance(code);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!code.startsWith("X")) continue;
                possibleIsoProposalCryptoCode = code;
            }
            this.isoCode = javaCurrency != null ? javaCurrency.getCurrencyCode() : possibleIsoProposalCryptoCode;
            this.commonCode = newCommonCode;
            this.name = newName != null ? newName : (javaCurrency != null ? javaCurrency.getDisplayName() : newCommonCode);
            this.unicode = newUnicode != null ? newUnicode : (javaCurrency != null ? javaCurrency.getSymbol() : newCommonCode);
        }

        public int hashCode() {
            return this.commonCode.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CurrencyAttributes other = (CurrencyAttributes)obj;
            if (this.commonCode == null) {
                return other.commonCode == null;
            }
            return this.commonCode.equalsIgnoreCase(other.commonCode);
        }
    }
}

