/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.util;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class CurrencyAmountDTO {
    public static final CurrencyAmountDTO ZERO = CurrencyAmountDTO.builder().value(BigDecimal.ZERO).currency(CurrencyDTO.BTC).build();
    private final BigDecimal value;
    private final CurrencyDTO currency;

    public CurrencyAmountDTO(String newValue, CurrencyDTO newCurrency) {
        if (newValue != null && newCurrency != null) {
            this.value = new BigDecimal(newValue);
            this.currency = newCurrency;
        } else {
            this.value = new BigDecimal(0);
            this.currency = CurrencyDTO.BTC;
        }
    }

    public CurrencyAmountDTO(BigDecimal newValue, CurrencyDTO newCurrency) {
        if (newValue != null && newCurrency != null) {
            this.value = newValue;
            this.currency = newCurrency;
        } else {
            this.value = new BigDecimal(0);
            this.currency = CurrencyDTO.BTC;
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyAmountDTO that = (CurrencyAmountDTO)o;
        return new EqualsBuilder().append(this.value, that.value).append(this.currency, that.currency).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.value).append((Object)this.currency).toHashCode();
    }

    public final String toString() {
        return this.value + " " + this.currency;
    }

    public static CurrencyAmountDTOBuilder builder() {
        return new CurrencyAmountDTOBuilder();
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public CurrencyDTO getCurrency() {
        return this.currency;
    }

    public static class CurrencyAmountDTOBuilder {
        private BigDecimal value;
        private CurrencyDTO currency;

        CurrencyAmountDTOBuilder() {
        }

        public CurrencyAmountDTOBuilder value(BigDecimal value) {
            this.value = value;
            return this;
        }

        public CurrencyAmountDTOBuilder currency(CurrencyDTO currency) {
            this.currency = currency;
            return this;
        }

        public CurrencyAmountDTO build() {
            return new CurrencyAmountDTO(this.value, this.currency);
        }

        public String toString() {
            return "CurrencyAmountDTO.CurrencyAmountDTOBuilder(value=" + this.value + ", currency=" + this.currency + ")";
        }
    }
}

