/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.user;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class UserDTO {
    private final String id;
    private final Map<String, AccountDTO> accounts;
    private final ZonedDateTime timestamp;

    public final ZonedDateTime getTimestamp() {
        return Objects.requireNonNullElseGet(this.timestamp, ZonedDateTime::now);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDTO that = (UserDTO)o;
        return new EqualsBuilder().append(this.id, that.id).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public static UserDTOBuilder builder() {
        return new UserDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, AccountDTO> getAccounts() {
        return this.accounts;
    }

    public String toString() {
        return "UserDTO(id=" + this.getId() + ", accounts=" + this.getAccounts() + ", timestamp=" + this.getTimestamp() + ")";
    }

    private UserDTO(String id, Map<String, AccountDTO> accounts, ZonedDateTime timestamp) {
        this.id = id;
        this.accounts = accounts;
        this.timestamp = timestamp;
    }

    public static class UserDTOBuilder {
        private String id;
        private ArrayList<String> accounts$key;
        private ArrayList<AccountDTO> accounts$value;
        private ZonedDateTime timestamp;

        UserDTOBuilder() {
        }

        public UserDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserDTOBuilder account(String accountKey, AccountDTO accountValue) {
            if (this.accounts$key == null) {
                this.accounts$key = new ArrayList();
                this.accounts$value = new ArrayList();
            }
            this.accounts$key.add(accountKey);
            this.accounts$value.add(accountValue);
            return this;
        }

        public UserDTOBuilder accounts(Map<? extends String, ? extends AccountDTO> accounts) {
            if (accounts == null) {
                throw new NullPointerException("accounts cannot be null");
            }
            if (this.accounts$key == null) {
                this.accounts$key = new ArrayList();
                this.accounts$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends AccountDTO> $lombokEntry : accounts.entrySet()) {
                this.accounts$key.add($lombokEntry.getKey());
                this.accounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UserDTOBuilder clearAccounts() {
            if (this.accounts$key != null) {
                this.accounts$key.clear();
                this.accounts$value.clear();
            }
            return this;
        }

        public UserDTOBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public UserDTO build() {
            Map<String, AccountDTO> accounts;
            switch (this.accounts$key == null ? 0 : this.accounts$key.size()) {
                case 0: {
                    accounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    accounts = Collections.singletonMap(this.accounts$key.get(0), this.accounts$value.get(0));
                    break;
                }
                default: {
                    accounts = new LinkedHashMap(this.accounts$key.size() < 0x40000000 ? 1 + this.accounts$key.size() + (this.accounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.accounts$key.size(); ++$i) {
                        accounts.put(this.accounts$key.get($i), this.accounts$value.get($i));
                    }
                    accounts = Collections.unmodifiableMap(accounts);
                }
            }
            return new UserDTO(this.id, accounts, this.timestamp);
        }

        public String toString() {
            return "UserDTO.UserDTOBuilder(id=" + this.id + ", accounts$key=" + this.accounts$key + ", accounts$value=" + this.accounts$value + ", timestamp=" + this.timestamp + ")";
        }
    }
}

