/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.user.AccountFeatureDTO;
import tech.cassandre.trading.bot.dto.user.BalanceDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class AccountDTO {
    private final String accountId;
    private final String name;
    private final Set<AccountFeatureDTO> features;
    private final Map<CurrencyDTO, BalanceDTO> balances;

    public Optional<BalanceDTO> getBalance(String currencyCode) {
        CurrencyDTO currency = CurrencyDTO.getInstanceNoCreate(currencyCode);
        if (currency == null) {
            return Optional.empty();
        }
        return this.getBalance(CurrencyDTO.getInstanceNoCreate(currencyCode));
    }

    public Optional<BalanceDTO> getBalance(CurrencyDTO currency) {
        return Optional.ofNullable(this.balances.get(currency));
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDTO that = (AccountDTO)o;
        boolean equals = new EqualsBuilder().append(this.accountId, that.accountId).append(this.name, that.name).append(this.balances.size(), that.balances.size()).isEquals();
        if (equals) {
            for (Map.Entry<CurrencyDTO, BalanceDTO> balance : this.balances.entrySet()) {
                Optional<BalanceDTO> balanceValue = that.getBalance(balance.getKey());
                if (balanceValue.isEmpty()) {
                    return false;
                }
                if (balance.getValue().equals(balanceValue.get())) continue;
                return false;
            }
        }
        return equals;
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.accountId).append((Object)this.name).toHashCode();
    }

    public static AccountDTOBuilder builder() {
        return new AccountDTOBuilder();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public Set<AccountFeatureDTO> getFeatures() {
        return this.features;
    }

    public Map<CurrencyDTO, BalanceDTO> getBalances() {
        return this.balances;
    }

    public String toString() {
        return "AccountDTO(accountId=" + this.getAccountId() + ", name=" + this.getName() + ", features=" + this.getFeatures() + ", balances=" + this.getBalances() + ")";
    }

    private AccountDTO(String accountId, String name, Set<AccountFeatureDTO> features, Map<CurrencyDTO, BalanceDTO> balances) {
        this.accountId = accountId;
        this.name = name;
        this.features = features;
        this.balances = balances;
    }

    public static class AccountDTOBuilder {
        private String accountId;
        private String name;
        private ArrayList<AccountFeatureDTO> features;
        private ArrayList<CurrencyDTO> balances$key;
        private ArrayList<BalanceDTO> balances$value;

        AccountDTOBuilder() {
        }

        public AccountDTOBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public AccountDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AccountDTOBuilder feature(AccountFeatureDTO feature) {
            if (this.features == null) {
                this.features = new ArrayList();
            }
            this.features.add(feature);
            return this;
        }

        public AccountDTOBuilder features(Collection<? extends AccountFeatureDTO> features) {
            if (features == null) {
                throw new NullPointerException("features cannot be null");
            }
            if (this.features == null) {
                this.features = new ArrayList();
            }
            this.features.addAll(features);
            return this;
        }

        public AccountDTOBuilder clearFeatures() {
            if (this.features != null) {
                this.features.clear();
            }
            return this;
        }

        public AccountDTOBuilder balance(CurrencyDTO balanceKey, BalanceDTO balanceValue) {
            if (this.balances$key == null) {
                this.balances$key = new ArrayList();
                this.balances$value = new ArrayList();
            }
            this.balances$key.add(balanceKey);
            this.balances$value.add(balanceValue);
            return this;
        }

        public AccountDTOBuilder balances(Map<? extends CurrencyDTO, ? extends BalanceDTO> balances) {
            if (balances == null) {
                throw new NullPointerException("balances cannot be null");
            }
            if (this.balances$key == null) {
                this.balances$key = new ArrayList();
                this.balances$value = new ArrayList();
            }
            for (Map.Entry<? extends CurrencyDTO, ? extends BalanceDTO> $lombokEntry : balances.entrySet()) {
                this.balances$key.add($lombokEntry.getKey());
                this.balances$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AccountDTOBuilder clearBalances() {
            if (this.balances$key != null) {
                this.balances$key.clear();
                this.balances$value.clear();
            }
            return this;
        }

        public AccountDTO build() {
            Map<CurrencyDTO, BalanceDTO> balances;
            Set<Object> features;
            switch (this.features == null ? 0 : this.features.size()) {
                case 0: {
                    features = Collections.emptySet();
                    break;
                }
                case 1: {
                    features = Collections.singleton(this.features.get(0));
                    break;
                }
                default: {
                    features = new LinkedHashSet(this.features.size() < 0x40000000 ? 1 + this.features.size() + (this.features.size() - 3) / 3 : Integer.MAX_VALUE);
                    features.addAll(this.features);
                    features = Collections.unmodifiableSet(features);
                }
            }
            switch (this.balances$key == null ? 0 : this.balances$key.size()) {
                case 0: {
                    balances = Collections.emptyMap();
                    break;
                }
                case 1: {
                    balances = Collections.singletonMap(this.balances$key.get(0), this.balances$value.get(0));
                    break;
                }
                default: {
                    balances = new LinkedHashMap(this.balances$key.size() < 0x40000000 ? 1 + this.balances$key.size() + (this.balances$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.balances$key.size(); ++$i) {
                        balances.put(this.balances$key.get($i), this.balances$value.get($i));
                    }
                    balances = Collections.unmodifiableMap(balances);
                }
            }
            return new AccountDTO(this.accountId, this.name, features, balances);
        }

        public String toString() {
            return "AccountDTO.AccountDTOBuilder(accountId=" + this.accountId + ", name=" + this.name + ", features=" + this.features + ", balances$key=" + this.balances$key + ", balances$value=" + this.balances$value + ")";
        }
    }
}

