/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.trade;

import java.time.ZonedDateTime;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.dto.trade.OrderTypeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class TradeDTO {
    private final Long id;
    private final String tradeId;
    private final OrderTypeDTO type;
    private final String orderId;
    private final Order order;
    private final CurrencyPairDTO currencyPair;
    private final CurrencyAmountDTO amount;
    private final CurrencyAmountDTO price;
    private final CurrencyAmountDTO fee;
    private final String userReference;
    private final ZonedDateTime timestamp;

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeDTO that = (TradeDTO)o;
        return new EqualsBuilder().append(this.tradeId, that.tradeId).append((Object)this.type, (Object)that.type).append(this.orderId, that.orderId).append(this.currencyPair, that.currencyPair).append(this.amount, that.amount).append(this.price, that.price).append(this.fee, that.fee).append(this.userReference, that.userReference).append(this.timestamp, that.timestamp).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.tradeId).toHashCode();
    }

    public static TradeDTOBuilder builder() {
        return new TradeDTOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public OrderTypeDTO getType() {
        return this.type;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Order getOrder() {
        return this.order;
    }

    public CurrencyPairDTO getCurrencyPair() {
        return this.currencyPair;
    }

    public CurrencyAmountDTO getAmount() {
        return this.amount;
    }

    public CurrencyAmountDTO getPrice() {
        return this.price;
    }

    public CurrencyAmountDTO getFee() {
        return this.fee;
    }

    public String getUserReference() {
        return this.userReference;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "TradeDTO(id=" + this.getId() + ", tradeId=" + this.getTradeId() + ", type=" + this.getType() + ", orderId=" + this.getOrderId() + ", order=" + this.getOrder() + ", currencyPair=" + this.getCurrencyPair() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ", fee=" + this.getFee() + ", userReference=" + this.getUserReference() + ", timestamp=" + this.getTimestamp() + ")";
    }

    private TradeDTO(Long id, String tradeId, OrderTypeDTO type, String orderId, Order order, CurrencyPairDTO currencyPair, CurrencyAmountDTO amount, CurrencyAmountDTO price, CurrencyAmountDTO fee, String userReference, ZonedDateTime timestamp) {
        this.id = id;
        this.tradeId = tradeId;
        this.type = type;
        this.orderId = orderId;
        this.order = order;
        this.currencyPair = currencyPair;
        this.amount = amount;
        this.price = price;
        this.fee = fee;
        this.userReference = userReference;
        this.timestamp = timestamp;
    }

    public static class TradeDTOBuilder {
        private Long id;
        private String tradeId;
        private OrderTypeDTO type;
        private String orderId;
        private Order order;
        private CurrencyPairDTO currencyPair;
        private CurrencyAmountDTO amount;
        private CurrencyAmountDTO price;
        private CurrencyAmountDTO fee;
        private String userReference;
        private ZonedDateTime timestamp;

        TradeDTOBuilder() {
        }

        public TradeDTOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TradeDTOBuilder tradeId(String tradeId) {
            this.tradeId = tradeId;
            return this;
        }

        public TradeDTOBuilder type(OrderTypeDTO type) {
            this.type = type;
            return this;
        }

        public TradeDTOBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public TradeDTOBuilder order(Order order) {
            this.order = order;
            return this;
        }

        public TradeDTOBuilder currencyPair(CurrencyPairDTO currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public TradeDTOBuilder amount(CurrencyAmountDTO amount) {
            this.amount = amount;
            return this;
        }

        public TradeDTOBuilder price(CurrencyAmountDTO price) {
            this.price = price;
            return this;
        }

        public TradeDTOBuilder fee(CurrencyAmountDTO fee) {
            this.fee = fee;
            return this;
        }

        public TradeDTOBuilder userReference(String userReference) {
            this.userReference = userReference;
            return this;
        }

        public TradeDTOBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TradeDTO build() {
            return new TradeDTO(this.id, this.tradeId, this.type, this.orderId, this.order, this.currencyPair, this.amount, this.price, this.fee, this.userReference, this.timestamp);
        }

        public String toString() {
            return "TradeDTO.TradeDTOBuilder(id=" + this.id + ", tradeId=" + this.tradeId + ", type=" + this.type + ", orderId=" + this.orderId + ", order=" + this.order + ", currencyPair=" + this.currencyPair + ", amount=" + this.amount + ", price=" + this.price + ", fee=" + this.fee + ", userReference=" + this.userReference + ", timestamp=" + this.timestamp + ")";
        }
    }
}

