/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.trade;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderStatusDTO;
import tech.cassandre.trading.bot.dto.trade.OrderTypeDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class OrderDTO {
    private final Long id;
    private final String orderId;
    private final OrderTypeDTO type;
    private final StrategyDTO strategy;
    private final CurrencyPairDTO currencyPair;
    private final CurrencyAmountDTO amount;
    private final CurrencyAmountDTO averagePrice;
    private final CurrencyAmountDTO limitPrice;
    private final String leverage;
    private final OrderStatusDTO status;
    private final CurrencyAmountDTO cumulativeAmount;
    private final String userReference;
    private final ZonedDateTime timestamp;
    private final Set<TradeDTO> trades;

    public final Optional<TradeDTO> getTrade(String tradeId) {
        if (tradeId == null) {
            return Optional.empty();
        }
        return this.trades.stream().filter(t -> tradeId.equals(t.getTradeId())).findFirst();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderDTO that = (OrderDTO)o;
        return new EqualsBuilder().append(this.orderId, that.orderId).append((Object)this.type, (Object)that.type).append(this.currencyPair, that.currencyPair).append(this.amount, that.amount).append(this.averagePrice, that.averagePrice).append(this.limitPrice, that.limitPrice).append(this.leverage, that.leverage).append((Object)this.status, (Object)that.status).append(this.cumulativeAmount, that.cumulativeAmount).append(this.userReference, that.userReference).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.orderId).toHashCode();
    }

    public static OrderDTOBuilder builder() {
        return new OrderDTOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public OrderTypeDTO getType() {
        return this.type;
    }

    public StrategyDTO getStrategy() {
        return this.strategy;
    }

    public CurrencyPairDTO getCurrencyPair() {
        return this.currencyPair;
    }

    public CurrencyAmountDTO getAmount() {
        return this.amount;
    }

    public CurrencyAmountDTO getAveragePrice() {
        return this.averagePrice;
    }

    public CurrencyAmountDTO getLimitPrice() {
        return this.limitPrice;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public OrderStatusDTO getStatus() {
        return this.status;
    }

    public CurrencyAmountDTO getCumulativeAmount() {
        return this.cumulativeAmount;
    }

    public String getUserReference() {
        return this.userReference;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public Set<TradeDTO> getTrades() {
        return this.trades;
    }

    public String toString() {
        return "OrderDTO(id=" + this.getId() + ", orderId=" + this.getOrderId() + ", type=" + this.getType() + ", strategy=" + this.getStrategy() + ", currencyPair=" + this.getCurrencyPair() + ", amount=" + this.getAmount() + ", averagePrice=" + this.getAveragePrice() + ", limitPrice=" + this.getLimitPrice() + ", leverage=" + this.getLeverage() + ", status=" + this.getStatus() + ", cumulativeAmount=" + this.getCumulativeAmount() + ", userReference=" + this.getUserReference() + ", timestamp=" + this.getTimestamp() + ", trades=" + this.getTrades() + ")";
    }

    private OrderDTO(Long id, String orderId, OrderTypeDTO type, StrategyDTO strategy, CurrencyPairDTO currencyPair, CurrencyAmountDTO amount, CurrencyAmountDTO averagePrice, CurrencyAmountDTO limitPrice, String leverage, OrderStatusDTO status, CurrencyAmountDTO cumulativeAmount, String userReference, ZonedDateTime timestamp, Set<TradeDTO> trades) {
        this.id = id;
        this.orderId = orderId;
        this.type = type;
        this.strategy = strategy;
        this.currencyPair = currencyPair;
        this.amount = amount;
        this.averagePrice = averagePrice;
        this.limitPrice = limitPrice;
        this.leverage = leverage;
        this.status = status;
        this.cumulativeAmount = cumulativeAmount;
        this.userReference = userReference;
        this.timestamp = timestamp;
        this.trades = trades;
    }

    public static class OrderDTOBuilder {
        private Long id;
        private String orderId;
        private OrderTypeDTO type;
        private StrategyDTO strategy;
        private CurrencyPairDTO currencyPair;
        private CurrencyAmountDTO amount;
        private CurrencyAmountDTO averagePrice;
        private CurrencyAmountDTO limitPrice;
        private String leverage;
        private OrderStatusDTO status;
        private CurrencyAmountDTO cumulativeAmount;
        private String userReference;
        private ZonedDateTime timestamp;
        private ArrayList<TradeDTO> trades;

        OrderDTOBuilder() {
        }

        public OrderDTOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public OrderDTOBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public OrderDTOBuilder type(OrderTypeDTO type) {
            this.type = type;
            return this;
        }

        public OrderDTOBuilder strategy(StrategyDTO strategy) {
            this.strategy = strategy;
            return this;
        }

        public OrderDTOBuilder currencyPair(CurrencyPairDTO currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public OrderDTOBuilder amount(CurrencyAmountDTO amount) {
            this.amount = amount;
            return this;
        }

        public OrderDTOBuilder averagePrice(CurrencyAmountDTO averagePrice) {
            this.averagePrice = averagePrice;
            return this;
        }

        public OrderDTOBuilder limitPrice(CurrencyAmountDTO limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public OrderDTOBuilder leverage(String leverage) {
            this.leverage = leverage;
            return this;
        }

        public OrderDTOBuilder status(OrderStatusDTO status) {
            this.status = status;
            return this;
        }

        public OrderDTOBuilder cumulativeAmount(CurrencyAmountDTO cumulativeAmount) {
            this.cumulativeAmount = cumulativeAmount;
            return this;
        }

        public OrderDTOBuilder userReference(String userReference) {
            this.userReference = userReference;
            return this;
        }

        public OrderDTOBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public OrderDTOBuilder trade(TradeDTO trade) {
            if (this.trades == null) {
                this.trades = new ArrayList();
            }
            this.trades.add(trade);
            return this;
        }

        public OrderDTOBuilder trades(Collection<? extends TradeDTO> trades) {
            if (trades == null) {
                throw new NullPointerException("trades cannot be null");
            }
            if (this.trades == null) {
                this.trades = new ArrayList();
            }
            this.trades.addAll(trades);
            return this;
        }

        public OrderDTOBuilder clearTrades() {
            if (this.trades != null) {
                this.trades.clear();
            }
            return this;
        }

        public OrderDTO build() {
            Set<Object> trades;
            switch (this.trades == null ? 0 : this.trades.size()) {
                case 0: {
                    trades = Collections.emptySet();
                    break;
                }
                case 1: {
                    trades = Collections.singleton(this.trades.get(0));
                    break;
                }
                default: {
                    trades = new LinkedHashSet(this.trades.size() < 0x40000000 ? 1 + this.trades.size() + (this.trades.size() - 3) / 3 : Integer.MAX_VALUE);
                    trades.addAll(this.trades);
                    trades = Collections.unmodifiableSet(trades);
                }
            }
            return new OrderDTO(this.id, this.orderId, this.type, this.strategy, this.currencyPair, this.amount, this.averagePrice, this.limitPrice, this.leverage, this.status, this.cumulativeAmount, this.userReference, this.timestamp, trades);
        }

        public String toString() {
            return "OrderDTO.OrderDTOBuilder(id=" + this.id + ", orderId=" + this.orderId + ", type=" + this.type + ", strategy=" + this.strategy + ", currencyPair=" + this.currencyPair + ", amount=" + this.amount + ", averagePrice=" + this.averagePrice + ", limitPrice=" + this.limitPrice + ", leverage=" + this.leverage + ", status=" + this.status + ", cumulativeAmount=" + this.cumulativeAmount + ", userReference=" + this.userReference + ", timestamp=" + this.timestamp + ", trades=" + this.trades + ")";
        }
    }
}

