/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.trade;

import tech.cassandre.trading.bot.dto.trade.OrderDTO;

public final class OrderCreationResultDTO {
    private final String orderId;
    private OrderDTO order;
    private final String errorMessage;
    private final Exception exception;
    private final boolean successful;

    public OrderCreationResultDTO(OrderDTO newOrder) {
        this.successful = true;
        this.orderId = newOrder.getOrderId();
        this.order = newOrder;
        this.errorMessage = null;
        this.exception = null;
    }

    public OrderCreationResultDTO(String newErrorMessage, Exception newException) {
        this.successful = false;
        this.orderId = null;
        this.errorMessage = newErrorMessage;
        this.exception = newException;
    }

    public String toString() {
        if (this.successful) {
            return "OrderCreationResultDTO{ order='" + this.order + "'}";
        }
        return "OrderCreationResultDTO{ errorMessage='" + this.errorMessage + "', exception=" + this.exception + "}";
    }

    public String getOrderId() {
        return this.orderId;
    }

    public OrderDTO getOrder() {
        return this.order;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

