/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.strategy;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.strategy.StrategyTypeDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class StrategyDTO {
    private final Long id;
    private final String strategyId;
    private final StrategyTypeDTO type;
    private final String name;
    private final AtomicLong lastPositionIdUsed = new AtomicLong();

    public void initializeLastPositionIdUsed(Long value) {
        this.lastPositionIdUsed.set(value);
    }

    public long getNextPositionId() {
        return this.lastPositionIdUsed.incrementAndGet();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrategyDTO that = (StrategyDTO)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.strategyId, that.strategyId).append((Object)this.type, (Object)that.type).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.strategyId).toHashCode();
    }

    public static StrategyDTOBuilder builder() {
        return new StrategyDTOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public StrategyTypeDTO getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public AtomicLong getLastPositionIdUsed() {
        return this.lastPositionIdUsed;
    }

    public String toString() {
        return "StrategyDTO(id=" + this.getId() + ", strategyId=" + this.getStrategyId() + ", type=" + this.getType() + ", name=" + this.getName() + ", lastPositionIdUsed=" + this.getLastPositionIdUsed() + ")";
    }

    private StrategyDTO(Long id, String strategyId, StrategyTypeDTO type, String name) {
        this.id = id;
        this.strategyId = strategyId;
        this.type = type;
        this.name = name;
    }

    public static class StrategyDTOBuilder {
        private Long id;
        private String strategyId;
        private StrategyTypeDTO type;
        private String name;

        StrategyDTOBuilder() {
        }

        public StrategyDTOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StrategyDTOBuilder strategyId(String strategyId) {
            this.strategyId = strategyId;
            return this;
        }

        public StrategyDTOBuilder type(StrategyTypeDTO type) {
            this.type = type;
            return this;
        }

        public StrategyDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StrategyDTO build() {
            return new StrategyDTO(this.id, this.strategyId, this.type, this.name);
        }

        public String toString() {
            return "StrategyDTO.StrategyDTOBuilder(id=" + this.id + ", strategyId=" + this.strategyId + ", type=" + this.type + ", name=" + this.name + ")";
        }
    }
}

