/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.position;

import java.text.DecimalFormat;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public class PositionRulesDTO {
    private final boolean stopGainPercentageSet;
    private final Float stopGainPercentage;
    private final boolean stopLossPercentageSet;
    private final Float stopLossPercentage;

    protected PositionRulesDTO(Builder builder) {
        this.stopGainPercentageSet = builder.stopGainPercentageSet;
        this.stopGainPercentage = builder.stopGainPercentage;
        this.stopLossPercentageSet = builder.stopLossPercentageSet;
        this.stopLossPercentage = builder.stopLossPercentage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionRulesDTO that = (PositionRulesDTO)o;
        return new EqualsBuilder().append(this.stopGainPercentageSet, that.stopGainPercentageSet).append(this.stopLossPercentageSet, that.stopGainPercentageSet).append(this.stopGainPercentage, that.stopGainPercentage).append(this.stopLossPercentage, that.stopLossPercentage).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.stopGainPercentageSet).append(this.stopLossPercentageSet).append((Object)this.stopGainPercentage).append((Object)this.stopLossPercentage).toHashCode();
    }

    public final String toString() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        if (this.isStopGainPercentageSet() && this.isStopLossPercentageSet()) {
            return "Stop gain at " + df.format(this.getStopGainPercentage()) + " % / Stop loss at " + df.format(this.getStopLossPercentage()) + " %";
        }
        if (this.isStopGainPercentageSet()) {
            return "Stop gain at " + df.format(this.getStopGainPercentage()) + " %";
        }
        if (this.isStopLossPercentageSet()) {
            return "Stop loss at " + df.format(this.getStopLossPercentage()) + " %";
        }
        return "No rules";
    }

    public boolean isStopGainPercentageSet() {
        return this.stopGainPercentageSet;
    }

    public Float getStopGainPercentage() {
        return this.stopGainPercentage;
    }

    public boolean isStopLossPercentageSet() {
        return this.stopLossPercentageSet;
    }

    public Float getStopLossPercentage() {
        return this.stopLossPercentage;
    }

    public static final class Builder {
        private boolean stopGainPercentageSet = false;
        private Float stopGainPercentage;
        private boolean stopLossPercentageSet = false;
        private Float stopLossPercentage;

        public Builder stopGainPercentage(Float newStopGainPercentage) {
            this.stopGainPercentageSet = true;
            this.stopGainPercentage = newStopGainPercentage;
            return this;
        }

        public Builder stopLossPercentage(Float newStopLossPercentage) {
            this.stopLossPercentageSet = true;
            this.stopLossPercentage = newStopLossPercentage;
            return this;
        }

        public PositionRulesDTO build() {
            return new PositionRulesDTO(this);
        }
    }
}

