/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.position;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.position.PositionRulesDTO;
import tech.cassandre.trading.bot.dto.position.PositionStatusDTO;
import tech.cassandre.trading.bot.dto.position.PositionTypeDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.dto.util.GainDTO;
import tech.cassandre.trading.bot.util.exception.PositionException;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public class PositionDTO {
    private final long id;
    private final Long positionId;
    private final PositionTypeDTO type;
    private final StrategyDTO strategy;
    private final CurrencyPairDTO currencyPair;
    private final CurrencyAmountDTO amount;
    private final PositionRulesDTO rules;
    private PositionStatusDTO status;
    private boolean forceClosing;
    private final String openingOrderId;
    private OrderDTO openingOrder;
    private String closingOrderId;
    private OrderDTO closingOrder;
    private CurrencyAmountDTO lowestGainPrice;
    private CurrencyAmountDTO highestGainPrice;
    private CurrencyAmountDTO latestGainPrice;
    private static final int ONE_HUNDRED_FLOAT = 100;
    private static final BigDecimal ONE_HUNDRED_BIG_DECIMAL = new BigDecimal("100");
    private static final int BIGINTEGER_SCALE = 8;

    public PositionDTO(long newId, PositionTypeDTO newType, StrategyDTO newStrategy, CurrencyPairDTO newCurrencyPair, BigDecimal newAmount, String newOpenOrderId, PositionRulesDTO newRules) {
        this.id = newId;
        this.type = newType;
        this.positionId = newStrategy.getNextPositionId();
        this.strategy = newStrategy;
        this.currencyPair = newCurrencyPair;
        this.amount = CurrencyAmountDTO.builder().value(newAmount).currency(newCurrencyPair.getBaseCurrency()).build();
        this.openingOrderId = newOpenOrderId;
        this.rules = newRules;
        this.status = PositionStatusDTO.OPENING;
        this.forceClosing = false;
    }

    private Optional<GainDTO> calculateGainFromPrice(BigDecimal price) {
        if (this.status != PositionStatusDTO.OPENING && price != null) {
            if (this.type == PositionTypeDTO.LONG) {
                BigDecimal valueIBought = this.openingOrder.getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal valueICanSell = this.amount.getValue().multiply(price);
                BigDecimal gainPercentage = valueICanSell.subtract(valueIBought).divide(valueIBought, 8, RoundingMode.FLOOR).multiply(ONE_HUNDRED_BIG_DECIMAL);
                return Optional.of(GainDTO.builder().percentage(gainPercentage.floatValue()).amount(CurrencyAmountDTO.builder().value(valueICanSell.subtract(valueIBought)).currency(this.currencyPair.getQuoteCurrency()).build()).fees(CurrencyAmountDTO.builder().value(BigDecimal.ZERO).currency(this.currencyPair.getQuoteCurrency()).build()).build());
            }
            if (this.type == PositionTypeDTO.SHORT) {
                BigDecimal amountGained = this.openingOrder.getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal amountICanBuy = amountGained.divide(price, 8, RoundingMode.FLOOR);
                BigDecimal gainPercentage = amountICanBuy.subtract(this.amount.getValue()).divide(this.amount.getValue(), 8, RoundingMode.FLOOR).multiply(ONE_HUNDRED_BIG_DECIMAL);
                return Optional.of(GainDTO.builder().percentage(gainPercentage.floatValue()).amount(CurrencyAmountDTO.builder().value(amountICanBuy.subtract(this.amount.getValue())).currency(this.currencyPair.getBaseCurrency()).build()).fees(CurrencyAmountDTO.builder().value(BigDecimal.ZERO).currency(this.currencyPair.getBaseCurrency()).build()).build());
            }
        }
        return Optional.empty();
    }

    public final boolean orderUpdate(OrderDTO updatedOrder) {
        if (this.openingOrderId.equals(updatedOrder.getOrderId())) {
            this.openingOrder = updatedOrder;
            if (updatedOrder.getStatus().isInError()) {
                this.status = PositionStatusDTO.OPENING_FAILURE;
            }
            return true;
        }
        if (this.closingOrderId != null && this.closingOrderId.equals(updatedOrder.getOrderId())) {
            this.closingOrder = updatedOrder;
            if (updatedOrder.getStatus().isInError()) {
                this.status = PositionStatusDTO.CLOSING_FAILURE;
            }
            return true;
        }
        return false;
    }

    public boolean tradeUpdate(TradeDTO trade) {
        BigDecimal tradesTotal;
        if (trade.getOrderId().equals(this.openingOrderId) && this.status == PositionStatusDTO.OPENING) {
            tradesTotal = this.openingOrder.getTrades().stream().filter(t -> !t.getTradeId().equals(trade.getTradeId())).map(t -> t.getAmount().getValue()).reduce(trade.getAmount().getValue(), BigDecimal::add);
            if (this.openingOrder.getAmount().getValue().compareTo(tradesTotal) == 0) {
                this.status = PositionStatusDTO.OPENED;
            }
        }
        if (trade.getOrderId().equals(this.closingOrderId) && this.status == PositionStatusDTO.CLOSING) {
            tradesTotal = this.closingOrder.getTrades().stream().filter(t -> !t.getTradeId().equals(trade.getTradeId())).map(t -> t.getAmount().getValue()).reduce(trade.getAmount().getValue(), BigDecimal::add);
            if (this.closingOrder.getAmount().getValue().compareTo(tradesTotal) == 0) {
                this.status = PositionStatusDTO.CLOSED;
            }
        }
        return trade.getOrderId().equals(this.getOpeningOrderId()) || trade.getOrderId().equals(this.getClosingOrderId());
    }

    public final boolean tickerUpdate(TickerDTO ticker) {
        if (this.getClosingOrder() == null && ticker.getCurrencyPair().equals(this.currencyPair)) {
            Optional<GainDTO> calculatedGain = this.calculateGainFromPrice(ticker.getLast());
            Optional<GainDTO> lowestCalculatedGain = this.getLowestCalculatedGain();
            Optional<GainDTO> highestCalculatedGain = this.getHighestCalculatedGain();
            calculatedGain.ifPresent(gain -> {
                CurrencyAmountDTO price;
                this.latestGainPrice = price = CurrencyAmountDTO.builder().value(ticker.getLast()).currency(ticker.getQuoteCurrency()).build();
                if (!this.shouldBeClosed()) {
                    if (lowestCalculatedGain.isEmpty() || ((GainDTO)calculatedGain.get()).isInferiorTo((GainDTO)lowestCalculatedGain.get())) {
                        this.lowestGainPrice = price;
                    }
                    if (highestCalculatedGain.isEmpty() || ((GainDTO)calculatedGain.get()).isSuperiorTo((GainDTO)highestCalculatedGain.get())) {
                        this.highestGainPrice = price;
                    }
                }
            });
            return true;
        }
        return false;
    }

    public CurrencyAmountDTO getAmountToLock() {
        if (this.status == PositionStatusDTO.CLOSED) {
            return CurrencyAmountDTO.ZERO;
        }
        if (this.type == PositionTypeDTO.LONG) {
            if (this.openingOrder != null) {
                BigDecimal amountBought = this.openingOrder.getTrades().stream().map(t -> t.getAmount().getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal amountSold = BigDecimal.ZERO;
                if (this.closingOrder != null) {
                    amountSold = this.closingOrder.getTrades().stream().map(t -> t.getAmount().getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                return new CurrencyAmountDTO(amountBought.subtract(amountSold), this.currencyPair.getBaseCurrency());
            }
        } else if (this.openingOrder != null) {
            BigDecimal amountSold = this.openingOrder.getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal amountBought = BigDecimal.ZERO;
            if (this.closingOrder != null) {
                amountBought = this.closingOrder.getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            return new CurrencyAmountDTO(amountSold.subtract(amountBought), this.currencyPair.getQuoteCurrency());
        }
        return CurrencyAmountDTO.ZERO;
    }

    public final void setForceClosing(boolean newForceClosing) {
        this.forceClosing = newForceClosing;
    }

    public boolean shouldBeClosed() {
        if (this.forceClosing) {
            return true;
        }
        Optional<GainDTO> latestCalculatedGain = this.getLatestCalculatedGain();
        return latestCalculatedGain.filter(gainDTO -> this.rules.isStopGainPercentageSet() && gainDTO.getPercentage() >= (double)this.rules.getStopGainPercentage().floatValue() || this.rules.isStopLossPercentageSet() && gainDTO.getPercentage() <= (double)(-this.rules.getStopLossPercentage().floatValue())).isPresent();
    }

    public final void closePositionWithOrderId(String newCloseOrderId) {
        if (this.status != PositionStatusDTO.OPENED) {
            throw new PositionException("Impossible to set close order id for position " + this.id);
        }
        this.closingOrderId = newCloseOrderId;
        this.status = PositionStatusDTO.CLOSING;
    }

    public final Optional<GainDTO> getLowestCalculatedGain() {
        if (this.lowestGainPrice != null) {
            return this.calculateGainFromPrice(this.lowestGainPrice.getValue());
        }
        return Optional.empty();
    }

    public final Optional<GainDTO> getHighestCalculatedGain() {
        if (this.highestGainPrice != null) {
            return this.calculateGainFromPrice(this.highestGainPrice.getValue());
        }
        return Optional.empty();
    }

    public final Optional<GainDTO> getLatestCalculatedGain() {
        if (this.latestGainPrice != null) {
            return this.calculateGainFromPrice(this.latestGainPrice.getValue());
        }
        return Optional.empty();
    }

    public GainDTO getGain() {
        if (this.status == PositionStatusDTO.CLOSED) {
            if (this.type == PositionTypeDTO.LONG) {
                BigDecimal bought = this.openingOrder.getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sold = this.closingOrder.getTrades().stream().map(t -> t.getAmount().getValue().multiply(t.getPrice().getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal gainAmount = sold.subtract(bought);
                BigDecimal gainPercentage = sold.subtract(bought).divide(bought, RoundingMode.HALF_UP).multiply(ONE_HUNDRED_BIG_DECIMAL);
                BigDecimal fees = Stream.concat(this.openingOrder.getTrades().stream(), this.closingOrder.getTrades().stream()).map(t -> t.getFee().getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                Optional firstTrade = Stream.concat(this.openingOrder.getTrades().stream(), this.closingOrder.getTrades().stream()).findFirst();
                CurrencyDTO feeCurrency = firstTrade.isPresent() ? ((TradeDTO)firstTrade.get()).getFee().getCurrency() : this.currencyPair.getQuoteCurrency();
                return GainDTO.builder().percentage(gainPercentage.setScale(2, RoundingMode.HALF_UP).doubleValue()).amount(CurrencyAmountDTO.builder().value(gainAmount).currency(this.currencyPair.getQuoteCurrency()).build()).fees(CurrencyAmountDTO.builder().value(fees).currency(feeCurrency).build()).build();
            }
            if (this.type == PositionTypeDTO.SHORT) {
                BigDecimal sold = this.openingOrder.getTrades().stream().map(t -> t.getAmount().getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal bought = this.closingOrder.getTrades().stream().map(t -> t.getAmount().getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal gainAmount = bought.subtract(sold);
                BigDecimal gainPercentage = bought.subtract(sold).divide(sold, RoundingMode.HALF_UP).multiply(ONE_HUNDRED_BIG_DECIMAL);
                BigDecimal fees = Stream.concat(this.openingOrder.getTrades().stream(), this.closingOrder.getTrades().stream()).map(t -> t.getFee().getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                Optional firstTrade = Stream.concat(this.openingOrder.getTrades().stream(), this.closingOrder.getTrades().stream()).findFirst();
                CurrencyDTO feeCurrency = firstTrade.isPresent() ? ((TradeDTO)firstTrade.get()).getFee().getCurrency() : this.currencyPair.getQuoteCurrency();
                return GainDTO.builder().percentage(gainPercentage.setScale(2, RoundingMode.HALF_UP).doubleValue()).amount(CurrencyAmountDTO.builder().value(gainAmount).currency(this.currencyPair.getBaseCurrency()).build()).fees(CurrencyAmountDTO.builder().value(fees).currency(feeCurrency).build()).build();
            }
        }
        return GainDTO.ZERO;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionDTO that = (PositionDTO)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.positionId, that.positionId).append((Object)this.type, (Object)that.type).append(this.currencyPair, that.currencyPair).append(this.amount, that.amount).append(this.rules, that.rules).append((Object)this.status, (Object)that.status).append(this.openingOrder, that.openingOrder).append(this.openingOrderId, that.openingOrderId).append(this.closingOrder, that.closingOrder).append(this.closingOrderId, that.closingOrderId).append(this.lowestGainPrice, that.lowestGainPrice).append(this.highestGainPrice, that.highestGainPrice).append(this.latestGainPrice, that.latestGainPrice).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    public final String getDescription() {
        try {
            String value = this.type.toString().toLowerCase(Locale.ROOT) + " position n\u00b0" + this.positionId + " (rules : ";
            if (!this.rules.isStopGainPercentageSet() && !this.rules.isStopLossPercentageSet()) {
                value = value + "no rules";
            }
            if (this.rules.isStopGainPercentageSet() && !this.rules.isStopLossPercentageSet()) {
                value = value + this.rules.getStopGainPercentage() + " % gain";
            }
            if (this.rules.isStopLossPercentageSet() && !this.rules.isStopGainPercentageSet()) {
                value = value + this.rules.getStopLossPercentage() + " % loss";
            }
            if (this.rules.isStopGainPercentageSet() && this.rules.isStopLossPercentageSet()) {
                value = value + this.rules.getStopGainPercentage() + " % gain / ";
                value = value + this.rules.getStopLossPercentage() + " % loss";
            }
            value = value + ")";
            switch (this.status) {
                case OPENING: {
                    value = value + " - Opening - Waiting for the trades of order " + this.openingOrder.getOrderId();
                    break;
                }
                case OPENED: {
                    value = value + " on " + this.getCurrencyPair() + " - Opened";
                    Optional<GainDTO> lastGain = this.getLatestCalculatedGain();
                    if (!lastGain.isPresent() || !this.getLatestCalculatedGain().isPresent()) break;
                    value = value + " - Last gain calculated " + this.getFormattedValue(this.getLatestCalculatedGain().get().getPercentage()) + " %";
                    break;
                }
                case OPENING_FAILURE: {
                    value = "Position " + this.getId() + " - Opening failure";
                    break;
                }
                case CLOSING: {
                    value = value + " on " + this.getCurrencyPair() + " - Closing - Waiting for the trades of order " + this.closingOrder.getOrderId();
                    break;
                }
                case CLOSING_FAILURE: {
                    value = "Position " + this.getId() + " - Closing failure";
                    break;
                }
                case CLOSED: {
                    GainDTO gain = this.getGain();
                    value = value + " on " + this.getCurrencyPair() + " - Closed - Gain : " + this.getFormattedValue(gain.getPercentage()) + " %";
                    break;
                }
                default: {
                    value = "Incorrect state for position " + this.getId();
                }
            }
            return value;
        }
        catch (Exception e) {
            return "Position " + this.getId() + " (error in description generation)";
        }
    }

    private String getFormattedValue(double value) {
        return new DecimalFormat("#0.##").format(value);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public final CurrencyAmountDTO getLowestPrice() {
        return this.lowestGainPrice;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public final CurrencyAmountDTO getHighestPrice() {
        return this.highestGainPrice;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public final CurrencyAmountDTO getLatestPrice() {
        return this.latestGainPrice;
    }

    public static PositionDTOBuilder builder() {
        return new PositionDTOBuilder();
    }

    public long getId() {
        return this.id;
    }

    public Long getPositionId() {
        return this.positionId;
    }

    public PositionTypeDTO getType() {
        return this.type;
    }

    public StrategyDTO getStrategy() {
        return this.strategy;
    }

    public CurrencyPairDTO getCurrencyPair() {
        return this.currencyPair;
    }

    public CurrencyAmountDTO getAmount() {
        return this.amount;
    }

    public PositionRulesDTO getRules() {
        return this.rules;
    }

    public PositionStatusDTO getStatus() {
        return this.status;
    }

    public boolean isForceClosing() {
        return this.forceClosing;
    }

    public String getOpeningOrderId() {
        return this.openingOrderId;
    }

    public OrderDTO getOpeningOrder() {
        return this.openingOrder;
    }

    public String getClosingOrderId() {
        return this.closingOrderId;
    }

    public OrderDTO getClosingOrder() {
        return this.closingOrder;
    }

    public CurrencyAmountDTO getLowestGainPrice() {
        return this.lowestGainPrice;
    }

    public CurrencyAmountDTO getHighestGainPrice() {
        return this.highestGainPrice;
    }

    public CurrencyAmountDTO getLatestGainPrice() {
        return this.latestGainPrice;
    }

    public String toString() {
        return "PositionDTO(id=" + this.getId() + ", positionId=" + this.getPositionId() + ", type=" + this.getType() + ", strategy=" + this.getStrategy() + ", currencyPair=" + this.getCurrencyPair() + ", amount=" + this.getAmount() + ", rules=" + this.getRules() + ", status=" + this.getStatus() + ", forceClosing=" + this.isForceClosing() + ", openingOrderId=" + this.getOpeningOrderId() + ", openingOrder=" + this.getOpeningOrder() + ", closingOrderId=" + this.getClosingOrderId() + ", closingOrder=" + this.getClosingOrder() + ", lowestGainPrice=" + this.getLowestGainPrice() + ", highestGainPrice=" + this.getHighestGainPrice() + ", latestGainPrice=" + this.getLatestGainPrice() + ")";
    }

    private PositionDTO(long id, Long positionId, PositionTypeDTO type, StrategyDTO strategy, CurrencyPairDTO currencyPair, CurrencyAmountDTO amount, PositionRulesDTO rules, PositionStatusDTO status, boolean forceClosing, String openingOrderId, OrderDTO openingOrder, String closingOrderId, OrderDTO closingOrder, CurrencyAmountDTO lowestGainPrice, CurrencyAmountDTO highestGainPrice, CurrencyAmountDTO latestGainPrice) {
        this.id = id;
        this.positionId = positionId;
        this.type = type;
        this.strategy = strategy;
        this.currencyPair = currencyPair;
        this.amount = amount;
        this.rules = rules;
        this.status = status;
        this.forceClosing = forceClosing;
        this.openingOrderId = openingOrderId;
        this.openingOrder = openingOrder;
        this.closingOrderId = closingOrderId;
        this.closingOrder = closingOrder;
        this.lowestGainPrice = lowestGainPrice;
        this.highestGainPrice = highestGainPrice;
        this.latestGainPrice = latestGainPrice;
    }

    public static class PositionDTOBuilder {
        private long id;
        private Long positionId;
        private PositionTypeDTO type;
        private StrategyDTO strategy;
        private CurrencyPairDTO currencyPair;
        private CurrencyAmountDTO amount;
        private PositionRulesDTO rules;
        private PositionStatusDTO status;
        private boolean forceClosing;
        private String openingOrderId;
        private OrderDTO openingOrder;
        private String closingOrderId;
        private OrderDTO closingOrder;
        private CurrencyAmountDTO lowestGainPrice;
        private CurrencyAmountDTO highestGainPrice;
        private CurrencyAmountDTO latestGainPrice;

        PositionDTOBuilder() {
        }

        public PositionDTOBuilder id(long id) {
            this.id = id;
            return this;
        }

        public PositionDTOBuilder positionId(Long positionId) {
            this.positionId = positionId;
            return this;
        }

        public PositionDTOBuilder type(PositionTypeDTO type) {
            this.type = type;
            return this;
        }

        public PositionDTOBuilder strategy(StrategyDTO strategy) {
            this.strategy = strategy;
            return this;
        }

        public PositionDTOBuilder currencyPair(CurrencyPairDTO currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public PositionDTOBuilder amount(CurrencyAmountDTO amount) {
            this.amount = amount;
            return this;
        }

        public PositionDTOBuilder rules(PositionRulesDTO rules) {
            this.rules = rules;
            return this;
        }

        public PositionDTOBuilder status(PositionStatusDTO status) {
            this.status = status;
            return this;
        }

        public PositionDTOBuilder forceClosing(boolean forceClosing) {
            this.forceClosing = forceClosing;
            return this;
        }

        public PositionDTOBuilder openingOrderId(String openingOrderId) {
            this.openingOrderId = openingOrderId;
            return this;
        }

        public PositionDTOBuilder openingOrder(OrderDTO openingOrder) {
            this.openingOrder = openingOrder;
            return this;
        }

        public PositionDTOBuilder closingOrderId(String closingOrderId) {
            this.closingOrderId = closingOrderId;
            return this;
        }

        public PositionDTOBuilder closingOrder(OrderDTO closingOrder) {
            this.closingOrder = closingOrder;
            return this;
        }

        public PositionDTOBuilder lowestGainPrice(CurrencyAmountDTO lowestGainPrice) {
            this.lowestGainPrice = lowestGainPrice;
            return this;
        }

        public PositionDTOBuilder highestGainPrice(CurrencyAmountDTO highestGainPrice) {
            this.highestGainPrice = highestGainPrice;
            return this;
        }

        public PositionDTOBuilder latestGainPrice(CurrencyAmountDTO latestGainPrice) {
            this.latestGainPrice = latestGainPrice;
            return this;
        }

        public PositionDTO build() {
            return new PositionDTO(this.id, this.positionId, this.type, this.strategy, this.currencyPair, this.amount, this.rules, this.status, this.forceClosing, this.openingOrderId, this.openingOrder, this.closingOrderId, this.closingOrder, this.lowestGainPrice, this.highestGainPrice, this.latestGainPrice);
        }

        public String toString() {
            return "PositionDTO.PositionDTOBuilder(id=" + this.id + ", positionId=" + this.positionId + ", type=" + this.type + ", strategy=" + this.strategy + ", currencyPair=" + this.currencyPair + ", amount=" + this.amount + ", rules=" + this.rules + ", status=" + this.status + ", forceClosing=" + this.forceClosing + ", openingOrderId=" + this.openingOrderId + ", openingOrder=" + this.openingOrder + ", closingOrderId=" + this.closingOrderId + ", closingOrder=" + this.closingOrder + ", lowestGainPrice=" + this.lowestGainPrice + ", highestGainPrice=" + this.highestGainPrice + ", latestGainPrice=" + this.latestGainPrice + ")";
        }
    }
}

