/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.position;

import tech.cassandre.trading.bot.dto.position.PositionDTO;

public final class PositionCreationResultDTO {
    private final PositionDTO position;
    private final String errorMessage;
    private final Exception exception;
    private final boolean successful;

    public PositionCreationResultDTO(PositionDTO newPosition) {
        this.successful = true;
        this.position = newPosition;
        this.errorMessage = null;
        this.exception = null;
    }

    public PositionCreationResultDTO(String newErrorMessage, Exception newException) {
        this.successful = false;
        this.position = null;
        this.errorMessage = newErrorMessage;
        this.exception = newException;
    }

    public PositionDTO getPosition() {
        return this.position;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PositionCreationResultDTO)) {
            return false;
        }
        PositionCreationResultDTO other = (PositionCreationResultDTO)o;
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        PositionDTO this$position = this.getPosition();
        PositionDTO other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        PositionDTO $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "PositionCreationResultDTO(position=" + this.getPosition() + ", errorMessage=" + this.getErrorMessage() + ", exception=" + this.getException() + ", successful=" + this.isSuccessful() + ")";
    }
}

