/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.dto.market;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

public final class TickerDTO {
    private final CurrencyPairDTO currencyPair;
    private final BigDecimal open;
    private final BigDecimal last;
    private final BigDecimal bid;
    private final BigDecimal ask;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal vwap;
    private final BigDecimal volume;
    private final BigDecimal quoteVolume;
    private final BigDecimal bidSize;
    private final BigDecimal askSize;
    private final ZonedDateTime timestamp;

    public CurrencyDTO getBaseCurrency() {
        if (this.currencyPair != null) {
            return this.currencyPair.getBaseCurrency();
        }
        return null;
    }

    public CurrencyDTO getQuoteCurrency() {
        if (this.currencyPair != null) {
            return this.currencyPair.getQuoteCurrency();
        }
        return null;
    }

    public final ZonedDateTime getTimestamp() {
        return Objects.requireNonNullElseGet(this.timestamp, ZonedDateTime::now);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TickerDTO that = (TickerDTO)o;
        return new EqualsBuilder().append(this.currencyPair, that.currencyPair).append(this.getTimestamp(), that.getTimestamp()).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.currencyPair).append((Object)this.timestamp).toHashCode();
    }

    public static TickerDTOBuilder builder() {
        return new TickerDTOBuilder();
    }

    public CurrencyPairDTO getCurrencyPair() {
        return this.currencyPair;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVwap() {
        return this.vwap;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getQuoteVolume() {
        return this.quoteVolume;
    }

    public BigDecimal getBidSize() {
        return this.bidSize;
    }

    public BigDecimal getAskSize() {
        return this.askSize;
    }

    public String toString() {
        return "TickerDTO(currencyPair=" + this.getCurrencyPair() + ", open=" + this.getOpen() + ", last=" + this.getLast() + ", bid=" + this.getBid() + ", ask=" + this.getAsk() + ", high=" + this.getHigh() + ", low=" + this.getLow() + ", vwap=" + this.getVwap() + ", volume=" + this.getVolume() + ", quoteVolume=" + this.getQuoteVolume() + ", bidSize=" + this.getBidSize() + ", askSize=" + this.getAskSize() + ", timestamp=" + this.getTimestamp() + ")";
    }

    private TickerDTO(CurrencyPairDTO currencyPair, BigDecimal open, BigDecimal last, BigDecimal bid, BigDecimal ask, BigDecimal high, BigDecimal low, BigDecimal vwap, BigDecimal volume, BigDecimal quoteVolume, BigDecimal bidSize, BigDecimal askSize, ZonedDateTime timestamp) {
        this.currencyPair = currencyPair;
        this.open = open;
        this.last = last;
        this.bid = bid;
        this.ask = ask;
        this.high = high;
        this.low = low;
        this.vwap = vwap;
        this.volume = volume;
        this.quoteVolume = quoteVolume;
        this.bidSize = bidSize;
        this.askSize = askSize;
        this.timestamp = timestamp;
    }

    public static class TickerDTOBuilder {
        private CurrencyPairDTO currencyPair;
        private BigDecimal open;
        private BigDecimal last;
        private BigDecimal bid;
        private BigDecimal ask;
        private BigDecimal high;
        private BigDecimal low;
        private BigDecimal vwap;
        private BigDecimal volume;
        private BigDecimal quoteVolume;
        private BigDecimal bidSize;
        private BigDecimal askSize;
        private ZonedDateTime timestamp;

        TickerDTOBuilder() {
        }

        public TickerDTOBuilder currencyPair(CurrencyPairDTO currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public TickerDTOBuilder open(BigDecimal open) {
            this.open = open;
            return this;
        }

        public TickerDTOBuilder last(BigDecimal last) {
            this.last = last;
            return this;
        }

        public TickerDTOBuilder bid(BigDecimal bid) {
            this.bid = bid;
            return this;
        }

        public TickerDTOBuilder ask(BigDecimal ask) {
            this.ask = ask;
            return this;
        }

        public TickerDTOBuilder high(BigDecimal high) {
            this.high = high;
            return this;
        }

        public TickerDTOBuilder low(BigDecimal low) {
            this.low = low;
            return this;
        }

        public TickerDTOBuilder vwap(BigDecimal vwap) {
            this.vwap = vwap;
            return this;
        }

        public TickerDTOBuilder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        public TickerDTOBuilder quoteVolume(BigDecimal quoteVolume) {
            this.quoteVolume = quoteVolume;
            return this;
        }

        public TickerDTOBuilder bidSize(BigDecimal bidSize) {
            this.bidSize = bidSize;
            return this;
        }

        public TickerDTOBuilder askSize(BigDecimal askSize) {
            this.askSize = askSize;
            return this;
        }

        public TickerDTOBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TickerDTO build() {
            return new TickerDTO(this.currencyPair, this.open, this.last, this.bid, this.ask, this.high, this.low, this.vwap, this.volume, this.quoteVolume, this.bidSize, this.askSize, this.timestamp);
        }

        public String toString() {
            return "TickerDTO.TickerDTOBuilder(currencyPair=" + this.currencyPair + ", open=" + this.open + ", last=" + this.last + ", bid=" + this.bid + ", ask=" + this.ask + ", high=" + this.high + ", low=" + this.low + ", vwap=" + this.vwap + ", volume=" + this.volume + ", quoteVolume=" + this.quoteVolume + ", bidSize=" + this.bidSize + ", askSize=" + this.askSize + ", timestamp=" + this.timestamp + ")";
        }
    }
}

