/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.domain;

import java.time.ZonedDateTime;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.dto.trade.OrderTypeDTO;
import tech.cassandre.trading.bot.util.base.domain.BaseDomain;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;

@Entity
@Table(name="TRADES")
public class Trade
extends BaseDomain {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="TRADE_ID")
    private String tradeId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE")
    private OrderTypeDTO type;
    @ManyToOne
    @JoinColumn(name="FK_ORDER_ID", nullable=false)
    private Order order;
    @Column(name="ORDER_ID")
    private String orderId;
    @Column(name="CURRENCY_PAIR")
    private String currencyPair;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="AMOUNT_VALUE")), @AttributeOverride(name="currency", column=@Column(name="AMOUNT_CURRENCY"))})
    private CurrencyAmount amount;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="PRICE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="PRICE_CURRENCY"))})
    private CurrencyAmount price;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="FEE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="FEE_CURRENCY"))})
    private CurrencyAmount fee;
    @Column(name="USER_REFERENCE")
    private String userReference;
    @Column(name="TIMESTAMP")
    private ZonedDateTime timestamp;

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trade that = (Trade)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.tradeId, that.tradeId).append((Object)this.type, (Object)that.type).append(this.orderId, that.orderId).append(this.currencyPair, that.currencyPair).append(this.amount, that.amount).append(this.price, that.price).append(this.fee, that.fee).append(this.userReference, that.userReference).append(this.timestamp, that.timestamp).isEquals();
    }

    @Override
    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public OrderTypeDTO getType() {
        return this.type;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    public CurrencyAmount getAmount() {
        return this.amount;
    }

    public CurrencyAmount getPrice() {
        return this.price;
    }

    public CurrencyAmount getFee() {
        return this.fee;
    }

    public String getUserReference() {
        return this.userReference;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public void setType(OrderTypeDTO type) {
        this.type = type;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setCurrencyPair(String currencyPair) {
        this.currencyPair = currencyPair;
    }

    public void setAmount(CurrencyAmount amount) {
        this.amount = amount;
    }

    public void setPrice(CurrencyAmount price) {
        this.price = price;
    }

    public void setFee(CurrencyAmount fee) {
        this.fee = fee;
    }

    public void setUserReference(String userReference) {
        this.userReference = userReference;
    }

    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "Trade(id=" + this.getId() + ", tradeId=" + this.getTradeId() + ", type=" + this.getType() + ", order=" + this.getOrder() + ", orderId=" + this.getOrderId() + ", currencyPair=" + this.getCurrencyPair() + ", amount=" + this.getAmount() + ", price=" + this.getPrice() + ", fee=" + this.getFee() + ", userReference=" + this.getUserReference() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

