/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.domain.ExchangeAccount;
import tech.cassandre.trading.bot.dto.strategy.StrategyTypeDTO;
import tech.cassandre.trading.bot.util.base.domain.BaseDomain;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;

@Entity
@Table(name="STRATEGIES")
public class Strategy
extends BaseDomain {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="STRATEGY_ID")
    private String strategyId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE")
    private StrategyTypeDTO type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_EXCHANGE_ACCOUNT_ID", updatable=false)
    private ExchangeAccount exchangeAccount;
    @Column(name="NAME")
    private String name;

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Strategy that = (Strategy)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.strategyId, that.strategyId).append((Object)this.type, (Object)that.type).isEquals();
    }

    @Override
    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public StrategyTypeDTO getType() {
        return this.type;
    }

    public ExchangeAccount getExchangeAccount() {
        return this.exchangeAccount;
    }

    public String getName() {
        return this.name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    public void setType(StrategyTypeDTO type) {
        this.type = type;
    }

    public void setExchangeAccount(ExchangeAccount exchangeAccount) {
        this.exchangeAccount = exchangeAccount;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "Strategy(id=" + this.getId() + ", strategyId=" + this.getStrategyId() + ", type=" + this.getType() + ", exchangeAccount=" + this.getExchangeAccount() + ", name=" + this.getName() + ")";
    }
}

