/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.domain;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.domain.Strategy;
import tech.cassandre.trading.bot.dto.position.PositionStatusDTO;
import tech.cassandre.trading.bot.dto.position.PositionTypeDTO;
import tech.cassandre.trading.bot.util.base.domain.BaseDomain;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;

@Entity
@Table(name="POSITIONS")
public class Position
extends BaseDomain {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="POSITION_ID")
    private Long positionId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE")
    private PositionTypeDTO type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_STRATEGY_ID", updatable=false)
    private Strategy strategy;
    @Column(name="CURRENCY_PAIR")
    private String currencyPair;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="AMOUNT_VALUE")), @AttributeOverride(name="currency", column=@Column(name="AMOUNT_CURRENCY"))})
    private CurrencyAmount amount;
    @Column(name="RULES_STOP_GAIN_PERCENTAGE")
    private Float stopGainPercentageRule;
    @Column(name="RULES_STOP_LOSS_PERCENTAGE")
    private Float stopLossPercentageRule;
    @Enumerated(value=EnumType.STRING)
    @Column(name="STATUS")
    private PositionStatusDTO status;
    @Column(name="FORCE_CLOSING")
    private boolean forceClosing;
    @Column(name="OPENING_ORDER_ID")
    private String openingOrderId;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_OPENING_ORDER_ID")
    private Order openingOrder;
    @Column(name="CLOSING_ORDER_ID")
    private String closingOrderId;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_CLOSING_ORDER_ID")
    private Order closingOrder;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="LOWEST_GAIN_PRICE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="LOWEST_GAIN_PRICE_CURRENCY"))})
    private CurrencyAmount lowestGainPrice;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="HIGHEST_GAIN_PRICE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="HIGHEST_GAIN_PRICE_CURRENCY"))})
    private CurrencyAmount highestGainPrice;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="LATEST_GAIN_PRICE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="LATEST_GAIN_PRICE_CURRENCY"))})
    private CurrencyAmount latestGainPrice;

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position that = (Position)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.positionId, that.positionId).append((Object)this.type, (Object)that.type).append(this.currencyPair, that.currencyPair).append(this.amount, that.amount).append(this.stopGainPercentageRule, that.stopGainPercentageRule).append(this.stopLossPercentageRule, that.stopLossPercentageRule).append((Object)this.status, (Object)that.status).append(this.forceClosing, that.forceClosing).append(this.openingOrderId, that.openingOrderId).append(this.openingOrder, that.openingOrder).append(this.closingOrderId, that.closingOrderId).append(this.closingOrder, that.closingOrder).append(this.lowestGainPrice, that.lowestGainPrice).append(this.highestGainPrice, that.highestGainPrice).append(this.latestGainPrice, that.latestGainPrice).isEquals();
    }

    @Override
    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public Long getId() {
        return this.id;
    }

    public Long getPositionId() {
        return this.positionId;
    }

    public PositionTypeDTO getType() {
        return this.type;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    public CurrencyAmount getAmount() {
        return this.amount;
    }

    public Float getStopGainPercentageRule() {
        return this.stopGainPercentageRule;
    }

    public Float getStopLossPercentageRule() {
        return this.stopLossPercentageRule;
    }

    public PositionStatusDTO getStatus() {
        return this.status;
    }

    public boolean isForceClosing() {
        return this.forceClosing;
    }

    public String getOpeningOrderId() {
        return this.openingOrderId;
    }

    public Order getOpeningOrder() {
        return this.openingOrder;
    }

    public String getClosingOrderId() {
        return this.closingOrderId;
    }

    public Order getClosingOrder() {
        return this.closingOrder;
    }

    public CurrencyAmount getLowestGainPrice() {
        return this.lowestGainPrice;
    }

    public CurrencyAmount getHighestGainPrice() {
        return this.highestGainPrice;
    }

    public CurrencyAmount getLatestGainPrice() {
        return this.latestGainPrice;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public void setType(PositionTypeDTO type) {
        this.type = type;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void setCurrencyPair(String currencyPair) {
        this.currencyPair = currencyPair;
    }

    public void setAmount(CurrencyAmount amount) {
        this.amount = amount;
    }

    public void setStopGainPercentageRule(Float stopGainPercentageRule) {
        this.stopGainPercentageRule = stopGainPercentageRule;
    }

    public void setStopLossPercentageRule(Float stopLossPercentageRule) {
        this.stopLossPercentageRule = stopLossPercentageRule;
    }

    public void setStatus(PositionStatusDTO status) {
        this.status = status;
    }

    public void setForceClosing(boolean forceClosing) {
        this.forceClosing = forceClosing;
    }

    public void setOpeningOrderId(String openingOrderId) {
        this.openingOrderId = openingOrderId;
    }

    public void setOpeningOrder(Order openingOrder) {
        this.openingOrder = openingOrder;
    }

    public void setClosingOrderId(String closingOrderId) {
        this.closingOrderId = closingOrderId;
    }

    public void setClosingOrder(Order closingOrder) {
        this.closingOrder = closingOrder;
    }

    public void setLowestGainPrice(CurrencyAmount lowestGainPrice) {
        this.lowestGainPrice = lowestGainPrice;
    }

    public void setHighestGainPrice(CurrencyAmount highestGainPrice) {
        this.highestGainPrice = highestGainPrice;
    }

    public void setLatestGainPrice(CurrencyAmount latestGainPrice) {
        this.latestGainPrice = latestGainPrice;
    }

    @Override
    public String toString() {
        return "Position(id=" + this.getId() + ", positionId=" + this.getPositionId() + ", type=" + this.getType() + ", strategy=" + this.getStrategy() + ", currencyPair=" + this.getCurrencyPair() + ", amount=" + this.getAmount() + ", stopGainPercentageRule=" + this.getStopGainPercentageRule() + ", stopLossPercentageRule=" + this.getStopLossPercentageRule() + ", status=" + this.getStatus() + ", forceClosing=" + this.isForceClosing() + ", openingOrderId=" + this.getOpeningOrderId() + ", openingOrder=" + this.getOpeningOrder() + ", closingOrderId=" + this.getClosingOrderId() + ", closingOrder=" + this.getClosingOrder() + ", lowestGainPrice=" + this.getLowestGainPrice() + ", highestGainPrice=" + this.getHighestGainPrice() + ", latestGainPrice=" + this.getLatestGainPrice() + ")";
    }
}

