/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.domain;

import java.time.ZonedDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.cassandre.trading.bot.domain.Strategy;
import tech.cassandre.trading.bot.domain.Trade;
import tech.cassandre.trading.bot.dto.trade.OrderStatusDTO;
import tech.cassandre.trading.bot.dto.trade.OrderTypeDTO;
import tech.cassandre.trading.bot.util.base.domain.BaseDomain;
import tech.cassandre.trading.bot.util.java.EqualsBuilder;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;

@Entity
@Table(name="ORDERS")
public class Order
extends BaseDomain {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="ORDER_ID")
    private String orderId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE")
    private OrderTypeDTO type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_STRATEGY_ID", updatable=false)
    private Strategy strategy;
    @Column(name="CURRENCY_PAIR")
    private String currencyPair;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="AMOUNT_VALUE")), @AttributeOverride(name="currency", column=@Column(name="AMOUNT_CURRENCY"))})
    private CurrencyAmount amount;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="AVERAGE_PRICE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="AVERAGE_PRICE_CURRENCY"))})
    private CurrencyAmount averagePrice;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="LIMIT_PRICE_VALUE")), @AttributeOverride(name="currency", column=@Column(name="LIMIT_PRICE_CURRENCY"))})
    private CurrencyAmount limitPrice;
    @Column(name="LEVERAGE")
    private String leverage;
    @Enumerated(value=EnumType.STRING)
    @Column(name="STATUS")
    private OrderStatusDTO status;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="CUMULATIVE_AMOUNT_VALUE")), @AttributeOverride(name="currency", column=@Column(name="CUMULATIVE_AMOUNT_CURRENCY"))})
    private CurrencyAmount cumulativeAmount;
    @Column(name="USER_REFERENCE")
    private String userReference;
    @Column(name="TIMESTAMP")
    private ZonedDateTime timestamp;
    @OneToMany(mappedBy="order", fetch=FetchType.EAGER)
    @OrderBy(value="timestamp")
    private Set<Trade> trades = new LinkedHashSet<Trade>();

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order that = (Order)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.orderId, that.orderId).append((Object)this.type, (Object)that.type).append(this.currencyPair, that.currencyPair).append(this.amount, that.amount).append(this.averagePrice, that.averagePrice).append(this.limitPrice, that.limitPrice).append(this.leverage, that.leverage).append((Object)this.status, (Object)that.status).append(this.cumulativeAmount, that.cumulativeAmount).append(this.userReference, that.userReference).append(this.timestamp, that.timestamp).isEquals();
    }

    @Override
    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public OrderTypeDTO getType() {
        return this.type;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    public CurrencyAmount getAmount() {
        return this.amount;
    }

    public CurrencyAmount getAveragePrice() {
        return this.averagePrice;
    }

    public CurrencyAmount getLimitPrice() {
        return this.limitPrice;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public OrderStatusDTO getStatus() {
        return this.status;
    }

    public CurrencyAmount getCumulativeAmount() {
        return this.cumulativeAmount;
    }

    public String getUserReference() {
        return this.userReference;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public Set<Trade> getTrades() {
        return this.trades;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setType(OrderTypeDTO type) {
        this.type = type;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void setCurrencyPair(String currencyPair) {
        this.currencyPair = currencyPair;
    }

    public void setAmount(CurrencyAmount amount) {
        this.amount = amount;
    }

    public void setAveragePrice(CurrencyAmount averagePrice) {
        this.averagePrice = averagePrice;
    }

    public void setLimitPrice(CurrencyAmount limitPrice) {
        this.limitPrice = limitPrice;
    }

    public void setLeverage(String leverage) {
        this.leverage = leverage;
    }

    public void setStatus(OrderStatusDTO status) {
        this.status = status;
    }

    public void setCumulativeAmount(CurrencyAmount cumulativeAmount) {
        this.cumulativeAmount = cumulativeAmount;
    }

    public void setUserReference(String userReference) {
        this.userReference = userReference;
    }

    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setTrades(Set<Trade> trades) {
        this.trades = trades;
    }

    @Override
    public String toString() {
        return "Order(id=" + this.getId() + ", orderId=" + this.getOrderId() + ", type=" + this.getType() + ", strategy=" + this.getStrategy() + ", currencyPair=" + this.getCurrencyPair() + ", amount=" + this.getAmount() + ", averagePrice=" + this.getAveragePrice() + ", limitPrice=" + this.getLimitPrice() + ", leverage=" + this.getLeverage() + ", status=" + this.getStatus() + ", cumulativeAmount=" + this.getCumulativeAmount() + ", userReference=" + this.getUserReference() + ", timestamp=" + this.getTimestamp() + ", trades=" + this.getTrades() + ")";
    }
}

