/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.ConnectableFlux;
import tech.cassandre.trading.bot.batch.AccountFlux;
import tech.cassandre.trading.bot.batch.OrderFlux;
import tech.cassandre.trading.bot.batch.PositionFlux;
import tech.cassandre.trading.bot.batch.TickerFlux;
import tech.cassandre.trading.bot.batch.TradeFlux;
import tech.cassandre.trading.bot.domain.ExchangeAccount;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.domain.Strategy;
import tech.cassandre.trading.bot.dto.position.PositionStatusDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyDTO;
import tech.cassandre.trading.bot.dto.strategy.StrategyTypeDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.dto.user.UserDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.repository.ExchangeAccountRepository;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.PositionRepository;
import tech.cassandre.trading.bot.repository.StrategyRepository;
import tech.cassandre.trading.bot.repository.TradeRepository;
import tech.cassandre.trading.bot.service.ExchangeService;
import tech.cassandre.trading.bot.service.PositionService;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.service.UserService;
import tech.cassandre.trading.bot.service.dry.TradeServiceDryModeImplementation;
import tech.cassandre.trading.bot.service.dry.UserServiceDryModeImplementation;
import tech.cassandre.trading.bot.service.intern.PositionServiceImplementation;
import tech.cassandre.trading.bot.strategy.BasicCassandreStrategy;
import tech.cassandre.trading.bot.strategy.BasicTa4jCassandreStrategy;
import tech.cassandre.trading.bot.strategy.CassandreStrategy;
import tech.cassandre.trading.bot.strategy.CassandreStrategyInterface;
import tech.cassandre.trading.bot.strategy.GenericCassandreStrategy;
import tech.cassandre.trading.bot.util.base.configuration.BaseConfiguration;
import tech.cassandre.trading.bot.util.exception.ConfigurationException;
import tech.cassandre.trading.bot.util.parameters.ExchangeParameters;

@Configuration
public class StrategiesAutoConfiguration
extends BaseConfiguration {
    private final ApplicationContext applicationContext;
    private final ExchangeParameters exchangeParameters;
    private final TradeService tradeService;
    private PositionService positionService;
    private final UserService userService;
    private final AccountFlux accountFlux;
    private final TickerFlux tickerFlux;
    private final OrderFlux orderFlux;
    private final ExchangeService exchangeService;
    private final ExchangeAccountRepository exchangeAccountRepository;
    private final StrategyRepository strategyRepository;
    private final OrderRepository orderRepository;
    private final TradeRepository tradeRepository;
    private final PositionRepository positionRepository;
    private final TradeFlux tradeFlux;
    private final PositionFlux positionFlux;

    public StrategiesAutoConfiguration(ApplicationContext newApplicationContext, ExchangeService newExchangeService, ExchangeParameters newExchangeParameters, UserService newUserService, TradeService newTradeService, AccountFlux newAccountFlux, TickerFlux newTickerFlux, OrderFlux newOrderFlux, TradeFlux newTradeFlux, ExchangeAccountRepository newExchangeAccountRepository, StrategyRepository newStrategyRepository, OrderRepository newOrderRepository, TradeRepository newTradeRepository, PositionRepository newPositionRepository, PositionFlux newPositionFlux) {
        this.applicationContext = newApplicationContext;
        this.exchangeService = newExchangeService;
        this.exchangeParameters = newExchangeParameters;
        this.userService = newUserService;
        this.tradeService = newTradeService;
        this.accountFlux = newAccountFlux;
        this.tickerFlux = newTickerFlux;
        this.orderFlux = newOrderFlux;
        this.tradeFlux = newTradeFlux;
        this.exchangeAccountRepository = newExchangeAccountRepository;
        this.strategyRepository = newStrategyRepository;
        this.orderRepository = newOrderRepository;
        this.tradeRepository = newTradeRepository;
        this.positionRepository = newPositionRepository;
        this.positionFlux = newPositionFlux;
    }

    @PostConstruct
    public void configure() {
        Map strategies = this.applicationContext.getBeansWithAnnotation(CassandreStrategy.class);
        Optional<UserDTO> user = this.userService.getUser();
        if (user.isEmpty()) {
            throw new ConfigurationException("Impossible to retrieve your user information.", "Impossible to retrieve your user information. Check logs");
        }
        user.get().getAccounts().values().forEach(account -> this.logger.info("StrategyConfiguration - Accounts available : '{}/{}'.", (Object)account.getAccountId(), (Object)account.getName()));
        if (strategies.isEmpty()) {
            throw new ConfigurationException("No strategy found", "You must have one class with @CassandreStrategy.");
        }
        Set strategiesWithErrors = strategies.values().stream().filter(strategy -> !(strategy instanceof CassandreStrategyInterface)).map(strategy -> strategy.getClass().getSimpleName()).collect(Collectors.toSet());
        if (!strategiesWithErrors.isEmpty()) {
            String list = String.join((CharSequence)",", strategiesWithErrors);
            throw new ConfigurationException(list + " doesn't extend BasicCassandreStrategy or BasicTa4jCassandreStrategy.", list + " must extend BasicCassandreStrategy or BasicTa4jCassandreStrategy");
        }
        HashSet<AccountDTO> accountsAvailableOnExchange = new HashSet<AccountDTO>(user.get().getAccounts().values());
        strategiesWithErrors = strategies.values().stream().filter(strategy -> ((CassandreStrategyInterface)strategy).getTradeAccount(accountsAvailableOnExchange).isEmpty()).map(strategy -> strategy.getClass().toString()).collect(Collectors.toSet());
        if (!strategiesWithErrors.isEmpty()) {
            String strategyList = String.join((CharSequence)",", strategiesWithErrors);
            throw new ConfigurationException("Your strategies specifies a trading account that doesn't exist.", "Check your getTradeAccount(Set<AccountDTO> accounts) method as it returns an empty result - Strategies in error : " + strategyList);
        }
        Set strategyIds = strategies.values().stream().map(o -> o.getClass().getAnnotation(CassandreStrategy.class).strategyId()).collect(Collectors.toSet());
        Set duplicatedStrategyId = strategies.values().stream().map(o -> o.getClass().getAnnotation(CassandreStrategy.class).strategyId()).filter(s -> Collections.frequency(strategyIds, s) > 1).collect(Collectors.toSet());
        if (!duplicatedStrategyId.isEmpty()) {
            throw new ConfigurationException("You have duplicated strategy ids", "You have duplicated strategy ids : " + String.join((CharSequence)",", duplicatedStrategyId));
        }
        this.positionService = new PositionServiceImplementation(this.positionRepository, this.tradeService, this.positionFlux);
        ConnectableFlux connectableAccountFlux = this.accountFlux.getFlux().publish();
        ConnectableFlux connectablePositionFlux = this.positionFlux.getFlux().publish();
        ConnectableFlux connectableOrderFlux = this.orderFlux.getFlux().publish();
        LinkedHashSet currencyPairs = strategies.values().stream().map(o -> (CassandreStrategyInterface)o).map(CassandreStrategyInterface::getRequestedCurrencyPairs).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        this.tickerFlux.updateRequestedCurrencyPairs(currencyPairs);
        ConnectableFlux connectableTickerFlux = this.tickerFlux.getFlux().publish();
        ConnectableFlux connectableTradeFlux = this.tradeFlux.getFlux().publish();
        if (this.tradeService instanceof TradeServiceDryModeImplementation) {
            connectableTickerFlux.subscribe(((TradeServiceDryModeImplementation)this.tradeService)::tickerUpdate);
        }
        connectableOrderFlux.subscribe(this.positionService::orderUpdate);
        connectableTradeFlux.subscribe(this.positionService::tradeUpdate);
        strategies.values().forEach(s -> {
            CassandreStrategyInterface strategy = (CassandreStrategyInterface)s;
            CassandreStrategy annotation = s.getClass().getAnnotation(CassandreStrategy.class);
            this.logger.info("StrategyConfiguration - Running strategy '{}/{}' (requires {}).", new Object[]{annotation.strategyId(), annotation.strategyName(), strategy.getRequestedCurrencyPairs().stream().map(CurrencyPairDTO::toString).collect(Collectors.joining(", "))});
            Optional<Strategy> strategyInDatabase = this.strategyRepository.findByStrategyId(annotation.strategyId());
            strategyInDatabase.ifPresentOrElse(existingStrategy -> {
                existingStrategy.setName(annotation.strategyName());
                this.strategyRepository.save(existingStrategy);
                StrategyDTO strategyDTO = this.strategyMapper.mapToStrategyDTO((Strategy)existingStrategy);
                strategyDTO.initializeLastPositionIdUsed(this.positionRepository.getLastPositionIdUsedByStrategy(strategyDTO.getId()));
                strategy.setStrategy(strategyDTO);
                this.logger.debug("StrategyConfiguration - Strategy updated in database {}", existingStrategy);
            }, () -> {
                Strategy newStrategy = new Strategy();
                newStrategy.setStrategyId(annotation.strategyId());
                newStrategy.setName(annotation.strategyName());
                Optional<ExchangeAccount> exchangeAccount = this.exchangeAccountRepository.findByExchangeAndAccount(this.exchangeParameters.getName(), this.exchangeParameters.getUsername());
                exchangeAccount.ifPresent(newStrategy::setExchangeAccount);
                if (strategy instanceof BasicCassandreStrategy) {
                    newStrategy.setType(StrategyTypeDTO.BASIC_STRATEGY);
                }
                if (strategy instanceof BasicTa4jCassandreStrategy) {
                    newStrategy.setType(StrategyTypeDTO.BASIC_TA4J_STRATEGY);
                }
                this.logger.debug("StrategyConfiguration - Strategy saved in database {}", (Object)newStrategy);
                StrategyDTO strategyDTO = this.strategyMapper.mapToStrategyDTO((Strategy)this.strategyRepository.save(newStrategy));
                strategyDTO.initializeLastPositionIdUsed(this.positionRepository.getLastPositionIdUsedByStrategy(strategyDTO.getId()));
                strategy.setStrategy(strategyDTO);
            });
            strategy.setOrderRepository(this.orderRepository);
            strategy.setTradeRepository(this.tradeRepository);
            strategy.setExchangeService(this.exchangeService);
            strategy.setTradeService(this.tradeService);
            strategy.setPositionService(this.positionService);
            strategy.setPositionRepository(this.positionRepository);
            strategy.initializeAccounts(((UserDTO)user.get()).getAccounts());
            connectableAccountFlux.subscribe(strategy::accountUpdate);
            connectablePositionFlux.subscribe(strategy::positionUpdate);
            connectableOrderFlux.subscribe(strategy::orderUpdate);
            connectableTradeFlux.subscribe(strategy::tradeUpdate);
            connectableTickerFlux.subscribe(strategy::tickerUpdate);
            if (this.userService instanceof UserServiceDryModeImplementation) {
                ((UserServiceDryModeImplementation)this.userService).setDependencies((GenericCassandreStrategy)strategy);
            }
        });
        connectableTickerFlux.subscribe(this.positionService::tickerUpdate);
        connectableAccountFlux.connect();
        connectablePositionFlux.connect();
        this.positionRepository.findByStatus(PositionStatusDTO.OPENING).forEach(p -> {
            Optional<Order> order = this.orderRepository.findByOrderId(p.getOpeningOrderId());
            if (order.isPresent()) {
                if (p.getOpeningOrder() == null) {
                    p.setOpeningOrder(order.get());
                    this.positionRepository.save(p);
                }
                order.get().getTrades().stream().map(this.tradeMapper::mapToTradeDTO).forEach(tradeDTO -> this.positionService.tradeUpdate((TradeDTO)tradeDTO));
            }
        });
        this.positionRepository.findByStatus(PositionStatusDTO.CLOSING).forEach(p -> {
            Optional<Order> order = this.orderRepository.findByOrderId(p.getClosingOrderId());
            if (order.isPresent()) {
                if (p.getClosingOrder() == null) {
                    p.setClosingOrder(order.get());
                    this.positionRepository.save(p);
                }
                order.get().getTrades().stream().map(this.tradeMapper::mapToTradeDTO).forEach(tradeDTO -> this.positionService.tradeUpdate((TradeDTO)tradeDTO));
            }
        });
        connectableOrderFlux.connect();
        connectableTradeFlux.connect();
        connectableTickerFlux.connect();
    }

    @Bean
    public PositionService getPositionService() {
        return this.positionService;
    }
}

