/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.configuration;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import tech.cassandre.trading.bot.batch.AccountFlux;
import tech.cassandre.trading.bot.batch.OrderFlux;
import tech.cassandre.trading.bot.batch.TickerFlux;
import tech.cassandre.trading.bot.batch.TradeFlux;
import tech.cassandre.trading.bot.util.base.configuration.BaseConfiguration;

@Configuration
@Profile(value={"!schedule-disabled"})
@EnableScheduling
public class ScheduleAutoConfiguration
extends BaseConfiguration {
    private static final int AWAIT_TERMINATION_SECONDS = 30;
    private static final int SCHEDULER_POOL_SIZE = 3;
    public static final int INITIAL_DELAY = 1000;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AccountFlux accountFlux;
    private final TickerFlux tickerFlux;
    private final OrderFlux orderFlux;
    private final TradeFlux tradeFlux;

    public ScheduleAutoConfiguration(AccountFlux newAccountFlux, TickerFlux newTickerFlux, OrderFlux newOrderFlux, TradeFlux newTradeFlux) {
        this.accountFlux = newAccountFlux;
        this.tickerFlux = newTickerFlux;
        this.orderFlux = newOrderFlux;
        this.tradeFlux = newTradeFlux;
    }

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setAwaitTerminationSeconds(30);
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        scheduler.setPoolSize(3);
        scheduler.setErrorHandler(throwable -> {
            try {
                this.logger.error("ScheduleAutoConfiguration - Error in scheduled tasks : {}", (Object)throwable.getMessage());
            }
            catch (Exception e) {
                this.logger.error("ScheduleAutoConfiguration - Error in scheduled tasks : {}", (Object)throwable.getMessage());
            }
        });
        return scheduler;
    }

    @Scheduled(initialDelay=1000L, fixedDelay=1L)
    public void accountFluxUpdate() {
        if (this.enabled.get()) {
            this.accountFlux.update();
        }
    }

    @Scheduled(initialDelay=1000L, fixedDelay=1L)
    public void tickerFluxUpdate() {
        if (this.enabled.get()) {
            this.tickerFlux.update();
        }
    }

    @Scheduled(initialDelay=1000L, fixedDelay=1L)
    public void tradeFluxUpdate() {
        if (this.enabled.get()) {
            this.orderFlux.update();
            this.tradeFlux.update();
        }
    }

    @PreDestroy
    public void shutdown() {
        this.enabled.set(false);
    }
}

