/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.configuration;

import java.time.Duration;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.math.NumberUtils;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.trade.TradeService;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import si.mazi.rescu.HttpStatusIOException;
import tech.cassandre.trading.bot.batch.AccountFlux;
import tech.cassandre.trading.bot.batch.OrderFlux;
import tech.cassandre.trading.bot.batch.PositionFlux;
import tech.cassandre.trading.bot.batch.TickerFlux;
import tech.cassandre.trading.bot.batch.TradeFlux;
import tech.cassandre.trading.bot.domain.ExchangeAccount;
import tech.cassandre.trading.bot.repository.ExchangeAccountRepository;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.PositionRepository;
import tech.cassandre.trading.bot.repository.TradeRepository;
import tech.cassandre.trading.bot.service.ExchangeService;
import tech.cassandre.trading.bot.service.MarketService;
import tech.cassandre.trading.bot.service.UserService;
import tech.cassandre.trading.bot.service.dry.ExchangeServiceDryModeImplementation;
import tech.cassandre.trading.bot.service.dry.TradeServiceDryModeImplementation;
import tech.cassandre.trading.bot.service.dry.UserServiceDryModeImplementation;
import tech.cassandre.trading.bot.service.xchange.ExchangeServiceXChangeImplementation;
import tech.cassandre.trading.bot.service.xchange.MarketServiceXChangeImplementation;
import tech.cassandre.trading.bot.service.xchange.TradeServiceXChangeImplementation;
import tech.cassandre.trading.bot.service.xchange.UserServiceXChangeImplementation;
import tech.cassandre.trading.bot.util.base.configuration.BaseConfiguration;
import tech.cassandre.trading.bot.util.exception.ConfigurationException;
import tech.cassandre.trading.bot.util.parameters.ExchangeParameters;

@Configuration
@EnableConfigurationProperties(value={ExchangeParameters.class})
public class ExchangeAutoConfiguration
extends BaseConfiguration {
    private static final String USE_SANDBOX_PARAMETER = "Use_Sandbox";
    private static final String PASSPHRASE_PARAMETER = "passphrase";
    public static final int UNAUTHORIZED_STATUS_CODE = 401;
    private final ApplicationContext applicationContext;
    private final ExchangeParameters exchangeParameters;
    private Exchange xChangeExchange;
    private AccountService xChangeAccountService;
    private MarketDataService xChangeMarketDataService;
    private TradeService xChangeTradeService;
    private ExchangeService exchangeService;
    private UserService userService;
    private MarketService marketService;
    private tech.cassandre.trading.bot.service.TradeService tradeService;
    private AccountFlux accountFlux;
    private TickerFlux tickerFlux;
    private OrderFlux orderFlux;
    private TradeFlux tradeFlux;
    private PositionFlux positionFlux;
    private final ExchangeAccountRepository exchangeAccountRepository;
    private final OrderRepository orderRepository;
    private final TradeRepository tradeRepository;
    private final PositionRepository positionRepository;

    public ExchangeAutoConfiguration(ApplicationContext newApplicationContext, ExchangeParameters newExchangeParameters, ExchangeAccountRepository newExchangeAccountRepository, OrderRepository newOrderRepository, TradeRepository newTradeRepository, PositionRepository newPositionRepository) {
        this.applicationContext = newApplicationContext;
        this.exchangeParameters = newExchangeParameters;
        this.exchangeAccountRepository = newExchangeAccountRepository;
        this.orderRepository = newOrderRepository;
        this.tradeRepository = newTradeRepository;
        this.positionRepository = newPositionRepository;
    }

    @PostConstruct
    public void configure() {
        try {
            Optional<ExchangeAccount> exchangeAccount;
            Class<Exchange> exchangeClass = Class.forName(this.getExchangeClassName()).asSubclass(Exchange.class);
            ExchangeSpecification exchangeSpecification = new ExchangeSpecification(exchangeClass);
            exchangeSpecification.setExchangeSpecificParametersItem(USE_SANDBOX_PARAMETER, (Object)this.exchangeParameters.getModes().getSandbox());
            exchangeSpecification.setUserName(this.exchangeParameters.getUsername());
            exchangeSpecification.setExchangeSpecificParametersItem(PASSPHRASE_PARAMETER, (Object)this.exchangeParameters.getPassphrase());
            exchangeSpecification.setApiKey(this.exchangeParameters.getKey());
            exchangeSpecification.setSecretKey(this.exchangeParameters.getSecret());
            if (this.exchangeParameters.getProxyHost() != null) {
                exchangeSpecification.setProxyHost(this.exchangeParameters.getProxyHost());
            }
            if (this.exchangeParameters.getProxyPort() != null) {
                exchangeSpecification.setProxyPort(this.exchangeParameters.getProxyPort());
            }
            if (this.exchangeParameters.getSslUri() != null) {
                exchangeSpecification.setSslUri(this.exchangeParameters.getSslUri());
            }
            if (this.exchangeParameters.getPlainTextUri() != null) {
                exchangeSpecification.setPlainTextUri(this.exchangeParameters.getPlainTextUri());
            }
            if (this.exchangeParameters.getHost() != null) {
                exchangeSpecification.setHost(this.exchangeParameters.getHost());
            }
            if (this.exchangeParameters.getPort() != null) {
                exchangeSpecification.setPort(Integer.parseInt(this.exchangeParameters.getPort()));
            }
            this.xChangeExchange = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
            this.xChangeAccountService = this.xChangeExchange.getAccountService();
            this.xChangeMarketDataService = this.xChangeExchange.getMarketDataService();
            this.xChangeTradeService = this.xChangeExchange.getTradeService();
            long accountRate = ExchangeAutoConfiguration.getRateValue(this.exchangeParameters.getRates().getAccount());
            long tickerRate = ExchangeAutoConfiguration.getRateValue(this.exchangeParameters.getRates().getTicker());
            long tradeRate = ExchangeAutoConfiguration.getRateValue(this.exchangeParameters.getRates().getTrade());
            TradeServiceDryModeImplementation tradeServiceDryMode = null;
            if (!this.exchangeParameters.getModes().getDry().booleanValue()) {
                this.logger.info("ExchangeConfiguration - Dry mode is OFF");
                this.exchangeService = new ExchangeServiceXChangeImplementation(this.xChangeExchange);
                this.userService = new UserServiceXChangeImplementation(accountRate, this.xChangeAccountService);
                this.marketService = new MarketServiceXChangeImplementation(tickerRate, this.xChangeMarketDataService);
                this.tradeService = new TradeServiceXChangeImplementation(tradeRate, this.orderRepository, this.xChangeTradeService);
            } else {
                this.logger.info("ExchangeConfiguration - Dry mode is ON");
                this.exchangeService = new ExchangeServiceDryModeImplementation(this.applicationContext);
                UserServiceDryModeImplementation userServiceDryMode = new UserServiceDryModeImplementation();
                this.userService = userServiceDryMode;
                this.marketService = new MarketServiceXChangeImplementation(tickerRate, this.xChangeMarketDataService);
                tradeServiceDryMode = new TradeServiceDryModeImplementation(userServiceDryMode, this.tradeRepository, this.orderRepository);
                this.tradeService = tradeServiceDryMode;
            }
            this.accountFlux = new AccountFlux(this.userService);
            this.tickerFlux = new TickerFlux(this.marketService);
            this.orderFlux = new OrderFlux(this.tradeService, this.orderRepository);
            this.tradeFlux = new TradeFlux(this.tradeService, this.orderRepository, this.tradeRepository);
            this.positionFlux = new PositionFlux(this.positionRepository, this.orderRepository);
            this.xChangeAccountService.getAccountInfo();
            this.logger.info("ExchangeConfiguration - Connection to {} successful", (Object)this.exchangeParameters.getName());
            StringJoiner currencyPairList = new StringJoiner(", ");
            this.exchangeService.getAvailableCurrencyPairs().forEach(currencyPairDTO -> currencyPairList.add(currencyPairDTO.toString()));
            this.logger.info("ExchangeConfiguration - Supported currency pairs : {} ", (Object)currencyPairList);
            if (this.tradeService instanceof TradeServiceDryModeImplementation) {
                assert (tradeServiceDryMode != null);
                tradeServiceDryMode.setDependencies(this.orderFlux, this.tradeFlux);
            }
            if ((exchangeAccount = this.exchangeAccountRepository.findByExchangeAndAccount(this.exchangeParameters.getName(), this.exchangeParameters.getUsername())).isEmpty()) {
                ExchangeAccount ea = new ExchangeAccount();
                ea.setExchange(this.exchangeParameters.getName());
                ea.setAccount(this.exchangeParameters.getUsername());
                ea = (ExchangeAccount)this.exchangeAccountRepository.save(ea);
                this.logger.info("ExchangeConfiguration - Exchange configuration saved in database {}", (Object)ea);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Impossible to find the exchange you requested : " + this.exchangeParameters.getName(), "Choose a valid exchange (https://github.com/knowm/XChange) and add the dependency to Cassandre");
        }
        catch (HttpStatusIOException e) {
            if (e.getHttpStatusCode() == 401) {
                throw new ConfigurationException("Invalid credentials for " + this.exchangeParameters.getName(), "Check your exchange credentials : " + e.getMessage() + " - login used : " + this.exchangeParameters.getUsername());
            }
            throw new ConfigurationException("Error while connecting to the exchange : " + e.getMessage());
        }
        catch (Exception e) {
            throw new ConfigurationException("Unknown configuration error : " + e.getMessage());
        }
    }

    private String getExchangeClassName() {
        if (this.exchangeParameters.getName() != null && this.exchangeParameters.getName().contains(".")) {
            return this.exchangeParameters.getName();
        }
        String xChangeClassPackage = "org.knowm.xchange.";
        String xChangeCLassSuffix = "Exchange";
        assert (this.exchangeParameters.getName() != null);
        return "org.knowm.xchange.".concat(this.exchangeParameters.getName().toLowerCase()).concat(".").concat(this.exchangeParameters.getName().substring(0, 1).toUpperCase()).concat(this.exchangeParameters.getName().substring(1).toLowerCase()).concat("Exchange");
    }

    private static long getRateValue(String stringValue) {
        if (NumberUtils.isCreatable((String)stringValue)) {
            return Long.parseLong(stringValue);
        }
        return Duration.parse(stringValue).toMillis();
    }

    @Bean
    public Exchange getXChangeExchange() {
        return this.xChangeExchange;
    }

    @Bean
    public AccountService getXChangeAccountService() {
        return this.xChangeAccountService;
    }

    @Bean
    public MarketDataService getXChangeMarketDataService() {
        return this.xChangeMarketDataService;
    }

    @Bean
    public TradeService getXChangeTradeService() {
        return this.xChangeTradeService;
    }

    @Bean
    public ExchangeService getExchangeService() {
        return this.exchangeService;
    }

    @Bean
    public UserService getUserService() {
        return this.userService;
    }

    @Bean
    public MarketService getMarketService() {
        return this.marketService;
    }

    @Bean
    public tech.cassandre.trading.bot.service.TradeService getTradeService() {
        return this.tradeService;
    }

    @Bean
    public AccountFlux getAccountFlux() {
        return this.accountFlux;
    }

    @Bean
    public TickerFlux getTickerFlux() {
        return this.tickerFlux;
    }

    @Bean
    public OrderFlux getOrderFlux() {
        return this.orderFlux;
    }

    @Bean
    public TradeFlux getTradeFlux() {
        return this.tradeFlux;
    }

    @Bean
    public PositionFlux getPositionFlux() {
        return this.positionFlux;
    }
}

