/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.configuration;

import java.time.ZonedDateTime;
import java.util.Optional;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.auditing.DateTimeProvider;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import tech.cassandre.trading.bot.util.base.configuration.BaseConfiguration;
import tech.cassandre.trading.bot.util.parameters.DatabaseParameters;

@Configuration
@EnableJpaAuditing(dateTimeProviderRef="auditingDateTimeProvider")
@EntityScan(basePackages={"tech.cassandre.trading.bot.domain"})
@EnableJpaRepositories(basePackages={"tech.cassandre.trading.bot.repository"})
@EnableConfigurationProperties(value={DatabaseParameters.class})
public class DatabaseAutoConfiguration
extends BaseConfiguration {
    public static final int PRECISION = 16;
    public static final int SCALE = 8;
    private final DatabaseParameters databaseParameters;

    public DatabaseAutoConfiguration(DatabaseParameters newDatabaseParameters) {
        this.databaseParameters = newDatabaseParameters;
    }

    @Bean
    @Primary
    public DataSourceProperties dataSourceProperties() {
        DataSourceProperties p = new DataSourceProperties();
        p.setDriverClassName(this.databaseParameters.getDatasource().getDriverClassName());
        p.setUrl(this.databaseParameters.getDatasource().getUrl());
        p.setUsername(this.databaseParameters.getDatasource().getUsername());
        p.setPassword(this.databaseParameters.getDatasource().getPassword());
        return p;
    }

    @Bean
    public DateTimeProvider auditingDateTimeProvider() {
        return () -> Optional.of(ZonedDateTime.now());
    }
}

