/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.batch;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import tech.cassandre.trading.bot.domain.Trade;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.TradeRepository;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.util.base.batch.BaseExternalFlux;

public class TradeFlux
extends BaseExternalFlux<TradeDTO> {
    private final TradeService tradeService;
    private final OrderRepository orderRepository;
    private final TradeRepository tradeRepository;

    public TradeFlux(TradeService newTradeService, OrderRepository newOrderRepository, TradeRepository newTradeRepository) {
        this.tradeRepository = newTradeRepository;
        this.orderRepository = newOrderRepository;
        this.tradeService = newTradeService;
    }

    @Override
    protected final Set<TradeDTO> getNewValues() {
        this.logger.debug("TradeFlux - Retrieving new values");
        LinkedHashSet<TradeDTO> newValues = new LinkedHashSet<TradeDTO>();
        this.tradeService.getTrades().stream().filter(t -> this.orderRepository.findByOrderId(t.getOrderId()).isPresent()).forEach(trade -> {
            this.logger.debug("TradeFlux - Treating trade : {}", (Object)trade.getTradeId());
            Optional<Trade> tradeInDatabase = this.tradeRepository.findByTradeId(trade.getTradeId());
            if (tradeInDatabase.isEmpty() || !this.tradeMapper.mapToTradeDTO(tradeInDatabase.get()).equals(trade)) {
                this.logger.debug("TradeFlux - Trade {} has changed : {}", (Object)trade.getTradeId(), trade);
                newValues.add((TradeDTO)trade);
            }
        });
        this.logger.debug("TradeFlux - {} trade(s) updated", (Object)newValues.size());
        return newValues;
    }

    @Override
    public final Optional<TradeDTO> saveValue(TradeDTO newValue) {
        AtomicReference valueToSave = new AtomicReference();
        this.tradeRepository.findByTradeId(newValue.getTradeId()).ifPresentOrElse(trade -> {
            this.tradeMapper.updateTrade(newValue, (Trade)trade);
            this.orderRepository.findByOrderId(newValue.getOrderId()).ifPresent(trade::setOrder);
            valueToSave.set(trade);
            this.logger.debug("TradeFlux - Updating trade in database {}", trade);
        }, () -> {
            Trade newTrade = this.tradeMapper.mapToTrade(newValue);
            this.orderRepository.findByOrderId(newValue.getOrderId()).ifPresent(newTrade::setOrder);
            valueToSave.set(newTrade);
            this.logger.debug("TradeFlux - Creating trade in database {}", (Object)newTrade);
        });
        return Optional.ofNullable(this.tradeMapper.mapToTradeDTO((Trade)this.tradeRepository.save((Trade)valueToSave.get())));
    }
}

