/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.batch;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.service.MarketService;
import tech.cassandre.trading.bot.util.base.batch.BaseExternalFlux;

public class TickerFlux
extends BaseExternalFlux<TickerDTO> {
    private final MarketService marketService;
    private final Set<CurrencyPairDTO> currencyPairs = new LinkedHashSet<CurrencyPairDTO>();
    private Iterator<CurrencyPairDTO> currencyPairsIterator;
    private final Map<CurrencyPairDTO, TickerDTO> previousValues = new LinkedHashMap<CurrencyPairDTO, TickerDTO>();

    public TickerFlux(MarketService newMarketService) {
        this.marketService = newMarketService;
    }

    public void updateRequestedCurrencyPairs(Set<CurrencyPairDTO> requestedCurrencyPairs) {
        this.currencyPairs.addAll(requestedCurrencyPairs);
        this.currencyPairsIterator = Iterators.cycle(requestedCurrencyPairs);
    }

    @Override
    protected final Set<TickerDTO> getNewValues() {
        this.logger.debug("TickerFlux - Retrieving new values");
        LinkedHashSet<TickerDTO> newValues = new LinkedHashSet<TickerDTO>();
        try {
            this.marketService.getTickers(this.currencyPairs).forEach(ticker -> {
                if (!ticker.equals(this.previousValues.get(ticker.getCurrencyPair()))) {
                    this.logger.debug("TickerFlux - New ticker received : {}", ticker);
                    this.previousValues.put(ticker.getCurrencyPair(), (TickerDTO)ticker);
                    newValues.add((TickerDTO)ticker);
                }
            });
        }
        catch (NotAvailableFromExchangeException | NotYetImplementedForExchangeException e) {
            this.logger.debug("MarketService - getTickers not available {}", (Object)e.getMessage());
            this.marketService.getTicker(this.currencyPairsIterator.next()).ifPresent(t -> {
                if (!t.equals(this.previousValues.get(t.getCurrencyPair()))) {
                    this.logger.debug("TickerFlux - New ticker received : {}", t);
                    this.previousValues.put(t.getCurrencyPair(), (TickerDTO)t);
                    newValues.add((TickerDTO)t);
                }
            });
        }
        return newValues;
    }

    @Override
    protected final Optional<TickerDTO> saveValue(TickerDTO newValue) {
        return Optional.ofNullable(newValue);
    }
}

