/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.batch;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import tech.cassandre.trading.bot.domain.Position;
import tech.cassandre.trading.bot.dto.position.PositionDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.repository.PositionRepository;
import tech.cassandre.trading.bot.util.base.batch.BaseInternalFlux;

public class PositionFlux
extends BaseInternalFlux<PositionDTO> {
    private final PositionRepository positionRepository;
    private final OrderRepository orderRepository;

    public PositionFlux(PositionRepository newPositionRepository, OrderRepository newOrderRepository) {
        this.positionRepository = newPositionRepository;
        this.orderRepository = newOrderRepository;
    }

    @Override
    public final Optional<PositionDTO> saveValue(PositionDTO newValue) {
        AtomicReference valueToSave = new AtomicReference();
        this.positionRepository.findById(newValue.getId()).ifPresentOrElse(position -> {
            this.positionMapper.updatePosition(newValue, (Position)position);
            if (newValue.getOpeningOrder() == null && newValue.getOpeningOrderId() != null) {
                this.orderRepository.findByOrderId(newValue.getOpeningOrderId()).ifPresent(position::setOpeningOrder);
            }
            if (newValue.getClosingOrder() == null && newValue.getClosingOrderId() != null) {
                this.orderRepository.findByOrderId(newValue.getClosingOrderId()).ifPresent(position::setClosingOrder);
            }
            valueToSave.set(position);
            this.logger.debug("PositionFlux - Updating position in database {}", position);
        }, () -> this.logger.error("PositionFlux - Position {} was not found in database", (Object)newValue));
        return Optional.ofNullable(this.positionMapper.mapToPositionDTO((Position)this.positionRepository.save((Position)valueToSave.get())));
    }
}

