/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.batch;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.repository.OrderRepository;
import tech.cassandre.trading.bot.service.TradeService;
import tech.cassandre.trading.bot.util.base.batch.BaseExternalFlux;

public class OrderFlux
extends BaseExternalFlux<OrderDTO> {
    private final TradeService tradeService;
    private final OrderRepository orderRepository;

    public OrderFlux(TradeService newTradeService, OrderRepository newOrderRepository) {
        this.tradeService = newTradeService;
        this.orderRepository = newOrderRepository;
    }

    @Override
    protected final Set<OrderDTO> getNewValues() {
        this.logger.debug("OrderFlux - Retrieving new values");
        LinkedHashSet<OrderDTO> newValues = new LinkedHashSet<OrderDTO>();
        this.tradeService.getOrders().forEach(order -> {
            this.logger.debug("OrderFlux - Treating order : {}", (Object)order.getOrderId());
            Optional<Order> orderInDatabase = this.orderRepository.findByOrderId(order.getOrderId());
            if (orderInDatabase.isEmpty() && order.getStrategy() != null) {
                this.logger.debug("OrderFlux - Local order {} saved : {}", (Object)order.getOrderId(), order);
                newValues.add((OrderDTO)order);
            }
            if (orderInDatabase.isPresent() && !this.orderMapper.mapToOrderDTO(orderInDatabase.get()).equals(order)) {
                this.logger.debug("OrderFlux - Order {} has changed : {}", (Object)order.getOrderId(), order);
                newValues.add((OrderDTO)order);
            }
        });
        this.logger.debug("OrderFlux - {} order(s) updated", (Object)newValues.size());
        return newValues;
    }

    @Override
    protected final Optional<OrderDTO> saveValue(OrderDTO newValue) {
        AtomicReference valueToSave = new AtomicReference();
        this.orderRepository.findByOrderId(newValue.getOrderId()).ifPresentOrElse(order -> {
            this.orderMapper.updateOrder(newValue, (Order)order);
            valueToSave.set(order);
            this.logger.debug("OrderFlux - Updating order in database {}", order);
        }, () -> {
            valueToSave.set(this.orderMapper.mapToOrder(newValue));
            this.logger.debug("OrderFlux - Creating order in database {}", (Object)newValue);
        });
        return Optional.ofNullable(this.orderMapper.mapToOrderDTO((Order)this.orderRepository.save((Order)valueToSave.get())));
    }
}

