/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.batch;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import tech.cassandre.trading.bot.dto.user.AccountDTO;
import tech.cassandre.trading.bot.service.UserService;
import tech.cassandre.trading.bot.util.base.batch.BaseExternalFlux;

public class AccountFlux
extends BaseExternalFlux<AccountDTO> {
    private final UserService userService;
    private Map<String, AccountDTO> previousValues = new LinkedHashMap<String, AccountDTO>();

    public AccountFlux(UserService newUserService) {
        this.userService = newUserService;
    }

    @Override
    protected final Set<AccountDTO> getNewValues() {
        this.logger.debug("AccountFlux - Retrieving new values");
        LinkedHashSet<AccountDTO> newValues = new LinkedHashSet<AccountDTO>();
        this.userService.getUser().ifPresent(user -> {
            user.getAccounts().forEach((accountId, account) -> {
                this.logger.debug("AccountFlux - Treating account : {}", accountId);
                if (this.previousValues.containsKey(accountId)) {
                    if (!account.equals(this.previousValues.get(accountId))) {
                        this.logger.debug("AccountFlux - Account {} has changed : {}", accountId, account);
                        newValues.add((AccountDTO)account);
                    }
                } else {
                    this.logger.debug("AccountFlux - New account : {}", account);
                    newValues.add((AccountDTO)account);
                }
            });
            this.previousValues = user.getAccounts();
        });
        this.logger.debug("AccountFlux - {} account(s) updated", (Object)newValues.size());
        return newValues;
    }

    @Override
    protected final Optional<AccountDTO> saveValue(AccountDTO newValue) {
        return Optional.ofNullable(newValue);
    }
}

