/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ValidatingDecoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import tech.allegro.schema.json2avro.converter.AvroConversionException;
import tech.allegro.schema.json2avro.converter.JsonGenericRecordReader;
import tech.allegro.schema.json2avro.converter.JsonToAvroReader;
import tech.allegro.schema.json2avro.converter.UnknownFieldListener;

public class JsonAvroConverter {
    private JsonGenericRecordReader recordReader;

    public JsonAvroConverter() {
        this.recordReader = new JsonGenericRecordReader();
    }

    public JsonAvroConverter(ObjectMapper objectMapper) {
        this.recordReader = new JsonGenericRecordReader(objectMapper);
    }

    public JsonAvroConverter(ObjectMapper objectMapper, JsonToAvroReader jsonToAvroReader) {
        this.recordReader = new JsonGenericRecordReader(objectMapper, jsonToAvroReader);
    }

    public JsonAvroConverter(JsonToAvroReader jsonToAvroReader) {
        this.recordReader = new JsonGenericRecordReader(jsonToAvroReader);
    }

    public JsonAvroConverter(ObjectMapper objectMapper, UnknownFieldListener unknownFieldListener) {
        this.recordReader = new JsonGenericRecordReader(objectMapper, unknownFieldListener);
    }

    public byte[] convertToAvro(byte[] data, String schema) {
        return this.convertToAvro(data, new Schema.Parser().parse(schema));
    }

    public byte[] convertToAvro(byte[] data, Schema schema) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            writer.write((Object)this.convertToGenericDataRecord(data, schema), (Encoder)encoder);
            encoder.flush();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new AvroConversionException("Failed to convert to AVRO.", e);
        }
    }

    public GenericData.Record convertToGenericDataRecord(byte[] data, Schema schema) {
        return this.recordReader.read(data, schema);
    }

    public <T extends SpecificRecordBase> T convertToSpecificRecord(byte[] jsonData, Class<T> clazz, Schema schema) {
        byte[] avroBinaryData = this.convertToAvro(jsonData, schema);
        SpecificDatumReader reader = new SpecificDatumReader(clazz);
        ByteArrayInputStream inStream = new ByteArrayInputStream(avroBinaryData);
        BinaryDecoder binaryDecoder = DecoderFactory.get().directBinaryDecoder((InputStream)inStream, null);
        try {
            ValidatingDecoder decoder = DecoderFactory.get().validatingDecoder(schema, (Decoder)binaryDecoder);
            return (T)((SpecificRecordBase)reader.read(null, (Decoder)decoder));
        }
        catch (IOException e) {
            throw new AvroConversionException("Failed to convert to AVRO.", e);
        }
    }

    public <T extends SpecificRecordBase> T convertToSpecificRecord(byte[] data, Class<T> clazz, String schema) {
        return this.convertToSpecificRecord(data, clazz, new Schema.Parser().parse(schema));
    }
}

