/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.function.Function;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverterWithStrictJavaTypeCheck;

public class PrimitiveConverter<T>
extends AvroTypeConverterWithStrictJavaTypeCheck<T> {
    public static final AvroTypeConverter BOOLEAN = new PrimitiveConverter<Boolean>(Schema.Type.BOOLEAN, Boolean.class, bool -> bool);
    public static final AvroTypeConverter STRING = new PrimitiveConverter<String>(Schema.Type.STRING, String.class, string -> string);
    public static final AvroTypeConverter INT = new PrimitiveConverter<Number>(Schema.Type.INT, Number.class, Number::intValue);
    public static final AvroTypeConverter LONG = new PrimitiveConverter<Number>(Schema.Type.LONG, Number.class, Number::longValue);
    public static final AvroTypeConverter DOUBLE = new PrimitiveConverter<Number>(Schema.Type.DOUBLE, Number.class, Number::doubleValue);
    public static final AvroTypeConverter FLOAT = new PrimitiveConverter<Number>(Schema.Type.FLOAT, Number.class, Number::floatValue);
    public static final AvroTypeConverter BYTES = new PrimitiveConverter<String>(Schema.Type.BYTES, String.class, value -> ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8)));
    private final Schema.Type avroType;
    private final Function<T, Object> mapper;

    protected PrimitiveConverter(Schema.Type avroType, Class<T> javaType, Function<T, Object> mapper) {
        super(javaType);
        this.avroType = avroType;
        this.mapper = mapper;
    }

    @Override
    public Object convertValue(Schema.Field field, Schema schema, T value, Deque<String> path, boolean silently) {
        return this.mapper.apply(value);
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return schema.getType().equals((Object)this.avroType);
    }
}

