/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.api;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import manifold.json.rt.Json;
import manifold.json.rt.api.Endpoint;
import manifold.json.rt.api.IJsonList;

public class Requester<T> {
    private final Endpoint _endpoint;
    private Function<Object, Object> _resultCoercer;
    private Format _format;
    private Map<String, String> _headers;
    private Map<String, String> _parameters;
    private Function<T, Object> _rawResponseHandler;
    private int _timeout;

    public Requester(String urlBase) {
        this(urlBase, (Object result) -> result);
    }

    public Requester(String urlBase, Function<Object, Object> resultCoercer) {
        this._endpoint = new Endpoint(urlBase);
        this._resultCoercer = resultCoercer;
        this._format = Format.Json;
        this._headers = new HashMap<String, String>();
        this._parameters = Collections.emptyMap();
        this._timeout = 0;
    }

    public Requester(Endpoint endpoint) {
        this(endpoint, (Object result) -> result);
    }

    public Requester(Endpoint endpoint, Function<Object, Object> resultCoercer) {
        this._endpoint = endpoint;
        this._resultCoercer = resultCoercer;
        this._format = Format.Json;
        this._headers = new HashMap<String, String>();
        this._parameters = Collections.emptyMap();
        this._timeout = 0;
    }

    public Endpoint getEndpoint() {
        return this._endpoint;
    }

    public Format getFormat() {
        return this._format;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this._headers);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this._parameters);
    }

    public Requester<T> withCoercer(Function<Object, Object> resultCoercer) {
        this._resultCoercer = resultCoercer;
        return this;
    }

    public Requester<T> withResponseFormat(Format format) {
        this._format = format;
        return this;
    }

    public Requester<T> withHeader(String name, String value) {
        this._headers.put(name, value);
        return this;
    }

    public Requester<T> withParam(String name, String value) {
        if (this._parameters.isEmpty()) {
            this._parameters = new HashMap<String, String>(2);
        }
        this._parameters.put(name, value);
        return this;
    }

    public Requester<T> withBasicAuthorization(String username, String password) {
        String authorization = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return this.withHeader("Authorization", "Basic " + authorization);
    }

    public Requester<T> withBearerAuthorization(String accessToken) {
        return this.withAuthorization("Bearer", accessToken);
    }

    public Requester<T> withAuthorization(String tokenType, String accessToken) {
        return this.withHeader("Authorization", tokenType + " " + accessToken);
    }

    public Requester<T> withTimeout(int timeout) {
        this._timeout = timeout;
        return this;
    }

    public Requester<T> withRawResponseHandler(Function<T, Object> handler) {
        this._rawResponseHandler = handler;
        return this;
    }

    public Function<T, Object> getRawResponseHandler() {
        return this._rawResponseHandler;
    }

    public T getOne() {
        return this.getOne("", null);
    }

    public T getOne(String urlSuffix) {
        return this.getOne(urlSuffix, null);
    }

    public T getOne(Object arguments) {
        return this.getOne("", arguments);
    }

    public T getOne(String urlSuffix, Object arguments) {
        return this.getOne(urlSuffix, arguments, this._format);
    }

    public T getOne(String urlSuffix, Object arguments, Format format) {
        return (T)this.request(urlSuffix, Http.GET, format, arguments);
    }

    public IJsonList<T> getMany() {
        return this.getMany("", null);
    }

    public IJsonList<T> getMany(String urlSuffix) {
        return this.getMany(urlSuffix, null);
    }

    public IJsonList<T> getMany(Object arguments) {
        return this.getMany("", arguments);
    }

    public IJsonList<T> getMany(String urlSuffix, Object arguments) {
        return this.getMany(urlSuffix, arguments, this._format);
    }

    public IJsonList<T> getMany(String urlSuffix, Object arguments, Format format) {
        return this.request(urlSuffix, Http.GET, format, arguments);
    }

    public <R> R postOne(T payload) {
        return this.postOne("", payload);
    }

    public <R> R postOne(String urlSuffix, T payload) {
        return this.postOne(urlSuffix, payload, this._format);
    }

    public <R> R postOne(String urlSuffix, T payload, Format format) {
        return this.request(urlSuffix, Http.POST, format, payload);
    }

    public <R> R postMany(List<T> payload) {
        return this.postMany("", payload);
    }

    public <R> R postMany(String urlSuffix, List<T> payload) {
        return this.postMany(urlSuffix, payload, this._format);
    }

    public <R> R postMany(String urlSuffix, List<T> payload, Format format) {
        return this.request(urlSuffix, Http.POST, format, payload);
    }

    public <R> R putOne(T payload) {
        return this.putOne("", payload);
    }

    public <R> R putOne(String urlSuffix, T payload) {
        return this.putOne(urlSuffix, payload, this._format);
    }

    public <R> R putOne(String urlSuffix, T payload, Format format) {
        return this.request(urlSuffix, Http.PUT, format, payload);
    }

    public <R> R putMany(List<T> payload) {
        return this.putMany("", payload);
    }

    public <R> R putMany(String urlSuffix, List<T> payload) {
        return this.putMany(urlSuffix, payload, this._format);
    }

    public <R> R putMany(String urlSuffix, List<T> payload, Format format) {
        return this.request(urlSuffix, Http.PUT, format, payload);
    }

    public <R> R patchOne(T payload) {
        return this.patchOne("", payload);
    }

    public <R> R patchOne(String urlSuffix, T payload) {
        return this.patchOne(urlSuffix, payload, this._format);
    }

    public <R> R patchOne(String urlSuffix, T payload, Format format) {
        return this.request(urlSuffix, Http.PATCH, format, payload);
    }

    public <R> R patchMany(List<T> payload) {
        return this.patchMany("", payload);
    }

    public <R> R patchMany(String urlSuffix, List<T> payload) {
        return this.patchMany(urlSuffix, payload, this._format);
    }

    public <R> R patchMany(String urlSuffix, List<T> payload, Format format) {
        return this.request(urlSuffix, Http.PATCH, format, payload);
    }

    public <R> R delete(Object arguments) {
        return this.delete("", arguments);
    }

    public <R> R delete(String urlSuffix) {
        return this.delete(urlSuffix, null);
    }

    public <R> R delete(String urlSuffix, Object arguments) {
        return this.delete(urlSuffix, arguments, this._format);
    }

    public <R> R delete(String urlSuffix, Object arguments, Format format) {
        return this.request(urlSuffix, Http.DELETE, format, arguments);
    }

    private <R> R request(String urlSuffix, Http method, Format format, Object jsonValue) {
        jsonValue = Json.toBindings(jsonValue);
        Endpoint endpoint = (urlSuffix = this.appendParams(urlSuffix)) != null ? this._endpoint.withUrlSuffix(urlSuffix) : this._endpoint;
        Object result = null;
        switch (format) {
            case Json: {
                this._headers.put("Accept", "application/json");
                result = endpoint.sendJsonRequest(method.name(), jsonValue, this._headers, this._timeout);
                break;
            }
            case Yaml: {
                this._headers.put("Accept", "application/x-yaml, application/yaml, text/yaml;q=0.9");
                result = endpoint.sendYamlRequest(method.name(), jsonValue, this._headers, this._timeout);
                break;
            }
            case Xml: {
                this._headers.put("Accept", "application/xml");
                result = endpoint.sendXmlRequest(method.name(), jsonValue, this._headers, this._timeout);
                break;
            }
            case Csv: {
                this._headers.put("Accept", "text/csv");
                result = endpoint.sendCsvRequest(method.name(), jsonValue, this._headers, this._timeout);
                break;
            }
            case Text: {
                result = endpoint.sendPlainTextRequest(method.name(), jsonValue, this._headers, this._timeout);
                break;
            }
            default: {
                throw new IllegalArgumentException("format: " + (Object)((Object)format));
            }
        }
        result = this._resultCoercer.apply(result);
        return (R)result;
    }

    private String appendParams(String urlSuffix) {
        if (this._parameters.isEmpty()) {
            return urlSuffix;
        }
        boolean firstParam = urlSuffix.indexOf(63) < 0;
        StringBuilder sb = new StringBuilder(urlSuffix);
        for (Map.Entry<String, String> entry : this._parameters.entrySet()) {
            sb.append(firstParam ? (char)'?' : '&').append(entry.getKey()).append('=').append(entry.getValue());
            firstParam = false;
        }
        return sb.toString();
    }

    private static enum Http {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }

    public static enum Format {
        Json,
        Yaml,
        Xml,
        Csv,
        Text;

    }
}

