/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.Provider;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.CipherMode;
import software.amazon.encryption.s3.internal.CipherProvider;
import software.amazon.encryption.s3.materials.CryptographicMaterials;
import software.amazon.encryption.s3.materials.MaterialsDescription;

public final class DecryptionMaterials
implements CryptographicMaterials {
    private final GetObjectRequest _s3Request;
    private final AlgorithmSuite _algorithmSuite;
    private final Map<String, String> _encryptionContext;
    private final MaterialsDescription _materialsDescription;
    private final byte[] _plaintextDataKey;
    private final long _ciphertextLength;
    private final Provider _cryptoProvider;
    private final String _contentRange;
    private final byte[] _keyCommitment;
    private byte[] _messageId;
    private byte[] _iv;

    private DecryptionMaterials(Builder builder) {
        this._s3Request = builder._s3Request;
        this._algorithmSuite = builder._algorithmSuite;
        this._encryptionContext = builder._encryptionContext;
        this._materialsDescription = builder._materialsDescription;
        this._plaintextDataKey = builder._plaintextDataKey;
        this._ciphertextLength = builder._ciphertextLength;
        this._cryptoProvider = builder._cryptoProvider;
        this._contentRange = builder._contentRange;
        this._keyCommitment = builder._keyCommitment;
        this._messageId = builder._messageId;
        this._iv = builder._iv;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetObjectRequest s3Request() {
        return this._s3Request;
    }

    @Override
    public AlgorithmSuite algorithmSuite() {
        return this._algorithmSuite;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="False positive; underlying implementation is immutable")
    public Map<String, String> encryptionContext() {
        return this._encryptionContext;
    }

    public MaterialsDescription materialsDescription() {
        return this._materialsDescription;
    }

    public byte[] plaintextDataKey() {
        if (this._plaintextDataKey == null) {
            return null;
        }
        return (byte[])this._plaintextDataKey.clone();
    }

    @Override
    public SecretKey dataKey() {
        return new SecretKeySpec(this._plaintextDataKey, this.algorithmSuite().dataKeyAlgorithm());
    }

    @Override
    public Provider cryptoProvider() {
        return this._cryptoProvider;
    }

    public long ciphertextLength() {
        return this._ciphertextLength;
    }

    @Override
    public CipherMode cipherMode() {
        return CipherMode.DECRYPT;
    }

    @Override
    public Cipher getCipher(byte[] iv) {
        return CipherProvider.createAndInitCipher(this, iv, this._messageId);
    }

    public String getContentRange() {
        return this._contentRange;
    }

    @Override
    public byte[] getKeyCommitment() {
        return this._keyCommitment != null ? (byte[])this._keyCommitment.clone() : null;
    }

    @Override
    public byte[] messageId() {
        return this._messageId;
    }

    @Override
    public byte[] iv() {
        return this._iv;
    }

    public void setIvAndMessageId(byte[] iv, byte[] messageId) {
        this._iv = iv;
        this._messageId = messageId;
    }

    public Builder toBuilder() {
        return new Builder().s3Request(this._s3Request).algorithmSuite(this._algorithmSuite).encryptionContext(this._encryptionContext).materialsDescription(this._materialsDescription).plaintextDataKey(this._plaintextDataKey).ciphertextLength(this._ciphertextLength).cryptoProvider(this._cryptoProvider).contentRange(this._contentRange).keyCommitment(this._keyCommitment);
    }

    public static class Builder {
        public GetObjectRequest _s3Request = null;
        public byte[] _messageId = null;
        public byte[] _iv = null;
        private Provider _cryptoProvider = null;
        private AlgorithmSuite _algorithmSuite = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF;
        private Map<String, String> _encryptionContext = Collections.emptyMap();
        private MaterialsDescription _materialsDescription = MaterialsDescription.builder().build();
        private byte[] _plaintextDataKey = null;
        private long _ciphertextLength = -1L;
        private String _contentRange = null;
        private byte[] _keyCommitment = null;

        private Builder() {
        }

        public Builder s3Request(GetObjectRequest s3Request) {
            this._s3Request = s3Request;
            return this;
        }

        public Builder algorithmSuite(AlgorithmSuite algorithmSuite) {
            this._algorithmSuite = algorithmSuite;
            return this;
        }

        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this._encryptionContext = encryptionContext == null ? Collections.emptyMap() : Collections.unmodifiableMap(encryptionContext);
            return this;
        }

        public Builder materialsDescription(MaterialsDescription materialsDescription) {
            this._materialsDescription = materialsDescription == null ? MaterialsDescription.builder().build() : materialsDescription;
            return this;
        }

        public Builder plaintextDataKey(byte[] plaintextDataKey) {
            this._plaintextDataKey = plaintextDataKey == null ? null : (byte[])plaintextDataKey.clone();
            return this;
        }

        public Builder ciphertextLength(long ciphertextLength) {
            this._ciphertextLength = ciphertextLength;
            return this;
        }

        public Builder cryptoProvider(Provider cryptoProvider) {
            this._cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder contentRange(String contentRange) {
            this._contentRange = contentRange;
            return this;
        }

        public Builder keyCommitment(byte[] keyCommitment) {
            this._keyCommitment = keyCommitment;
            return this;
        }

        public Builder iv(byte[] iv) {
            this._iv = iv;
            return this;
        }

        public Builder messageId(byte[] messageId) {
            this._messageId = messageId;
            return this;
        }

        public DecryptionMaterials build() {
            return new DecryptionMaterials(this);
        }
    }
}

