/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import javax.crypto.SecretKey;
import software.amazon.encryption.s3.materials.MaterialsDescription;
import software.amazon.encryption.s3.materials.RawKeyMaterial;

public class AesKeyMaterial
extends RawKeyMaterial<SecretKey> {
    public AesKeyMaterial(MaterialsDescription materialsDescription, SecretKey keyMaterial) {
        super(materialsDescription, keyMaterial);
    }

    public static Builder aesBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MaterialsDescription _materialsDescription;
        private SecretKey _keyMaterial;

        public Builder materialsDescription(MaterialsDescription materialsDescription) {
            this._materialsDescription = materialsDescription;
            return this;
        }

        public Builder keyMaterial(SecretKey keyMaterial) {
            this._keyMaterial = keyMaterial;
            return this;
        }

        public AesKeyMaterial build() {
            return new AesKeyMaterial(this._materialsDescription, this._keyMaterial);
        }
    }
}

