/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.materials.RawKeyring;
import software.amazon.encryption.s3.materials.RsaKeyring;

public class ReEncryptInstructionFileRequest {
    private final String bucket;
    private final String key;
    private final RawKeyring newKeyring;
    private final String instructionFileSuffix;
    private final boolean enforceRotation;

    private ReEncryptInstructionFileRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.newKeyring = builder.newKeyring;
        this.instructionFileSuffix = builder.instructionFileSuffix;
        this.enforceRotation = builder.enforceRotation;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public RawKeyring newKeyring() {
        return this.newKeyring;
    }

    public String instructionFileSuffix() {
        return this.instructionFileSuffix;
    }

    public boolean enforceRotation() {
        return this.enforceRotation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bucket;
        private String key;
        private RawKeyring newKeyring;
        private String instructionFileSuffix = ".instruction";
        private boolean enforceRotation = false;

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder newKeyring(RawKeyring newKeyring) {
            this.newKeyring = newKeyring;
            return this;
        }

        public Builder instructionFileSuffix(String instructionFileSuffix) {
            this.instructionFileSuffix = "." + instructionFileSuffix;
            return this;
        }

        public Builder enforceRotation(boolean enforceRotation) {
            this.enforceRotation = enforceRotation;
            return this;
        }

        public ReEncryptInstructionFileRequest build() {
            if (this.bucket == null || this.bucket.isEmpty()) {
                throw new S3EncryptionClientException("Bucket must be provided!");
            }
            if (this.key == null || this.key.isEmpty()) {
                throw new S3EncryptionClientException("Key must be provided!");
            }
            if (this.newKeyring == null) {
                throw new S3EncryptionClientException("New keyring must be provided!");
            }
            if (!(this.newKeyring instanceof RsaKeyring) && !this.instructionFileSuffix.equals(".instruction")) {
                throw new S3EncryptionClientException("Custom Instruction file suffix is only applicable for RSA keyring!");
            }
            return new ReEncryptInstructionFileRequest(this);
        }
    }
}

