/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ApiNameVersion;
import software.amazon.encryption.s3.internal.AsyncContentEncryptionStrategy;
import software.amazon.encryption.s3.internal.ContentMetadataEncodingStrategy;
import software.amazon.encryption.s3.internal.EncryptedContent;
import software.amazon.encryption.s3.internal.InstructionFileConfig;
import software.amazon.encryption.s3.internal.StreamingAesGcmContentStrategy;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterialsRequest;

public class PutEncryptedObjectPipeline {
    private final S3AsyncClient _s3AsyncClient;
    private final CryptographicMaterialsManager _cryptoMaterialsManager;
    private final AsyncContentEncryptionStrategy _asyncContentEncryptionStrategy;
    private final ContentMetadataEncodingStrategy _contentMetadataEncodingStrategy;
    private final AlgorithmSuite _encryptionAlgorithm;

    public static Builder builder() {
        return new Builder();
    }

    private PutEncryptedObjectPipeline(Builder builder) {
        this._s3AsyncClient = builder._s3AsyncClient;
        this._cryptoMaterialsManager = builder._cryptoMaterialsManager;
        this._asyncContentEncryptionStrategy = builder._asyncContentEncryptionStrategy;
        this._contentMetadataEncodingStrategy = builder._contentMetadataEncodingStrategy;
        this._encryptionAlgorithm = builder._encryptionAlgorithm;
    }

    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest request, AsyncRequestBody requestBody) {
        Long contentLength;
        if (request.contentLength() != null) {
            if (requestBody.contentLength().isPresent() && !request.contentLength().equals(requestBody.contentLength().get())) {
                throw new S3EncryptionClientException("The contentLength provided in the request object MUST match the contentLength in the request body");
            }
            contentLength = !requestBody.contentLength().isPresent() ? request.contentLength() : request.contentLength();
        } else {
            contentLength = (Long)requestBody.contentLength().orElseThrow(() -> new S3EncryptionClientException("Unbounded streams are currently not supported."));
        }
        if (contentLength > this._encryptionAlgorithm.cipherMaxContentLengthBytes()) {
            throw new S3EncryptionClientException("The contentLength of the object you are attempting to encrypt exceedsthe maximum length allowed for GCM encryption.");
        }
        EncryptionMaterialsRequest encryptionMaterialsRequest = EncryptionMaterialsRequest.builder().s3Request((S3Request)request).plaintextLength(contentLength).encryptionAlgorithm(this._encryptionAlgorithm).build();
        EncryptionMaterials materials = this._cryptoMaterialsManager.getEncryptionMaterials(encryptionMaterialsRequest);
        if (materials == null) {
            throw new S3EncryptionClientException("Encryption materials cannot be null during content encryption. This may be caused by a misconfigured custom CMM implementation, or a suppressed exception from CMM invocation due to a network failure.");
        }
        EncryptedContent encryptedContent = this._asyncContentEncryptionStrategy.encryptContent(materials, requestBody);
        byte[] contentIV = materials.algorithmSuite().isCommitting() ? materials.messageId() : materials.iv();
        PutObjectRequest modifiedRequest = this._contentMetadataEncodingStrategy.encodeMetadata(materials, contentIV, request);
        PutObjectRequest encryptedPutRequest = (PutObjectRequest)modifiedRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).contentLength(Long.valueOf(encryptedContent.getCiphertextLength())).build();
        return this._s3AsyncClient.putObject(encryptedPutRequest, encryptedContent.getAsyncCiphertext());
    }

    public static class Builder {
        private S3AsyncClient _s3AsyncClient;
        private CryptographicMaterialsManager _cryptoMaterialsManager;
        private SecureRandom _secureRandom;
        private AsyncContentEncryptionStrategy _asyncContentEncryptionStrategy;
        private InstructionFileConfig _instructionFileConfig;
        private ContentMetadataEncodingStrategy _contentMetadataEncodingStrategy;
        private AlgorithmSuite _encryptionAlgorithm;

        private Builder() {
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder s3AsyncClient(S3AsyncClient s3AsyncClient) {
            this._s3AsyncClient = s3AsyncClient;
            return this;
        }

        public Builder cryptoMaterialsManager(CryptographicMaterialsManager cryptoMaterialsManager) {
            this._cryptoMaterialsManager = cryptoMaterialsManager;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this._secureRandom = secureRandom;
            return this;
        }

        public Builder instructionFileConfig(InstructionFileConfig instructionFileConfig) {
            this._instructionFileConfig = instructionFileConfig;
            return this;
        }

        public Builder encryptionAlgorithm(AlgorithmSuite encryptionAlgorithm) {
            this._encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public PutEncryptedObjectPipeline build() {
            if (this._asyncContentEncryptionStrategy == null) {
                this._asyncContentEncryptionStrategy = StreamingAesGcmContentStrategy.builder().secureRandom(this._secureRandom).build();
            }
            if (this._instructionFileConfig == null) {
                this._instructionFileConfig = InstructionFileConfig.builder().build();
            }
            this._contentMetadataEncodingStrategy = new ContentMetadataEncodingStrategy(this._instructionFileConfig);
            return new PutEncryptedObjectPipeline(this);
        }
    }
}

