/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.util.Map;
import software.amazon.encryption.s3.S3EncryptionClientException;

public class MetadataKeyConstants {
    private static final String AMZ_PREFIX = "x-amz-";
    public static final String ENCRYPTED_DATA_KEY_V1 = "x-amz-key";
    public static final String ENCRYPTED_DATA_KEY_V2 = "x-amz-key-v2";
    public static final String ENCRYPTED_DATA_KEY_ALGORITHM = "x-amz-wrap-alg";
    public static final String ENCRYPTED_DATA_KEY_MATDESC_OR_EC = "x-amz-matdesc";
    public static final String CONTENT_IV = "x-amz-iv";
    public static final String CONTENT_CIPHER = "x-amz-cek-alg";
    public static final String CONTENT_CIPHER_TAG_LENGTH = "x-amz-tag-len";
    public static final String INSTRUCTION_FILE = "x-amz-crypto-instr-file";
    public static final String CONTENT_CIPHER_V3 = "x-amz-c";
    public static final String ENCRYPTED_DATA_KEY_V3 = "x-amz-3";
    public static final String MAT_DESC_V3 = "x-amz-m";
    public static final String ENCRYPTION_CONTEXT_V3 = "x-amz-t";
    public static final String ENCRYPTED_DATA_KEY_ALGORITHM_V3 = "x-amz-w";
    public static final String KEY_COMMITMENT_V3 = "x-amz-d";
    public static final String MESSAGE_ID_V3 = "x-amz-i";
    public static final String V3_ALG_AES_GCM = "AES/GCM";
    public static final String V3_ALG_KMS_CONTEXT = "kms+context";
    public static final String V3_ALG_RSA_OAEP_SHA1 = "RSA-OAEP-SHA1";
    public static final String V3_COMPRESSED_AES_GCM = "02";
    public static final String V3_COMPRESSED_KMS_CONTEXT = "12";
    public static final String V3_COMPRESSED_RSA_OAEP_SHA1 = "22";

    public static boolean isV1Format(Map<String, String> metadata) {
        return metadata.containsKey(CONTENT_IV) && metadata.containsKey(ENCRYPTED_DATA_KEY_MATDESC_OR_EC) && metadata.containsKey(ENCRYPTED_DATA_KEY_V1) && !metadata.containsKey(ENCRYPTED_DATA_KEY_V2) && !metadata.containsKey(ENCRYPTED_DATA_KEY_V3);
    }

    public static boolean isV2Format(Map<String, String> metadata) {
        return metadata.containsKey(CONTENT_CIPHER) && metadata.containsKey(CONTENT_IV) && metadata.containsKey(ENCRYPTED_DATA_KEY_ALGORITHM) && metadata.containsKey(ENCRYPTED_DATA_KEY_V2) && !metadata.containsKey(ENCRYPTED_DATA_KEY_V1) && !metadata.containsKey(ENCRYPTED_DATA_KEY_V3);
    }

    public static boolean isV3Format(Map<String, String> metadata) {
        return metadata.containsKey(CONTENT_CIPHER_V3) && metadata.containsKey(ENCRYPTED_DATA_KEY_ALGORITHM_V3) && metadata.containsKey(KEY_COMMITMENT_V3) && metadata.containsKey(MESSAGE_ID_V3) && metadata.containsKey(ENCRYPTED_DATA_KEY_V3) && !metadata.containsKey(ENCRYPTED_DATA_KEY_V2) && !metadata.containsKey(ENCRYPTED_DATA_KEY_V1);
    }

    public static String compressWrappingAlgorithm(String algorithmName) {
        switch (algorithmName) {
            case "AES/GCM": {
                return V3_COMPRESSED_AES_GCM;
            }
            case "kms+context": {
                return V3_COMPRESSED_KMS_CONTEXT;
            }
            case "RSA-OAEP-SHA1": {
                return V3_COMPRESSED_RSA_OAEP_SHA1;
            }
        }
        throw new S3EncryptionClientException("Unknown wrapping algorithm: " + algorithmName);
    }

    public static String decompressWrappingAlgorithm(String compressedValue) {
        switch (compressedValue) {
            case "02": {
                return V3_ALG_AES_GCM;
            }
            case "12": {
                return V3_ALG_KMS_CONTEXT;
            }
            case "22": {
                return V3_ALG_RSA_OAEP_SHA1;
            }
        }
        throw new S3EncryptionClientException("Unknown wrapping algorithm value: " + compressedValue);
    }
}

