/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.encryption.s3.CommitmentPolicy;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ApiNameVersion;
import software.amazon.encryption.s3.internal.BufferedCipherPublisher;
import software.amazon.encryption.s3.internal.CipherPublisher;
import software.amazon.encryption.s3.internal.ContentMetadata;
import software.amazon.encryption.s3.internal.ContentMetadataDecodingStrategy;
import software.amazon.encryption.s3.internal.InstructionFileConfig;
import software.amazon.encryption.s3.legacy.internal.AesCtrUtils;
import software.amazon.encryption.s3.legacy.internal.RangedGetUtils;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.DecryptMaterialsRequest;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptedDataKey;

public class GetEncryptedObjectPipeline {
    private final S3AsyncClient _s3AsyncClient;
    private final CryptographicMaterialsManager _cryptoMaterialsManager;
    private final boolean _enableLegacyUnauthenticatedModes;
    private final boolean _enableDelayedAuthentication;
    private final long _bufferSize;
    private final InstructionFileConfig _instructionFileConfig;
    private final CommitmentPolicy _commitmentPolicy;

    public static Builder builder() {
        return new Builder();
    }

    private GetEncryptedObjectPipeline(Builder builder) {
        this._s3AsyncClient = builder._s3AsyncClient;
        this._cryptoMaterialsManager = builder._cryptoMaterialsManager;
        this._enableLegacyUnauthenticatedModes = builder._enableLegacyUnauthenticatedModes;
        this._enableDelayedAuthentication = builder._enableDelayedAuthentication;
        this._bufferSize = builder._bufferSize;
        this._instructionFileConfig = builder._instructionFileConfig;
        this._commitmentPolicy = builder._commitmentPolicy;
    }

    public <T> CompletableFuture<T> getObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, T> asyncResponseTransformer) {
        String cryptoRange = RangedGetUtils.getCryptoRangeAsString(getObjectRequest.range());
        GetObjectRequest adjustedRangeRequest = (GetObjectRequest)getObjectRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).range(cryptoRange).build();
        if (!this._enableLegacyUnauthenticatedModes && getObjectRequest.range() != null) {
            throw new S3EncryptionClientException("Enable legacy unauthenticated modes to use Ranged Get.");
        }
        return this._s3AsyncClient.getObject(adjustedRangeRequest, new DecryptingResponseTransformer<T>(asyncResponseTransformer, getObjectRequest));
    }

    private DecryptionMaterials prepareMaterialsFromRequest(GetObjectRequest getObjectRequest, GetObjectResponse getObjectResponse, ContentMetadata contentMetadata) {
        if (getObjectRequest.range() == null && getObjectResponse.contentRange() != null) {
            throw new S3EncryptionClientException("Content range in response but is missing from request. Ensure multipart upload is not enabled on the wrapped async client.");
        }
        AlgorithmSuite algorithmSuite = contentMetadata.algorithmSuite();
        if (!this._enableLegacyUnauthenticatedModes && algorithmSuite.isLegacy()) {
            throw new S3EncryptionClientException("Enable legacy unauthenticated modes to use legacy content decryption: " + algorithmSuite.cipherName());
        }
        if (this._commitmentPolicy.requiresDecrypt() && !algorithmSuite.isCommitting()) {
            throw new S3EncryptionClientException("Commitment policy violation, decryption requires a committing algorithm suite, but the object was encrypted with a non-committing algorithm. Configure the client to allow non-committing algorithms.");
        }
        List<EncryptedDataKey> encryptedDataKeys = Collections.singletonList(contentMetadata.encryptedDataKey());
        DecryptMaterialsRequest materialsRequest = DecryptMaterialsRequest.builder().s3Request(getObjectRequest).algorithmSuite(algorithmSuite).encryptedDataKeys(encryptedDataKeys).encryptionContext(contentMetadata.encryptionContext()).materialsDescription(contentMetadata.materialsDescription()).ciphertextLength(getObjectResponse.contentLength()).contentRange(getObjectRequest.range()).keyCommitment(contentMetadata.keyCommitment()).build();
        DecryptionMaterials materials = this._cryptoMaterialsManager.decryptMaterials(materialsRequest);
        if (materials == null) {
            throw new S3EncryptionClientException("Decryption materials cannot be null. This may be caused by a misconfigured custom CMM implementation or a suppressed exception from metadata decoding or CMM invocation due to a network failure.");
        }
        return materials;
    }

    public static class Builder {
        private S3AsyncClient _s3AsyncClient;
        private CryptographicMaterialsManager _cryptoMaterialsManager;
        private boolean _enableLegacyUnauthenticatedModes;
        private boolean _enableDelayedAuthentication;
        private long _bufferSize;
        private InstructionFileConfig _instructionFileConfig;
        private CommitmentPolicy _commitmentPolicy;

        private Builder() {
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder s3AsyncClient(S3AsyncClient s3AsyncClient) {
            this._s3AsyncClient = s3AsyncClient;
            return this;
        }

        public Builder cryptoMaterialsManager(CryptographicMaterialsManager cryptoMaterialsManager) {
            this._cryptoMaterialsManager = cryptoMaterialsManager;
            return this;
        }

        public Builder enableLegacyUnauthenticatedModes(boolean enableLegacyUnauthenticatedModes) {
            this._enableLegacyUnauthenticatedModes = enableLegacyUnauthenticatedModes;
            return this;
        }

        public Builder bufferSize(long bufferSize) {
            this._bufferSize = bufferSize;
            return this;
        }

        public Builder enableDelayedAuthentication(boolean enableDelayedAuthentication) {
            this._enableDelayedAuthentication = enableDelayedAuthentication;
            return this;
        }

        public Builder instructionFileConfig(InstructionFileConfig instructionFileConfig) {
            this._instructionFileConfig = instructionFileConfig;
            return this;
        }

        public Builder commitmentPolicy(CommitmentPolicy commitmentPolicy) {
            this._commitmentPolicy = commitmentPolicy;
            return this;
        }

        public GetEncryptedObjectPipeline build() {
            return new GetEncryptedObjectPipeline(this);
        }
    }

    private class DecryptingResponseTransformer<T>
    implements AsyncResponseTransformer<GetObjectResponse, T> {
        final AsyncResponseTransformer<GetObjectResponse, T> wrappedAsyncResponseTransformer;
        final GetObjectRequest getObjectRequest;
        ContentMetadata contentMetadata;
        GetObjectResponse getObjectResponse;
        DecryptionMaterials materials;
        ContentMetadataDecodingStrategy contentMetadataStrategy;
        CompletableFuture<T> resultFuture;

        DecryptingResponseTransformer(AsyncResponseTransformer<GetObjectResponse, T> wrappedAsyncResponseTransformer, GetObjectRequest getObjectRequest) {
            this.contentMetadataStrategy = new ContentMetadataDecodingStrategy(GetEncryptedObjectPipeline.this._instructionFileConfig);
            this.wrappedAsyncResponseTransformer = wrappedAsyncResponseTransformer;
            this.getObjectRequest = getObjectRequest;
        }

        public CompletableFuture<T> prepare() {
            this.resultFuture = this.wrappedAsyncResponseTransformer.prepare();
            return this.resultFuture;
        }

        public void onResponse(GetObjectResponse response) {
            this.getObjectResponse = response;
            this.contentMetadata = this.contentMetadataStrategy.decode(this.getObjectRequest, response);
            this.materials = GetEncryptedObjectPipeline.this.prepareMaterialsFromRequest(this.getObjectRequest, response, this.contentMetadata);
            this.wrappedAsyncResponseTransformer.onResponse((Object)response);
        }

        public void exceptionOccurred(Throwable error) {
            this.wrappedAsyncResponseTransformer.exceptionOccurred(error);
        }

        public void onStream(SdkPublisher<ByteBuffer> ciphertextPublisher) {
            if (this.materials == null) {
                throw new S3EncryptionClientException("Decryption materials cannot be null. This may be caused by a misconfigured custom CMM implementation or a suppressed exception from metadata decoding or CMM invocation due to a network failure.");
            }
            long[] desiredRange = RangedGetUtils.getRange(this.materials.getContentRange());
            long[] cryptoRange = RangedGetUtils.getCryptoRange(this.materials.getContentRange());
            AlgorithmSuite algorithmSuite = this.materials.algorithmSuite();
            byte[] iv = this.contentMetadata.contentIv();
            byte[] messageId = this.contentMetadata.contentMessageId();
            if (algorithmSuite.isCommitting()) {
                iv = new byte[12];
                Arrays.fill(iv, (byte)1);
            }
            if (algorithmSuite == AlgorithmSuite.ALG_AES_256_CTR_IV16_TAG16_NO_KDF || algorithmSuite == AlgorithmSuite.ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY) {
                iv = AesCtrUtils.adjustIV(iv, cryptoRange[0]);
            }
            this.materials.setIvAndMessageId(iv, messageId);
            if (algorithmSuite.equals((Object)AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF) || algorithmSuite.equals((Object)AlgorithmSuite.ALG_AES_256_CTR_IV16_TAG16_NO_KDF) || algorithmSuite.equals((Object)AlgorithmSuite.ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY) || GetEncryptedObjectPipeline.this._enableDelayedAuthentication) {
                CipherPublisher plaintextPublisher = new CipherPublisher(ciphertextPublisher, this.getObjectResponse.contentLength(), desiredRange, this.contentMetadata.contentRange(), algorithmSuite.cipherTagLengthBits(), this.materials, iv, messageId);
                this.wrappedAsyncResponseTransformer.onStream((SdkPublisher)plaintextPublisher);
            } else {
                BufferedCipherPublisher plaintextPublisher = new BufferedCipherPublisher(ciphertextPublisher, this.getObjectResponse.contentLength(), this.materials, iv, messageId, GetEncryptedObjectPipeline.this._bufferSize);
                this.wrappedAsyncResponseTransformer.onStream((SdkPublisher)plaintextPublisher);
            }
        }
    }
}

