/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.internal.ConvertSDKRequests;
import software.amazon.encryption.s3.internal.InstructionFileConfig;
import software.amazon.encryption.s3.internal.MetadataKeyConstants;
import software.amazon.encryption.s3.materials.EncryptedDataKey;
import software.amazon.encryption.s3.materials.EncryptionMaterials;

public class ContentMetadataEncodingStrategy {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private final InstructionFileConfig _instructionFileConfig;

    public ContentMetadataEncodingStrategy(InstructionFileConfig instructionFileConfig) {
        this._instructionFileConfig = instructionFileConfig;
    }

    public PutObjectRequest encodeMetadata(EncryptionMaterials materials, byte[] iv, PutObjectRequest putObjectRequest) {
        return this.encodeMetadata(materials, iv, putObjectRequest, ".instruction");
    }

    public PutObjectRequest encodeMetadata(EncryptionMaterials materials, byte[] iv, PutObjectRequest putObjectRequest, String instructionFileSuffix) {
        if (this._instructionFileConfig.isInstructionFilePutEnabled()) {
            Map<String, String> objectMetadata;
            String metadataString;
            if (materials.algorithmSuite().isCommitting()) {
                metadataString = this.metadataToStringForV3InstructionFile(materials, iv);
                objectMetadata = this.addMetadataToMapV3InstructionFile(putObjectRequest.metadata(), materials, iv);
            } else {
                metadataString = this.metadataToStringForV1V2InstructionFile(materials, iv);
                objectMetadata = putObjectRequest.metadata();
            }
            this._instructionFileConfig.putInstructionFile(putObjectRequest, metadataString, instructionFileSuffix);
            return (PutObjectRequest)putObjectRequest.toBuilder().metadata(objectMetadata).build();
        }
        Map<String, String> newMetadata = this.addMetadataToMap(putObjectRequest.metadata(), materials, iv);
        return (PutObjectRequest)putObjectRequest.toBuilder().metadata(newMetadata).build();
    }

    public CreateMultipartUploadRequest encodeMetadata(EncryptionMaterials materials, byte[] iv, CreateMultipartUploadRequest createMultipartUploadRequest) {
        if (this._instructionFileConfig.isInstructionFilePutEnabled()) {
            Map<String, String> objectMetadata;
            String metadataString;
            if (materials.algorithmSuite().isCommitting()) {
                metadataString = this.metadataToStringForV3InstructionFile(materials, iv);
                objectMetadata = this.addMetadataToMapV3InstructionFile(createMultipartUploadRequest.metadata(), materials, iv);
            } else {
                metadataString = this.metadataToStringForV1V2InstructionFile(materials, iv);
                objectMetadata = createMultipartUploadRequest.metadata();
            }
            PutObjectRequest putObjectRequest = ConvertSDKRequests.convertRequest(createMultipartUploadRequest);
            this._instructionFileConfig.putInstructionFile(putObjectRequest, metadataString);
            return (CreateMultipartUploadRequest)createMultipartUploadRequest.toBuilder().metadata(objectMetadata).build();
        }
        Map<String, String> newMetadata = this.addMetadataToMap(createMultipartUploadRequest.metadata(), materials, iv);
        return (CreateMultipartUploadRequest)createMultipartUploadRequest.toBuilder().metadata(newMetadata).build();
    }

    private String metadataToStringForV1V2InstructionFile(EncryptionMaterials materials, byte[] iv) {
        Map<String, String> metadataMap = this.addMetadataToMap(new HashMap<String, String>(), materials, iv);
        return this.metadataToString(metadataMap);
    }

    private String metadataToStringForV3InstructionFile(EncryptionMaterials materials, byte[] iv) {
        Map<String, String> metadataMap = this.addMetadataToMap(new HashMap<String, String>(), materials, iv);
        metadataMap.remove("x-amz-c");
        metadataMap.remove("x-amz-d");
        metadataMap.remove("x-amz-i");
        return this.metadataToString(metadataMap);
    }

    private String metadataToString(Map<String, String> metadataMap) {
        String string;
        block9: {
            JsonWriter jsonWriter = JsonWriter.create();
            try {
                jsonWriter.writeStartObject();
                for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
                    jsonWriter.writeFieldName(entry.getKey()).writeValue(entry.getValue());
                }
                jsonWriter.writeEndObject();
                string = new String(jsonWriter.getBytes(), StandardCharsets.UTF_8);
                if (jsonWriter == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonWriter.JsonGenerationException e) {
                    throw new S3EncryptionClientException("Cannot serialize materials to JSON.", e);
                }
            }
            jsonWriter.close();
        }
        return string;
    }

    private Map<String, String> addMetadataToMapV3InstructionFile(Map<String, String> map, EncryptionMaterials materials, byte[] iv) {
        HashMap<String, String> metadata = new HashMap<String, String>(map);
        metadata.put("x-amz-c", materials.algorithmSuite().idAsString());
        metadata.put("x-amz-d", ENCODER.encodeToString(materials.getKeyCommitment()));
        metadata.put("x-amz-i", ENCODER.encodeToString(iv));
        return metadata;
    }

    private Map<String, String> addMetadataToMapV3(Map<String, String> map, EncryptionMaterials materials, byte[] iv) {
        HashMap<String, String> metadata = new HashMap<String, String>(map);
        EncryptedDataKey edk = materials.encryptedDataKeys().get(0);
        metadata.put("x-amz-3", ENCODER.encodeToString(edk.encryptedDatakey()));
        metadata.put("x-amz-i", ENCODER.encodeToString(iv));
        metadata.put("x-amz-c", materials.algorithmSuite().idAsString());
        String keyProviderInfo = MetadataKeyConstants.compressWrappingAlgorithm(edk.keyProviderInfo());
        metadata.put("x-amz-w", keyProviderInfo);
        metadata.put("x-amz-d", ENCODER.encodeToString(materials.getKeyCommitment()));
        try (JsonWriter jsonWriter = JsonWriter.create();){
            jsonWriter.writeStartObject();
            if (!materials.encryptionContext().isEmpty() && materials.materialsDescription().isEmpty()) {
                for (Map.Entry<String, String> entry : materials.encryptionContext().entrySet()) {
                    jsonWriter.writeFieldName(entry.getKey()).writeValue(entry.getValue());
                }
                jsonWriter.writeEndObject();
                String jsonEncryptionContext = new String(jsonWriter.getBytes(), StandardCharsets.UTF_8);
                metadata.put("x-amz-t", jsonEncryptionContext);
            } else if (materials.encryptionContext().isEmpty() && !materials.materialsDescription().isEmpty()) {
                for (Map.Entry<String, String> entry : materials.materialsDescription().entrySet()) {
                    jsonWriter.writeFieldName(entry.getKey()).writeValue(entry.getValue());
                }
                jsonWriter.writeEndObject();
                String jsonEncryptionContext = new String(jsonWriter.getBytes(), StandardCharsets.UTF_8);
                metadata.put("x-amz-m", jsonEncryptionContext);
            }
        }
        catch (JsonWriter.JsonGenerationException e) {
            throw new S3EncryptionClientException("Cannot serialize encryption context or mat desc to JSON.", e);
        }
        return metadata;
    }

    private Map<String, String> addMetadataToMap(Map<String, String> map, EncryptionMaterials materials, byte[] iv) {
        if (materials.algorithmSuite().isCommitting()) {
            return this.addMetadataToMapV3(map, materials, iv);
        }
        HashMap<String, String> metadata = new HashMap<String, String>(map);
        EncryptedDataKey edk = materials.encryptedDataKeys().get(0);
        metadata.put("x-amz-key-v2", ENCODER.encodeToString(edk.encryptedDatakey()));
        metadata.put("x-amz-iv", ENCODER.encodeToString(iv));
        metadata.put("x-amz-cek-alg", materials.algorithmSuite().cipherName());
        metadata.put("x-amz-tag-len", Integer.toString(materials.algorithmSuite().cipherTagLengthBits()));
        metadata.put("x-amz-wrap-alg", edk.keyProviderInfo());
        try (JsonWriter jsonWriter = JsonWriter.create();){
            jsonWriter.writeStartObject();
            if (!materials.encryptionContext().isEmpty() && materials.materialsDescription().isEmpty()) {
                for (Map.Entry<String, String> entry : materials.encryptionContext().entrySet()) {
                    jsonWriter.writeFieldName(entry.getKey()).writeValue(entry.getValue());
                }
            } else if (materials.encryptionContext().isEmpty() && !materials.materialsDescription().isEmpty()) {
                for (Map.Entry<String, String> entry : materials.materialsDescription().entrySet()) {
                    jsonWriter.writeFieldName(entry.getKey()).writeValue(entry.getValue());
                }
            }
            jsonWriter.writeEndObject();
            String jsonEncryptionContext = new String(jsonWriter.getBytes(), StandardCharsets.UTF_8);
            metadata.put("x-amz-matdesc", jsonEncryptionContext);
        }
        catch (JsonWriter.JsonGenerationException e) {
            throw new S3EncryptionClientException("Cannot serialize encryption context to JSON.", e);
        }
        return metadata;
    }
}

