/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import com.sun.xml.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.encryption.s3.S3EncryptionClient;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.S3EncryptionClientSecurityException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ContentMetadata;
import software.amazon.encryption.s3.internal.InstructionFileConfig;
import software.amazon.encryption.s3.internal.MetadataKeyConstants;
import software.amazon.encryption.s3.materials.EncryptedDataKey;
import software.amazon.encryption.s3.materials.MaterialsDescription;

public class ContentMetadataDecodingStrategy {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final InstructionFileConfig instructionFileConfig_;

    public ContentMetadataDecodingStrategy(InstructionFileConfig instructionFileConfig) {
        if (instructionFileConfig == null) {
            throw new S3EncryptionClientException("ContentMetadataDecodingStrategy requires a non-null instruction file config.");
        }
        this.instructionFileConfig_ = instructionFileConfig;
    }

    private static String decodeS3CustomEncoding(String s) {
        String mimeDecoded;
        try {
            mimeDecoded = MimeUtility.decodeText((String)s);
        }
        catch (UnsupportedEncodingException ex) {
            throw new S3EncryptionClientException("Unable to decode S3 object metadata: " + s, ex);
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            byte[] sInBytes = mimeDecoded.getBytes(StandardCharsets.UTF_8);
            char[] sInChars = mimeDecoded.toCharArray();
            int nonAsciiChars = 0;
            for (int i = 0; i < sInChars.length; ++i) {
                if (sInChars[i] > '\u007f') {
                    byte[] buf = new byte[]{sInBytes[i + nonAsciiChars], sInBytes[i + nonAsciiChars + 1]};
                    String wrongString = new String(buf, StandardCharsets.UTF_8);
                    out.write(wrongString.charAt(0));
                    ++nonAsciiChars;
                    continue;
                }
                if (baos.size() > 0) {
                    stringBuilder.append(new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    baos.reset();
                }
                stringBuilder.append(sInChars[i]);
            }
            return stringBuilder.toString();
        }
        catch (IOException exception) {
            throw new S3EncryptionClientException("Unable to decode S3 object metadata: " + s, exception);
        }
    }

    private static ContentMetadata readFromV3FormatMap(Map<String, String> metadata, GetObjectResponse response) {
        MaterialsDescription materialsDescription;
        Map<String, String> encryptionContext;
        String jsonString;
        if (!MetadataKeyConstants.isV3Format(metadata)) {
            throw new S3EncryptionClientException("Content metadata is tampered, required metadata to decrypt the object are missing");
        }
        String contentEncryptionAlgorithm = metadata.get("x-amz-c");
        String contentRange = response.contentRange();
        if (!contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY.idAsString())) {
            throw new S3EncryptionClientException("Unknown content encryption algorithm for V3 message format: " + contentEncryptionAlgorithm);
        }
        AlgorithmSuite algorithmSuite = contentRange == null ? AlgorithmSuite.ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY : AlgorithmSuite.ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY;
        String keyProviderId = "S3Keyring";
        byte[] edkCiphertext = DECODER.decode(metadata.get("x-amz-3"));
        String keyProviderInfo = MetadataKeyConstants.decompressWrappingAlgorithm(metadata.get("x-amz-w"));
        EncryptedDataKey edk = EncryptedDataKey.builder().encryptedDataKey(edkCiphertext).keyProviderId("S3Keyring").keyProviderInfo(keyProviderInfo).build();
        if (keyProviderInfo.equals("kms+context")) {
            jsonString = metadata.getOrDefault("x-amz-t", "{}");
            encryptionContext = ContentMetadataDecodingStrategy.decodeAndParseJsonString(jsonString);
            materialsDescription = MaterialsDescription.builder().build();
        } else {
            jsonString = metadata.getOrDefault("x-amz-m", "{}");
            materialsDescription = MaterialsDescription.builder().putAll(ContentMetadataDecodingStrategy.decodeAndParseJsonString(jsonString)).build();
            encryptionContext = new HashMap<String, String>();
        }
        byte[] messageId = DECODER.decode(metadata.get("x-amz-i"));
        byte[] keyCommitment = DECODER.decode(metadata.get("x-amz-d"));
        return ContentMetadata.builder().algorithmSuite(algorithmSuite).encryptedDataKey(edk).encryptionContext(encryptionContext).materialsDescription(materialsDescription).contentMessageId(messageId).contentRange(contentRange).keyCommitment(keyCommitment).build();
    }

    private static Map<String, String> decodeAndParseJsonString(String jsonEncryptionContext) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        String decodedJsonEncryptionContext = ContentMetadataDecodingStrategy.decodeS3CustomEncoding(jsonEncryptionContext);
        try {
            JsonNodeParser parser = JsonNodeParser.create();
            JsonNode objectNode = parser.parse(decodedJsonEncryptionContext);
            for (Map.Entry entry : objectNode.asObject().entrySet()) {
                jsonMap.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonMap;
    }

    private static ContentMetadata readFromMapV1V2(Map<String, String> metadata, GetObjectResponse response) {
        MaterialsDescription materialsDescription;
        Map<String, String> encryptionContext;
        String keyProviderInfo;
        byte[] edkCiphertext;
        AlgorithmSuite algorithmSuite;
        if (!MetadataKeyConstants.isV1Format(metadata) && !MetadataKeyConstants.isV2Format(metadata)) {
            throw new S3EncryptionClientException("Content metadata is tampered, required metadata to decrypt the object are missing");
        }
        String contentEncryptionAlgorithm = metadata.get("x-amz-cek-alg");
        String contentRange = response.contentRange();
        if (contentEncryptionAlgorithm == null || contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF.cipherName())) {
            algorithmSuite = AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF;
        } else if (contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherName())) {
            algorithmSuite = contentRange == null ? AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF : AlgorithmSuite.ALG_AES_256_CTR_IV16_TAG16_NO_KDF;
        } else {
            throw new S3EncryptionClientException("Unknown content encryption algorithm for V2 message format: " + contentEncryptionAlgorithm);
        }
        String keyProviderId = "S3Keyring";
        switch (algorithmSuite) {
            case ALG_AES_256_CBC_IV16_NO_KDF: {
                if (metadata.containsKey("x-amz-key")) {
                    edkCiphertext = DECODER.decode(metadata.get("x-amz-key"));
                } else if (metadata.containsKey("x-amz-key-v2")) {
                    edkCiphertext = DECODER.decode(metadata.get("x-amz-key-v2"));
                } else {
                    throw new S3EncryptionClientException("Malformed object metadata! Could not find the encrypted data key.");
                }
                if (!metadata.containsKey("x-amz-wrap-alg")) {
                    if (edkCiphertext.length > 48) {
                        keyProviderInfo = "RSA";
                        break;
                    }
                    keyProviderInfo = "AES";
                    break;
                }
                keyProviderInfo = metadata.get("x-amz-wrap-alg");
                break;
            }
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_256_CTR_IV16_TAG16_NO_KDF: {
                int tagLength = Integer.parseInt(metadata.get("x-amz-tag-len"));
                if (tagLength != algorithmSuite.cipherTagLengthBits()) {
                    throw new S3EncryptionClientException("Expected tag length (bits) of: " + algorithmSuite.cipherTagLengthBits() + ", got: " + tagLength);
                }
                edkCiphertext = DECODER.decode(metadata.get("x-amz-key-v2"));
                keyProviderInfo = metadata.get("x-amz-wrap-alg");
                break;
            }
            default: {
                throw new S3EncryptionClientException("Unknown content encryption algorithm: " + algorithmSuite.id());
            }
        }
        EncryptedDataKey edk = EncryptedDataKey.builder().encryptedDataKey(edkCiphertext).keyProviderId("S3Keyring").keyProviderInfo(keyProviderInfo).build();
        String jsonEncryptionContext = metadata.getOrDefault("x-amz-matdesc", "{}");
        Map<String, String> matDescMap = ContentMetadataDecodingStrategy.decodeAndParseJsonString(jsonEncryptionContext);
        if (keyProviderInfo.contains("kms")) {
            encryptionContext = matDescMap;
            materialsDescription = MaterialsDescription.builder().build();
        } else {
            materialsDescription = MaterialsDescription.builder().putAll(matDescMap).build();
            encryptionContext = new HashMap<String, String>();
        }
        byte[] iv = DECODER.decode(metadata.get("x-amz-iv"));
        return ContentMetadata.builder().algorithmSuite(algorithmSuite).encryptedDataKey(edk).encryptionContext(encryptionContext).materialsDescription(materialsDescription).contentIv(iv).contentRange(contentRange).build();
    }

    public Map<String, String> loadInstructionFileMetadata(GetObjectRequest request) {
        ResponseInputStream<GetObjectResponse> instruction;
        String instructionFileSuffix = request.overrideConfiguration().flatMap(config -> config.executionAttributes().getOptionalAttribute(S3EncryptionClient.CUSTOM_INSTRUCTION_FILE_SUFFIX)).orElse(".instruction");
        GetObjectRequest instructionGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(request.bucket()).key(request.key() + instructionFileSuffix).build();
        try {
            instruction = this.instructionFileConfig_.getInstructionFile(instructionGetObjectRequest);
        }
        catch (CompletionException | NoSuchKeyException | S3EncryptionClientException exception) {
            throw new S3EncryptionClientException("Exception encountered while fetching Instruction File. Ensure the object you are attempting to decrypt has been encrypted using the S3 Encryption Client and instruction files are enabled.", (Throwable)exception);
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        JsonNodeParser parser = JsonNodeParser.create();
        JsonNode objectNode = parser.parse(instruction);
        for (Map.Entry entry : objectNode.asObject().entrySet()) {
            metadata.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
        }
        return metadata;
    }

    public static boolean isV1V2InObjectMetadata(Map<String, String> objectMetadata) {
        return objectMetadata.containsKey("x-amz-iv") && (objectMetadata.containsKey("x-amz-key") || objectMetadata.containsKey("x-amz-key-v2"));
    }

    public static boolean isV3InObjectMetadata(Map<String, String> objectMetadata) {
        return objectMetadata.containsKey("x-amz-3") && objectMetadata.containsKey("x-amz-d") && objectMetadata.containsKey("x-amz-i") && objectMetadata.containsKey("x-amz-c");
    }

    public static boolean isV3InInstructionFile(Map<String, String> objectMetadata) {
        return objectMetadata.containsKey("x-amz-c") && objectMetadata.containsKey("x-amz-d") && objectMetadata.containsKey("x-amz-i") && !objectMetadata.containsKey("x-amz-3");
    }

    public ContentMetadata decodeV1V2FromInstructionFile(GetObjectRequest request, GetObjectResponse response) {
        Map<String, String> instructionFileMetadata = this.loadInstructionFileMetadata(request);
        return ContentMetadataDecodingStrategy.readFromMapV1V2(instructionFileMetadata, response);
    }

    public ContentMetadata decodeV3FromInstructionFile(GetObjectRequest request, GetObjectResponse response) {
        Map<String, String> instructionFileMetadata = this.loadInstructionFileMetadata(request);
        if (instructionFileMetadata.containsKey("x-amz-c") || instructionFileMetadata.containsKey("x-amz-d") || instructionFileMetadata.containsKey("x-amz-i")) {
            throw new S3EncryptionClientSecurityException("Instruction file is tampered, instruction file contains object metadata exclusive mapkeys");
        }
        HashMap<String, String> mergedMetadata = new HashMap<String, String>(instructionFileMetadata);
        mergedMetadata.put("x-amz-c", (String)response.metadata().get("x-amz-c"));
        mergedMetadata.put("x-amz-d", (String)response.metadata().get("x-amz-d"));
        mergedMetadata.put("x-amz-i", (String)response.metadata().get("x-amz-i"));
        return ContentMetadataDecodingStrategy.readFromV3FormatMap(mergedMetadata, response);
    }

    public ContentMetadata decode(GetObjectRequest request, GetObjectResponse response) {
        Map objectMetadata = response.metadata();
        if (objectMetadata != null) {
            if (ContentMetadataDecodingStrategy.isV1V2InObjectMetadata(objectMetadata)) {
                return ContentMetadataDecodingStrategy.readFromMapV1V2(objectMetadata, response);
            }
            if (ContentMetadataDecodingStrategy.isV3InObjectMetadata(objectMetadata)) {
                return ContentMetadataDecodingStrategy.readFromV3FormatMap(objectMetadata, response);
            }
            if (ContentMetadataDecodingStrategy.isV3InInstructionFile(objectMetadata)) {
                return this.decodeV3FromInstructionFile(request, response);
            }
        }
        return this.decodeV1V2FromInstructionFile(request, response);
    }
}

